/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.hire;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;
import kd.tsc.tsirm.common.dto.hire.HireVerifyResult;

public class HireApprovalSubmitValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        this.handleSubmit();
    }

    private void handleSubmit() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List affFilList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getDynamicObject("appfile").getLong("id")).collect(Collectors.toList());
        HireVerifyResult hireVerifyResult = HireApprovalService.verifySubmitList(affFilList);
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            this.addHireErrorMessage(dataEntity2, hireVerifyResult);
        }
    }

    private void addHireErrorMessage(ExtendedDataEntity dataEntity, HireVerifyResult verifyResult) {
        DynamicObject appFileDyn = (DynamicObject)dataEntity.getValue("appfile");
        Long appFileId = appFileDyn.getLong("id");
        if (verifyResult.getFailAppFileId().contains(appFileId)) {
            List failReasons = (List)verifyResult.getFailReason().get(appFileId);
            for (String failReason : failReasons) {
                this.addFatalErrorMessage(dataEntity, failReason);
            }
        }
    }
}

