/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.intv;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.BosUserServiceHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntervEvalHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckResultEntity;
import kd.tsc.tsirm.common.enums.TSIRMPreDataEnum;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbs.common.utils.Num2ChUtils;
import org.apache.commons.lang3.StringUtils;

public class ArgIntvValidator
extends HRDataBaseValidator {
    public static boolean checkAdmindivisionNameByName(String admindivisionName, String admindivisionId) {
        return !HRStringUtils.isBlank((CharSequence)admindivisionName) || ArgIntvValidator.checkAdminDivision(admindivisionId) || ArgIntvValidator.checkSpecialAdmindivision(admindivisionName);
    }

    public static boolean checkSpecialAdmindivision(String admindivisionName) {
        return admindivisionName.contains(ResManager.loadKDString((String)"\u9999\u6e2f", (String)"HongKong", (String)"tsc-tsirm-opplugin", (Object[])new Object[0])) || admindivisionName.contains(ResManager.loadKDString((String)"\u6fb3\u95e8", (String)"Macao", (String)"tsc-tsirm-opplugin", (Object[])new Object[0])) || admindivisionName.contains(ResManager.loadKDString((String)"\u53f0\u6e7e", (String)"Taiwan", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.entityKey = "tsirm_argintv";
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArgIntvHelper argIntvHelper = new ArgIntvHelper();
        String errorMessage1 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9762\u8bd5\u4fe1\u606f\u201d\u3002", (String)"ArgIntvValidator_13", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
        boolean ifValidatePass = true;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String intvThemeNotEmpty;
            String intvContentNotEmpty;
            boolean interviewer;
            String tipThemeNotEmpty;
            String tipContentNotEmpty;
            boolean candidate;
            String receThemeNotEmpty;
            String receContentNotEmpty;
            boolean b;
            DynamicObject round;
            DynamicObjectCollection groupList;
            DynamicObject entity = dataEntity.getDataEntity();
            if (Objects.isNull(entity)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)errorMessage1, (String)"ArgIntvValidator_13", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                ifValidatePass = false;
                continue;
            }
            DynamicObjectCollection roundList = entity.getDynamicObjectCollection("tsirm_intvroundentry");
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)roundList)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)errorMessage1, (String)"ArgIntvValidator_13", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                ifValidatePass = false;
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(groupList = (round = (DynamicObject)roundList.get(0)).getDynamicObjectCollection("tsirm_intvgroupentry")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)errorMessage1, (String)"ArgIntvValidator_13", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                ifValidatePass = false;
            }
            int groupListSize = groupList.size();
            for (int i = 0; i < groupListSize; ++i) {
                DynamicObject object = (DynamicObject)groupList.get(i);
                if (this.isIntverNull(object)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c{0}\u7ec4\u9762\u8bd5\u5b98", (String)"ArgIntvValidator_141", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{Num2ChUtils.toCH((int)(i + 1))}));
                    ifValidatePass = false;
                    continue;
                }
                if (!this.isIntverOverMaxSize(object)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c{0}\u7ec4\u6700\u591a\u53ef\u9009\u62e9{1}\u4e2a\u9762\u8bd5\u5b98\u3002", (String)"ArgIntvValidator_42", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{Num2ChUtils.toCH((int)(i + 1)), 10}));
                ifValidatePass = false;
            }
            if (!HRObjectUtils.isEmpty((Object)round.getDynamicObject("interviewmethod"))) {
                if (TSIRMPreDataEnum.KEY_1010.getId().equals(round.getDynamicObject("interviewmethod").getLong("id"))) {
                    if (groupList.stream().anyMatch(this::isAddressDetailNull)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9762\u8bd5\u5730\u5740\u201d\u3002", (String)"ArgIntvValidator_32", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                        ifValidatePass = false;
                    }
                } else if (TSIRMPreDataEnum.KEY_1040.getId().equals(round.getDynamicObject("interviewmethod").getLong("id"))) {
                    if (groupList.stream().anyMatch(this::isCadidateVideoAddrNull)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5019\u9009\u4eba\u7684\u89c6\u9891\u9762\u8bd5\u5730\u5740\u3002", (String)"ArgIntvValidator_16", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                        ifValidatePass = false;
                    }
                    if (groupList.stream().anyMatch(this::isIntverVideoAddrNull)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9762\u8bd5\u5b98\u89c6\u9891\u9762\u8bd5\u5730\u5740\u3002", (String)"ArgIntvValidator_17", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                        ifValidatePass = false;
                    }
                }
            }
            if (groupList.stream().anyMatch(this::isIntvStartTimeNull)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9762\u8bd5\u65f6\u95f4\u201d\u3002", (String)"ArgIntvValidator_18", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                ifValidatePass = false;
            }
            if (groupList.stream().anyMatch(this::isIntvEndTimeNull)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9762\u8bd5\u65f6\u957f\u201d\u3002", (String)"ArgIntvValidator_19", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                ifValidatePass = false;
            }
            if (groupList.stream().anyMatch(this::isIntvTimeRangeOverCurrent)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u5728\u6709\u6548\u8303\u56f4\u5185", (String)"ArgIntvValidator_31", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                ifValidatePass = false;
            }
            if (!(b = this.validateReception(dataEntity, entity, receContentNotEmpty = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63a5\u5f85\u4eba\u90ae\u4ef6\u5185\u5bb9\u3002", (String)"ArgIntvValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), receThemeNotEmpty = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63a5\u5f85\u4eba\u90ae\u4ef6\u4e3b\u9898\u3002", (String)"ArgIntvValidator_5", (String)"tsc-tsirm-opplugin", (Object[])new Object[0])))) {
                ifValidatePass = false;
            }
            if (!(candidate = this.validateCandidate(dataEntity, entity, tipContentNotEmpty = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5019\u9009\u4eba\u90ae\u4ef6\u5185\u5bb9\u3002", (String)"ArgIntvValidator_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), tipThemeNotEmpty = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5019\u9009\u4eba\u90ae\u4ef6\u4e3b\u9898\u3002", (String)"ArgIntvValidator_6", (String)"tsc-tsirm-opplugin", (Object[])new Object[0])))) {
                ifValidatePass = false;
            }
            if (!(interviewer = this.validateInterviewer(dataEntity, entity, intvContentNotEmpty = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9762\u8bd5\u5b98\u90ae\u4ef6\u5185\u5bb9\u3002", (String)"ArgIntvValidator_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), intvThemeNotEmpty = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9762\u8bd5\u5b98\u90ae\u4ef6\u4e3b\u9898\u3002", (String)"ArgIntvValidator_7", (String)"tsc-tsirm-opplugin", (Object[])new Object[0])))) {
                ifValidatePass = false;
            }
            DynamicObject newEntity = argIntvHelper.selectIntvStatusById(Long.valueOf(entity.getLong("id")));
            String interviewstatus = newEntity.getString("interviewstatus");
            if (!HRObjectUtils.isEmpty((Object)newEntity) && !"A".equals(interviewstatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9762\u8bd5\u4e0d\u53ef\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"ArgIntvValidator_43", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                ifValidatePass = false;
            }
            if (this.validateStat(dataEntity, entity)) continue;
            ifValidatePass = false;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!ifValidatePass) continue;
            this.mustPhoneOREmail(dataEntity, dataEntity.getDataEntity());
        }
    }

    public boolean validateStat(ExtendedDataEntity dataEntity, DynamicObject entity) {
        IntvCheckResultEntity checkIntvevlState;
        boolean result = true;
        IntvCheckResultEntity checkIntvStateRes = IntvCheckHelper.checkIntvState((Long)entity.getLong("id"));
        if (!checkIntvStateRes.isCheckResult()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9762\u8bd5\u5df2\u5b8c\u6210\u6216\u5df2\u53d6\u6d88\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"ArgIntvValidator_8", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]));
            result = false;
        }
        List checkIntvCandateStateRes = IntvCheckHelper.checkIntvCandateState((DynamicObject)entity);
        for (int i = 0; i < checkIntvCandateStateRes.size(); ++i) {
            if (((IntvCheckResultEntity)checkIntvCandateStateRes.get(i)).isCheckResult()) continue;
            this.addErrorMessage(dataEntity, ((IntvCheckResultEntity)checkIntvCandateStateRes.get(i)).getCheckMessage());
            result = false;
        }
        IntvCheckResultEntity intvCheckResult = IntvCheckHelper.checkIntvStartTime((Long)entity.getLong("id"));
        if (!intvCheckResult.isCheckResult()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9762\u8bd5\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u4fee\u6539", (String)"ArgIntvValidator_9", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]));
            result = false;
        }
        if (!(checkIntvevlState = IntvCheckHelper.checkIntvevlState((Long)entity.getLong("id"))).isCheckResult()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9762\u8bd5\u5df2\u5b58\u5728\u8bc4\u4ef7\u4e0d\u53ef\u4fee\u6539\u3002", (String)"ArgIntvValidator_10", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]));
            result = false;
        }
        return result;
    }

    public boolean isIntverVideoAddrNull(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        String intverVideoAddr = group.getString("intvervedioaddress");
        return StringUtils.isEmpty((CharSequence)intverVideoAddr);
    }

    public boolean isCadidateVideoAddrNull(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        String cadidateVideoAddr = group.getString("candatevedioaddress");
        return StringUtils.isEmpty((CharSequence)cadidateVideoAddr);
    }

    public static boolean checkAdminDivision(String adminDivisionId) {
        boolean res = HRStringUtils.isNotEmpty((String)adminDivisionId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bd_admindivision");
        DynamicObject adminDivision = helper.loadSingle((Object)adminDivisionId);
        int level = adminDivision.getInt("level");
        if (level < 2 && !adminDivision.getBoolean("iscity")) {
            res = false;
        }
        return res;
    }

    public boolean isIntvLocationNull(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        String intvLocation = group.getString("interviewlocation");
        return StringUtils.isEmpty((CharSequence)intvLocation);
    }

    public boolean isAddressDetailNull(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        DynamicObject addressDetail = group.getDynamicObject("addressdetail");
        return addressDetail == null;
    }

    public boolean isIntvEndTimeNull(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        int intvStartTime = group.getInt("intvstarttime");
        int intvEndTime = group.getInt("intvendtime");
        return 0 == intvEndTime || intvEndTime == intvStartTime;
    }

    public boolean isIntvStartTimeNull(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        Date intvDate = group.getDate("intvdate");
        return Objects.isNull(intvDate);
    }

    public boolean isIntvTimeRangeOverCurrent(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        long intvStartTime = group.getLong("intvstarttime");
        long intvEndTime = group.getLong("intvendtime");
        Date date = group.getDate("intvdate");
        if (!Objects.isNull(date)) {
            Date intvDateTimeStart = IntvDateUtil.getIntvDateTime((Date)date, (Long)intvStartTime);
            Date intvDateTimeEnd = IntvDateUtil.getIntvDateTime((Date)date, (Long)intvEndTime);
            return intvDateTimeStart.before(new Date()) || intvDateTimeEnd.before(new Date());
        }
        return false;
    }

    public boolean isIntverNull(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        DynamicObjectCollection intverList = group.getDynamicObjectCollection("intver");
        return org.apache.commons.collections.CollectionUtils.isEmpty((Collection)intverList);
    }

    public boolean isIntverOverMaxSize(DynamicObject group) {
        if (Objects.isNull(group)) {
            return true;
        }
        DynamicObjectCollection intverList = group.getDynamicObjectCollection("intver");
        return intverList.size() > 10;
    }

    public boolean validateInterviewer(ExtendedDataEntity dataEntity, DynamicObject entity, String intvContentNotEmpty, String intvThemeNotEmpty) {
        boolean result = true;
        boolean intvNotice = entity.getBoolean("noticeinterviewer");
        boolean intvEmail = entity.getBoolean("intvchkmailsend");
        boolean intvSms = entity.getBoolean("intvchksmssend");
        if (intvNotice && !intvEmail && !intvSms) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u201c\u9762\u8bd5\u5b98\u901a\u77e5\u201d\uff0c\u8bf7\u9009\u62e9\u201c\u901a\u77e5\u65b9\u5f0f\u201d\u3002", (String)"ArgIntvValidator_35", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (intvNotice && intvEmail) {
            int countMatches;
            String interivewer = entity.getString("txtmailinterviewer_tag") == null ? "" : entity.getString("txtmailinterviewer_tag").trim();
            String intvTheme = entity.getString("intetheme") == null ? "" : entity.getString("intetheme").trim();
            if (HRStringUtils.isBlank((CharSequence)(interivewer = interivewer.replace("<p>", "").replace("</p>", "").trim())) || "<p><br></p>".equals(interivewer)) {
                this.addErrorMessage(dataEntity, intvContentNotEmpty);
                result = false;
            }
            if (!HRStringUtils.isBlank((CharSequence)interivewer) && interivewer.length() > 10000) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u90ae\u4ef6\u5185\u5bb9\u8bf7\u4fdd\u6301\u572810000\u5b57\u4ee5\u5185\u3002", (String)"ArgIntvValidator_22", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                result = false;
            }
            if ((countMatches = StringUtils.countMatches((CharSequence)interivewer, (CharSequence)ResManager.loadKDString((String)"{\u9762\u8bd5\u5b89\u6392\u8868}", (String)"ArgIntvValidator_24", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]))) > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9762\u8bd5\u5b98\u90ae\u4ef6\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a{\u9762\u8bd5\u5b89\u6392\u8868}\u3002", (String)"ArgIntvValidator_26", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                result = false;
            }
            if (HRStringUtils.isBlank((CharSequence)intvTheme)) {
                this.addErrorMessage(dataEntity, intvThemeNotEmpty);
                result = false;
            }
        }
        if (intvNotice && intvSms) {
            String interviewerSmsContent;
            String string = interviewerSmsContent = entity.getString("sms_intv_richtext") == null ? "" : entity.getString("sms_intv_richtext").trim();
            if (HRStringUtils.isBlank((CharSequence)interviewerSmsContent)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9762\u8bd5\u5b98\u77ed\u4fe1\u5185\u5bb9\u3002", (String)"ArgIntvValidator_28", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                result = false;
            }
        }
        return result;
    }

    public boolean validateCandidate(ExtendedDataEntity dataEntity, DynamicObject entity, String tipContentNotEmpty, String tipThemeNotEmpty) {
        boolean result = true;
        boolean notice = entity.getBoolean("noticecopiedperson");
        boolean email = entity.getBoolean("candchkmailsend");
        boolean sms = entity.getBoolean("candchksmssend");
        if (notice && !email && !sms) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u201c\u5019\u9009\u4eba\u901a\u77e5\u201d\uff0c\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u201c\u901a\u77e5\u65b9\u5f0f\u201d\u3002", (String)"ArgIntvValidator_36", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (notice && email) {
            String candidate = entity.getString("txtmailcandidate_tag") == null ? "" : entity.getString("txtmailcandidate_tag").trim();
            String copiTheme = entity.getString("copitheme") == null ? "" : entity.getString("copitheme").trim();
            if (HRStringUtils.isBlank((CharSequence)(candidate = candidate.replace("<p>", "").replace("</p>", "").trim())) || "<p><br></p>".equals(candidate)) {
                this.addErrorMessage(dataEntity, tipContentNotEmpty);
                result = false;
            }
            if (!HRStringUtils.isBlank((CharSequence)candidate) && candidate.length() > 10000) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u90ae\u4ef6\u5185\u5bb9\u8bf7\u63a7\u5236\u572810000\u5b57\u4ee5\u5185\u3002", (String)"ArgIntvValidator_23", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                result = false;
            }
            if (HRStringUtils.isBlank((CharSequence)copiTheme)) {
                this.addErrorMessage(dataEntity, tipThemeNotEmpty);
                result = false;
            }
        }
        if (notice && sms) {
            String candidateSmsContent;
            String string = candidateSmsContent = entity.getString("sms_cand_richtext") == null ? "" : entity.getString("sms_cand_richtext").trim();
            if (HRStringUtils.isBlank((CharSequence)candidateSmsContent)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5019\u9009\u4eba\u7684\u77ed\u4fe1\u5185\u5bb9\u3002", (String)"ArgIntvValidator_29", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                result = false;
            }
        }
        return result;
    }

    public boolean validateReception(ExtendedDataEntity dataEntity, DynamicObject entity, String receContentNotEmpty, String receThemeNotEmpty) {
        boolean result = true;
        boolean copiNotice = entity.getBoolean("noticereceptionist");
        boolean copiEmail = entity.getBoolean("recechkmailsend");
        String receptionist = entity.getString("receptionist");
        if (copiNotice && !copiEmail) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u201c\u63a5\u5f85\u4eba\u901a\u77e5\u201d\uff0c\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u201c\u901a\u77e5\u65b9\u5f0f\u201d\u3002", (String)"ArgIntvValidator_34", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isBlank((CharSequence)receptionist) && copiNotice) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u201c\u63a5\u5f85\u4eba\u901a\u77e5\u201d\uff0c\u8bf7\u586b\u5199\u201c\u63a5\u5f85\u4eba\u90ae\u7bb1\u201d\u3002", (String)"ArgIntvValidator_33", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (copiNotice && !HRStringUtils.isBlank((CharSequence)receptionist)) {
            int matches;
            String receTheme;
            String reception = entity.getString("txtmailunawares_tag") == null ? "" : entity.getString("txtmailunawares_tag").trim();
            reception = reception.replace("<p>", "").replace("</p>", "").trim();
            String string = receTheme = entity.getString("recptheme") == null ? "" : entity.getString("recptheme").trim();
            if (HRStringUtils.isBlank((CharSequence)reception) || "<p><br></p>".equals(reception)) {
                this.addErrorMessage(dataEntity, receContentNotEmpty);
                result = false;
            }
            if (HRStringUtils.isNotEmpty((String)reception) && reception.length() > 10000) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63a5\u5f85\u4eba\u90ae\u4ef6\u5185\u5bb9\u8bf7\u63a7\u5236\u572810000\u5b57\u4ee5\u5185\u3002", (String)"ArgIntvValidator_20", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                result = false;
            }
            if ((matches = StringUtils.countMatches((CharSequence)reception, (CharSequence)ResManager.loadKDString((String)"{\u9762\u8bd5\u5b89\u6392\u8868}", (String)"ArgIntvValidator_24", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]))) > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63a5\u5f85\u4eba\u90ae\u4ef6\u5185\u5bb9\u4e2d\u53ea\u80fd\u5305\u542b\u4e00\u4e2a{\u9762\u8bd5\u5b89\u6392\u8868}\u3002", (String)"ArgIntvValidator_25", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                result = false;
            }
            if (HRStringUtils.isBlank((CharSequence)receTheme)) {
                this.addErrorMessage(dataEntity, receThemeNotEmpty);
                result = false;
            }
        }
        return result;
    }

    public boolean admindivisionValidate(DynamicObject entity) {
        boolean admindivisionCheckRes = false;
        if (Objects.isNull(entity)) {
            return admindivisionCheckRes;
        }
        String admindivisionId = entity.getString("admindivision");
        if (StringUtils.isNotEmpty((CharSequence)admindivisionId)) {
            String admindivisionName = IntervEvalHelper.getAdminDivisionName((String)admindivisionId);
            admindivisionCheckRes = ArgIntvValidator.checkAdmindivisionNameByName(admindivisionName, admindivisionId);
        }
        return admindivisionCheckRes;
    }

    private void mustPhoneOREmail(ExtendedDataEntity dataEntity, DynamicObject entity) {
        boolean noticeCandidate = entity.getBoolean("noticecopiedperson");
        boolean candidateEmail = entity.getBoolean("candchkmailsend");
        boolean candidateSms = entity.getBoolean("candchksmssend");
        boolean copiNotice = entity.getBoolean("noticereceptionist");
        boolean copiEmail = entity.getBoolean("recechkmailsend");
        boolean intvNotice = entity.getBoolean("noticeinterviewer");
        boolean intvEmail = entity.getBoolean("intvchkmailsend");
        boolean intvSms = entity.getBoolean("intvchksmssend");
        HashMap<String, List<String>> showResultListMap = new HashMap<String, List<String>>(3);
        DynamicObject roundEntry = (DynamicObject)entity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
        DynamicObjectCollection groupEntry = roundEntry.getDynamicObjectCollection("tsirm_intvgroupentry");
        groupEntry.forEach(entry -> {
            if (noticeCandidate) {
                ArrayList candidateList = Lists.newArrayList();
                DynamicObjectCollection groupCandates = entry.getDynamicObjectCollection("groupcandate");
                groupCandates.forEach(groupCandate -> {
                    DynamicObject appfile = groupCandate.getDynamicObject("fbasedataid");
                    String phone = appfile.getString("phone");
                    String groupCandidateEmail = appfile.getString("email");
                    String appfileName = appfile.getString("name");
                    if (candidateEmail && HRStringUtils.isBlank((CharSequence)groupCandidateEmail)) {
                        candidateList.add(this.setErrorEmailOrPhoneMessage(CfgMsgRecvType.CANDIDATE.getBaseDataId(), "1", appfileName));
                    }
                    if (candidateSms && HRStringUtils.isBlank((CharSequence)phone)) {
                        candidateList.add(this.setErrorEmailOrPhoneMessage(CfgMsgRecvType.CANDIDATE.getBaseDataId(), "2", appfileName));
                    }
                });
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)candidateList)) {
                    this.newOrUpdate(showResultListMap, candidateList, CfgMsgRecvType.CANDIDATE.getBaseDataId());
                }
            }
            if (intvNotice) {
                ArrayList interviewList = Lists.newArrayList();
                DynamicObjectCollection intvInterviewers = entry.getDynamicObjectCollection("intver");
                intvInterviewers.forEach(intvInterviewer -> {
                    DynamicObject bosUserObj = intvInterviewer.getDynamicObject("fbasedataid");
                    DynamicObject bosUser = BosUserServiceHelper.getInstance().getUser(Long.valueOf(bosUserObj.getLong("id")));
                    String interviewerName = bosUser.getString("name");
                    String interviewerEmail = bosUser.getString("email");
                    String phone = bosUser.getString("phone");
                    if (intvEmail && HRStringUtils.isBlank((CharSequence)interviewerEmail)) {
                        interviewList.add(this.setErrorEmailOrPhoneMessage(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), "1", interviewerName));
                    }
                    if (intvSms && HRStringUtils.isBlank((CharSequence)phone)) {
                        interviewList.add(this.setErrorEmailOrPhoneMessage(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), "2", interviewerName));
                    }
                });
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)interviewList)) {
                    this.newOrUpdate(showResultListMap, interviewList, CfgMsgRecvType.INTERVIEWER.getBaseDataId());
                }
            }
        });
        if (copiNotice && copiEmail && HRStringUtils.isBlank((CharSequence)entity.getString("receptionist"))) {
            String errorMessage = ResManager.loadKDString((String)"\u63a5\u5f85\u4eba\u4e3a\u7a7a", (String)"ArgIntvValidator_41", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
            this.newOrUpdate(showResultListMap, Lists.newArrayList((Object[])new String[]{errorMessage}), CfgMsgRecvType.RECEIVER.getBaseDataId());
        }
        if (showResultListMap.isEmpty()) {
            return;
        }
        List candateList = (List)showResultListMap.get(CfgMsgRecvType.CANDIDATE.getBaseDataId());
        List interviewerList = (List)showResultListMap.get(CfgMsgRecvType.INTERVIEWER.getBaseDataId());
        List receiverList = (List)showResultListMap.get(CfgMsgRecvType.RECEIVER.getBaseDataId());
        ArrayList errorMessage = Lists.newArrayList();
        this.addMessage(errorMessage, candateList, interviewerList, receiverList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)errorMessage)) {
            return;
        }
        String message = String.join((CharSequence)"\uff1b\r\n", errorMessage);
        this.addWarningMessage(dataEntity, message);
    }

    @SafeVarargs
    private final void addMessage(List<String> errorMessageList, List<String> ... lists) {
        Arrays.stream(lists).forEach(list -> {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                errorMessageList.addAll((Collection<String>)list);
            }
        });
    }

    private void newOrUpdate(Map<String, List<String>> showResultListMap, List<String> errorInfoList, String key) {
        ArrayList currentList = showResultListMap.get(key);
        if (CollectionUtils.isEmpty(currentList)) {
            currentList = Lists.newArrayList();
        }
        currentList.addAll(errorInfoList);
        HashSet removeDupSet = Sets.newHashSet((Iterable)currentList);
        showResultListMap.put(key, Lists.newArrayList((Iterable)removeDupSet));
    }

    private String setErrorEmailOrPhoneMessage(String personType, String type, String name) {
        if (CfgMsgRecvType.CANDIDATE.getBaseDataId().equals(personType)) {
            if ("1".equals(type)) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5019\u9009\u4eba\u201c{0}\u201d\u7684\u90ae\u7bb1\u5730\u5740\u3002", (String)"ArgIntvValidator_37", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{name});
            }
            if ("2".equals(type)) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5019\u9009\u4eba\u201c{0}\u201d\u7684\u624b\u673a\u53f7\u7801\u3002", (String)"ArgIntvValidator_38", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{name});
            }
        }
        if (CfgMsgRecvType.INTERVIEWER.getBaseDataId().equals(personType)) {
            if ("1".equals(type)) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9762\u8bd5\u5b98\u201c{0}\u201d\u7684\u90ae\u7bb1", (String)"ArgIntvValidator_39", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{name});
            }
            if ("2".equals(type)) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9762\u8bd5\u5b98\u201c{0}\u201d\u7684\u624b\u673a\u53f7\u7801", (String)"ArgIntvValidator_40", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{name});
            }
        }
        return "";
    }
}

