/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.operationmanage;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.common.enums.operationmanage.ActivationStatus;

public class CancelLicenseValidators
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(CancelLicenseValidators.class);

    public void validate() {
        super.validate();
        if (!this.getValidateContext().getValidateResults().getValidateErrors().isEmpty()) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List empIds = Arrays.stream(dataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("employee.id")).collect(Collectors.toList());
        Map allowCancelMap = AppFileHelper.isAllowCancel(empIds);
        LOG.info("CancelLicenseValidators.validate param {} allowCancelMap {}", empIds, (Object)allowCancelMap);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean hasNext = true;
            hasNext = this.checkActivationstatus(dataEntity, hasNext);
            this.checkAppfileStatus(dataEntity, hasNext, allowCancelMap);
        }
    }

    private boolean checkAppfileStatus(ExtendedDataEntity dataEntity, boolean hasNext, Map<Long, Boolean> cancelAppfileMap) {
        long employeeId = dataEntity.getDataEntity().getLong("employee.id");
        if (cancelAppfileMap.containsKey(employeeId) && !cancelAppfileMap.get(employeeId).booleanValue()) {
            hasNext = false;
            DynamicObject employeeObj = dataEntity.getDataEntity().getDynamicObject("employee");
            String messagePrefix = employeeObj.getDynamicObject("person").getString("name") + " " + employeeObj.getString("empnumber") + ": ";
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u8be5\u5458\u5de5\u5e94\u8058\u6d41\u7a0b\u8fd8\u672a\u7ed3\u675f\uff0c\u4e0d\u80fd\u53d6\u6d88\u5f00\u901a", (String)"CancelLicenseValidators_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{messagePrefix}));
            dataEntity.getDataEntity().set("failreason", (Object)ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5e94\u8058\u6d41\u7a0b\u8fd8\u672a\u7ed3\u675f\uff0c\u4e0d\u80fd\u53d6\u6d88\u5f00\u901a\u3002", (String)"CancelLicenseValidators_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{messagePrefix}));
            dataEntity.getDataEntity().set("checkfail", (Object)Boolean.TRUE);
        }
        return hasNext;
    }

    private boolean checkActivationstatus(ExtendedDataEntity dataEntity, Boolean hasNext) {
        if (!hasNext.booleanValue()) {
            return hasNext;
        }
        String activationStatus = dataEntity.getDataEntity().getString("activationstatus");
        if (!ActivationStatus.B.code.equals(activationStatus)) {
            hasNext = false;
            DynamicObject employeeObj = dataEntity.getDataEntity().getDynamicObject("employee");
            String messagePrefix = employeeObj.getDynamicObject("person").getString("name") + " " + employeeObj.getString("empnumber") + ": ";
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u53ea\u80fd\u5bf9\u5f00\u901a\u72b6\u6001\u4e3a\u201c\u5f00\u901a\u6210\u529f\u201d\u7684\u5458\u5de5\u8fdb\u884c\u53d6\u6d88\u5f00\u901a\u3002", (String)"CancelLicenseValidators_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{messagePrefix}));
            dataEntity.getDataEntity().set("failreason", (Object)ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5f00\u901a\u72b6\u6001\u4e3a\u201c\u5f00\u901a\u6210\u529f\u201d\u7684\u5458\u5de5\u8fdb\u884c\u53d6\u6d88\u5f00\u901a\u3002", (String)"CancelLicenseValidators_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            dataEntity.getDataEntity().set("checkfail", (Object)Boolean.TRUE);
        }
        return hasNext;
    }
}

