/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.operationmanage;

import java.text.MessageFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.common.enums.TSIRMPreDataEnum;
import kd.tsc.tsirm.common.enums.operationmanage.ActivationStatus;
import kd.tsc.tsrbs.business.domain.bizperm.impl.BizPermValidateServiceImpl;
import kd.tsc.tsrbs.business.domain.rpc.IHrmpRpcService;
import kd.tsc.tsrbs.business.domain.rpc.impl.HrmpRpcServiceImpl;

public class OpeningLicenseValidators
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(OpeningLicenseValidators.class);
    private static final IHrmpRpcService HRMP_SERVICE = new HrmpRpcServiceImpl();
    private static final String LABRELSTATUSPRD_ID = "labrelstatusprd.id";
    private static final String LABRELSTATUSPRD_NAME = "labrelstatusprd.name";
    private static final String POSITION_LABORRELTYPE_ID = "laborreltype.id";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        if (!this.getValidateContext().getValidateResults().getValidateErrors().isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            boolean hasNext = true;
            hasNext = this.checkActivationstatus(dataEntity, hasNext);
            hasNext = this.checkLaborrelStatus(dataEntity, hasNext);
            this.checkLaborreltypecls(dataEntity, hasNext);
        }
    }

    private boolean checkLaborreltypecls(ExtendedDataEntity dataEntity, boolean hasNext) {
        if (!hasNext) {
            return hasNext;
        }
        DynamicObject employeeObj = dataEntity.getDataEntity().getDynamicObject("employee");
        long laborrelTypeId = employeeObj.getLong(POSITION_LABORRELTYPE_ID);
        Map idMap = BizPermValidateServiceImpl.getInstance().getBizPermConfMap();
        LOG.info("OpeningLicenseValidators.checkLaborreltypecls param {} values {}", (Object)laborrelTypeId, (Object)idMap);
        dataEntity.getDataEntity().set("failreasoncombo", (Object)"1");
        if (!idMap.containsKey(laborrelTypeId)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_laborreltype");
            QFilter qFilter = new QFilter("laborreltypecls", "=", (Object)laborrelTypeId);
            DynamicObject laborrelTypeObj = serviceHelper.queryOne(new QFilter[]{qFilter});
            if (laborrelTypeObj == null) {
                dataEntity.getDataEntity().set("failreason", (Object)("not exit laborrelType by id : " + laborrelTypeId));
            } else {
                String msg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u4e3a\u201c{0}\u201d\uff0c\u4e0d\u80fd\u5f00\u901a\u3002", (String)"OpeningLicenseValidators_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
                dataEntity.getDataEntity().set("failreason", (Object)MessageFormat.format(msg, laborrelTypeObj.getString("name")));
            }
            dataEntity.getDataEntity().set("failreasoncombo", (Object)"0");
            dataEntity.getDataEntity().set("checkfail", (Object)Boolean.TRUE);
            hasNext = false;
        }
        return hasNext;
    }

    private boolean checkLaborrelStatus(ExtendedDataEntity dataEntity, boolean hasNext) {
        if (!hasNext) {
            return hasNext;
        }
        Long employeeId = dataEntity.getDataEntity().getLong("employee.id");
        DynamicObject laborRelStatusObj = HRMP_SERVICE.getEmployeeLaborRelStatus(employeeId);
        LOG.info("OpeningLicenseValidators.checkLaborrelStatus employeeId : {} laborRelStatusObj : {}", (Object)employeeId, (Object)laborRelStatusObj);
        long labrelstatusprdId = laborRelStatusObj.getLong(LABRELSTATUSPRD_ID);
        LOG.info("OpeningLicenseValidators.checkLaborrelStatus labrelstatusprdId {}", (Object)labrelstatusprdId);
        dataEntity.getDataEntity().set("failreasoncombo", (Object)"1");
        if (labrelstatusprdId != TSIRMPreDataEnum.LABRELSTATUSPRD.getId()) {
            String msg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u4e3a\u201c{0}\u201d\uff0c\u4e0d\u80fd\u5f00\u901a\u3002", (String)"OpeningLicenseValidators_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
            dataEntity.getDataEntity().set("failreason", (Object)MessageFormat.format(msg, laborRelStatusObj.getString("name")));
            dataEntity.getDataEntity().set("dataindex", (Object)dataEntity.getDataEntityIndex());
            dataEntity.getDataEntity().set("rowindex", (Object)dataEntity.getRowIndex());
            dataEntity.getDataEntity().set("subrowindex", (Object)dataEntity.getSubRowIndex());
            dataEntity.getDataEntity().set("failreasoncombo", (Object)"0");
            dataEntity.getDataEntity().set("checkfail", (Object)Boolean.TRUE);
            hasNext = false;
        }
        return hasNext;
    }

    private boolean checkActivationstatus(ExtendedDataEntity dataEntity, boolean hasNext) {
        if (!hasNext) {
            return hasNext;
        }
        String activationStatus = dataEntity.getDataEntity().getString("activationstatus");
        if (ActivationStatus.B.code.equals(activationStatus)) {
            DynamicObject employeeObj = dataEntity.getDataEntity().getDynamicObject("employee");
            String messagePrefix = employeeObj.getDynamicObject("person").getString("name") + " " + employeeObj.getString("empnumber") + ": ";
            String tipMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u7ecf\u662f\u5f00\u901a\u6210\u529f\u72b6\u6001\uff0c\u4e0d\u80fd\u91cd\u590d\u5f00\u901a\u3002", (String)"OpeningLicenseValidators_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{messagePrefix});
            this.addFatalErrorMessage(dataEntity, tipMsg);
            hasNext = false;
        }
        return hasNext;
    }
}

