/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.operationmanage;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class OperateEmployeeValidators
extends HRDataBaseValidator {
    public void validate() {
        HRBaseServiceHelper hrBaseServiceHelper;
        Object[] query;
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ExtendedDataEntity dataEntity = dataEntities[0];
        DynamicObject entity = dataEntity.getDataEntity();
        String employees = entity.getString("employees");
        if (StringUtils.isEmpty((CharSequence)employees)) {
            return;
        }
        List employeeIds = SerializationUtils.fromJsonStringToList((String)employees, Long.class);
        if (CollectionUtils.isNotEmpty((Collection)employeeIds) && employeeIds.size() > 10) {
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u914d\u7f6e%s\u4e2a\u8fd0\u8425\u56e2\u961f\u6210\u5458\u3002", (String)"OperateEmployeeValidators_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), 10));
        }
        if (ArrayUtils.isNotEmpty((Object[])(query = (hrBaseServiceHelper = new HRBaseServiceHelper("hrpi_employee")).query("person.name ,laborreltype.laborreltypecls.id ", new QFilter("id", "in", (Object)employeeIds).toArray())))) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object dynamicObject : query) {
                long type = dynamicObject.getLong("laborreltype.laborreltypecls.id");
                if (type == 1010L) continue;
                String name = dynamicObject.getString("person.name");
                stringBuilder.append(name).append("\u3001");
            }
            String errorName = stringBuilder.toString();
            if (StringUtils.isNotBlank((CharSequence)errorName)) {
                String substring = errorName.substring(0, errorName.length() - 1);
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u7528\u5de5\u5173\u7cfb\u9636\u6bb5\u4e3a\u975e\u7528\u5de5\u8fdb\u884c\u4e2d\u3002", (String)"OperateEmployeeValidators_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), substring));
            }
        }
    }
}

