/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.position;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class PositionCommitValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String positionStatus = dataEntity.getDataEntity().getString("positionstatus");
            if (!"B".equals(positionStatus) && this.getOption().containsVariable("operationValue")) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5fc5\u586b\u5b57\u6bb5\u5f55\u5165\u5b8c\u5584\uff0c\u4e14\u6709\u65b0\u589e\u6216\u8005\u4fee\u6539\u5b57\u6bb5\u672a\u63d0\u4ea4\u7684\uff0c\"\u8349\u7a3f\"\u3001\"\u62db\u8058\u4e2d\"\u3001\"\u5df2\u6682\u505c\"\u804c\u4f4d\uff0c\u53ef\u4ee5\u63d0\u4ea4\u5e76\u751f\u6548", (String)"PositionCommitValidator_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            }
            this.validRangeField(dataEntity, "workexpup", "workexpdown", "isworkexplimit", ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5de5\u4f5c\u5e74\u9650\u533a\u95f4\u201d\u3002", (String)"PositionCommitValidator_13", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            this.validRangeField(dataEntity, "ageup", "agedown", "isagelimit", ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5e74\u9f84\u533a\u95f4\u201d\u3002", (String)"PositionCommitValidator_14", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            long recruitNum = dataEntity.getDataEntity().getLong("recruitnum");
            boolean isRecruitNumLimit = dataEntity.getDataEntity().getBoolean("isrecnumlimit");
            if (isRecruitNumLimit || recruitNum > 0L && recruitNum <= 10000L) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u62db\u8058\u4eba\u6570\u201d\u3002", (String)"PositionCommitValidator_15", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void validRangeField(ExtendedDataEntity dataEntity, String rangeUpFields, String rangeDownFields, String limitField, String description) {
        long rangeUp = dataEntity.getDataEntity().getLong(rangeUpFields);
        long rangeDown = dataEntity.getDataEntity().getLong(rangeDownFields);
        boolean isRangeLimit = dataEntity.getDataEntity().getBoolean(limitField);
        if (isRangeLimit) {
            return;
        }
        if (this.validRangeCheck(rangeUp, rangeDown)) {
            this.addMessage(dataEntity, description, ErrorLevel.Error);
        }
    }

    private boolean validRangeCheck(long rangeUp, long rangeDown) {
        return rangeDown > rangeUp && rangeUp != 0L;
    }
}

