/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.position;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionImportValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dyn = dataEntity.getDataEntity();
            this.createOrgCheck(dataEntity);
            this.adminOrgCheck(dataEntity);
            this.reccategoryCheck(dataEntity);
            this.recrusceneCheck(dataEntity);
            if (this.getOption().getVariables().get("operationValue") == null || !HRStringUtils.equals((String)((String)this.getOption().getVariables().get("operationValue")), (String)"true")) continue;
            this.recruprocCheck(dataEntity);
        }
    }

    private void createOrgCheck(ExtendedDataEntity dataEntity) {
        Long orgId;
        List orgs;
        if (dataEntity.getDataEntity().getDynamicObject("createorg") == null) {
            return;
        }
        boolean superUser = PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId());
        if (!superUser && !(orgs = PositionPermService.getInstance(null).getPositionHasPermOrgs()).contains(orgId = Long.valueOf(dataEntity.getDataEntity().getDynamicObject("createorg").getLong("id")))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u6743\u9650\uff0c\u6216\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PositionImportValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void adminOrgCheck(ExtendedDataEntity dataEntity) {
        if (dataEntity.getDataEntity().getDynamicObject("adminorg") == null) {
            return;
        }
        boolean superUser = PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId());
        if (!superUser) {
            Long orgId;
            AuthorizedOrgResult authorizedOrgResult = PositionPermService.getInstance(null).getPositionHasPermAdminOrgs();
            if (authorizedOrgResult.isHasAllOrgPerm()) {
                return;
            }
            List orgs = authorizedOrgResult.getHasPermOrgs();
            if (!orgs.contains(orgId = Long.valueOf(dataEntity.getDataEntity().getDynamicObject("adminorg").getLong("id")))) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u6743\u9650\uff0c\u6216\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PositionImportValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void reccategoryCheck(ExtendedDataEntity dataEntity) {
        DynamicObject reccategory = dataEntity.getDataEntity().getDynamicObject("reccategory");
        if (reccategory == null) {
            return;
        }
        if (!HRStringUtils.equals((String)"1030_S", (String)reccategory.getString("number"))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u62db\u8058\u7c7b\u578b\u201d\u6743\u9650\uff0c\u6216\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PositionImportValidator_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void recrusceneCheck(ExtendedDataEntity dataEntity) {
        DynamicObject recruscene = dataEntity.getDataEntity().getDynamicObject("recruscene");
        if (recruscene == null) {
            return;
        }
        DynamicObjectCollection types = recruscene.getDynamicObjectCollection("recruitmentcategory");
        boolean flag = false;
        for (DynamicObject type : types) {
            DynamicObject dyn = (DynamicObject)type.get("fbasedataid");
            if (!HRStringUtils.equals((String)dyn.getString("number"), (String)"1030_S")) continue;
            flag = true;
        }
        if (!flag) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u62db\u8058\u573a\u666f\u201d\u6743\u9650\uff0c\u6216\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PositionImportValidator_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void recruprocCheck(ExtendedDataEntity dataEntity) {
        DynamicObject manageDyn = PositionManageServiceHelper.getManageInfoByPositionBo((Long)dataEntity.getDataEntity().getLong("id"));
        if (manageDyn == null) {
            return;
        }
        DynamicObject recruitCategory = dataEntity.getDataEntity().getDynamicObject("reccategory");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (recruitCategory != null) {
            qFilter.and("group", "=", (Object)recruitCategory.getLong("id"));
        } else {
            qFilter.and("group", "in", (Object)new Long[]{1030L, 1020L});
        }
        DynamicObject createOrg = dataEntity.getDataEntity().getDynamicObject("createorg");
        if (createOrg != null) {
            QFilter createOrgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_rqmtproc", (Long)createOrg.getLong("id"));
            qFilter.and(createOrgQFilter);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        DynamicObject curRecruproc = manageDyn.getDynamicObject("recruproc");
        if (curRecruproc == null) {
            return;
        }
        boolean flag = false;
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (curRecruproc.getLong("id") != dynamicObject.getLong("id")) continue;
                flag = true;
            }
        }
        if (!flag) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u62db\u8058\u6d41\u7a0b\u201d\u6743\u9650\uff0c\u6216\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PositionImportValidator_4", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }
}

