/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.position;

import java.util.Arrays;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionStatusChangeValidator
extends HRDataBaseValidator {
    private static final String[] billStatus = new String[]{"A", "B", "D", "G"};

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        String operateKey = this.getOperateKey();
        block12: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject manageDyn;
            DynamicObjectCollection posprins;
            Optional<DynamicObject> posprin;
            DynamicObject positionDyn = PositionDataHelper.getPositionObjByPositionId((Long)dataEntity.getDataEntity().getLong("id"));
            if (positionDyn == null) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"PositionStatusChangeValidator_7", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                return;
            }
            String pageName = dataEntity.getDataEntity().getDynamicObjectType().getName();
            if ((HRStringUtils.equals((String)"tsirm_position_delivery", (String)pageName) || HRStringUtils.equals((String)"tsirm_positiondel_view", (String)pageName)) && !(posprin = (posprins = (manageDyn = PositionManageServiceHelper.getManageInfoByPositionBo((Long)dataEntity.getDataEntity().getLong("id"))).getDynamicObjectCollection("posprin")).stream().filter(pos -> pos.get("fbasedataid.id").equals(TSCRequestContext.getUserId())).findFirst()).isPresent()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u62db\u8058\u804c\u4f4d\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionStatusChangeValidator_8", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                continue;
            }
            String positionStatus = positionDyn.getString("positionstatus");
            String status = positionDyn.getString("status");
            switch (operateKey) {
                case "stop_donothing": {
                    this.showStopMessage(dataEntity, positionStatus);
                    continue block12;
                }
                case "posstart_donothing": {
                    this.showStartMessage(dataEntity, status, positionStatus);
                    continue block12;
                }
                case "posclose_donothing": 
                case "finish_donothing": 
                case "posclose_notips": {
                    this.showCloseMessage(dataEntity, status, positionStatus);
                    continue block12;
                }
            }
        }
    }

    private void showStopMessage(ExtendedDataEntity dataEntity, String positionStatus) {
        if (!"A".equals(positionStatus)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u62db\u8058\u4e2d\u201d\u7684\u62db\u8058\u804c\u4f4d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionStatusChangeValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void showStartMessage(ExtendedDataEntity dataEntity, String status, String positionStatus) {
        if (!"C".equals(positionStatus)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u5df2\u6682\u505c\u201d\u7684\u62db\u8058\u804c\u4f4d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionStatusChangeValidator_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void showCloseMessage(ExtendedDataEntity dataEntity, String status, String positionStatus) {
        if (!"A".equals(positionStatus) && !"C".equals(positionStatus)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u62db\u8058\u4e2d/\u5df2\u6682\u505c\u201d\u7684\u62db\u8058\u804c\u4f4d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionStatusChangeValidator_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            return;
        }
        if (Arrays.asList(billStatus).contains(status)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u7533\u8bf7\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionStatusChangeValidator_5", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }
}

