/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.stdrsm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.application.external.person.BizHRPIEmployeeService;

public class ReservereSaveValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(ReservereSaveValidator.class);

    public void validate() {
        List allErrorInfo;
        super.validate();
        List stdRsmIdList = Arrays.stream(this.dataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("stdrsm")).collect(Collectors.toList());
        DynamicObject[] stdRsmDys = StandardResumeDataHelper.batchQuerySelectFieldsyById(stdRsmIdList, (String)"empid");
        HashMap<Long, Long> stdRsmIdlabrelstatusclsMap = new HashMap<Long, Long>(stdRsmDys.length);
        ArrayList empIdList = Lists.newArrayListWithCapacity((int)stdRsmDys.length);
        int length = this.dataEntities.length;
        for (DynamicObject stdRsmDy : stdRsmDys) {
            long empId = stdRsmDy.getLong("empid");
            empIdList.add(empId);
            stdRsmIdlabrelstatusclsMap.put(stdRsmDy.getLong("id"), empId);
        }
        Map<Long, DynamicObject> stdRsmMap = Arrays.stream(stdRsmDys).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        String formId = this.getOption().getVariableValue("formId");
        Map result = BizHRPIEmployeeService.getEmployeeStatus((List)empIdList);
        try {
            allErrorInfo = ((ValidateResult)this.getValidateContext().getValidateResults().getValidateErrors().get(0)).getAllErrorInfo();
        }
        catch (Exception e) {
            allErrorInfo = new ArrayList();
        }
        LOG.info("get employee status  " + SerializationUtils.toJsonString((Object)result));
        for (ExtendedDataEntity reservereEntity : this.dataEntities) {
            boolean isOutWork;
            if (HRStringUtils.isBlank((CharSequence)formId)) continue;
            DynamicObject reservereDy = reservereEntity.getDataEntity();
            Long stdRsmId = reservereDy.getLong("stdrsm");
            Long empId = (Long)stdRsmIdlabrelstatusclsMap.get(stdRsmId);
            DynamicObject stdRsmDy = stdRsmMap.get(stdRsmId);
            allErrorInfo.forEach(errorInfo -> {
                Object pkValue = errorInfo.getPkValue();
                if (reservereDy.getLong("id") != Long.parseLong(pkValue.toString())) {
                    return;
                }
                String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u50a8\u5907\u81f3%s\uff08%s\uff09\uff0c\u65e0\u9700\u91cd\u590d\u50a8\u5907\u3002", (String)"ReservereSaveValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), stdRsmDy.getString("fullname"), reservereDy.getDynamicObject("talentpool").getString("name"), reservereDy.getDynamicObject("talentpool").getString("number"));
                errorInfo.setMessage(errorMsg + "\n");
            });
            DynamicObject dynamicObject2 = (DynamicObject)result.get(empId);
            boolean equals = "tsirm_stdrsm_onjob".equals(formId);
            boolean bl = isOutWork = null == dynamicObject2 || dynamicObject2.getLong("labrelstatusprd_id") == Long.parseLong("1020");
            if (!isOutWork || !equals) continue;
            TalentListFunService.saveOneReserveRecord((Long)stdRsmId, (Long)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED);
            if (length == 1) {
                this.addErrorMessage(reservereEntity, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ReservereSaveValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                continue;
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff08%s\uff09\uff1a\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ReservereSaveValidator_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), stdRsmDy.getString("fullname"), stdRsmDy.getString("number"));
            this.addErrorMessage(reservereEntity, errorMsg + "\n");
        }
    }
}

