/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.application;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.utils.CastUtils;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsirm.common.util.IntvDateUtil;

public class InterviewApplicationService {
    private static final Log LOG = LogFactory.getLog(InterviewApplicationService.class);

    public Map<String, Object> getInterviewRecord(List<Long> employeeIdList, Date start, Date end) {
        if (CollectionUtils.isEmpty(employeeIdList) || start == null || end == null) {
            LOG.error("params is empty ,please check!!!!");
            return Maps.newHashMap();
        }
        DynamicObject[] stdRsmIdByEmployees = StdRsmServiceHelper.getStdRsmIdByEmployees(employeeIdList);
        if (null == stdRsmIdByEmployees || stdRsmIdByEmployees.length == 0) {
            LOG.error(String.format("params employee %s have not stdrsm,please check", Arrays.toString(employeeIdList.toArray())));
            return Maps.newHashMap();
        }
        Map<Long, Long> stdIdEmployeeMap = Arrays.stream(stdRsmIdByEmployees).collect(Collectors.toMap(dynamic -> dynamic.getLong("id"), dynamic -> dynamic.getLong("empid")));
        List<Long> stdRsmIdList = Arrays.stream(stdRsmIdByEmployees).map(dynamic -> dynamic.getLong("id")).collect(Collectors.toList());
        DynamicObject[] appFiles = AppFileHelper.getAppFileByStdRsmAndDelivery(stdRsmIdList);
        if (null == appFiles || appFiles.length == 0) {
            List list2 = stdRsmIdList.stream().map(String::valueOf).collect(Collectors.toList());
            LOG.error(String.format("params stdid %s have not appfile,please check", String.join((CharSequence)",", list2)));
            return Maps.newHashMap();
        }
        Map<Long, Long> appFileStdIdMap = Arrays.stream(appFiles).collect(Collectors.toMap(dynamic -> dynamic.getLong("id"), dynamic -> dynamic.getLong("stdrsm_id")));
        Map<Long, DynamicObject> appFileMap = Arrays.stream(appFiles).collect(Collectors.toMap(dynamic -> dynamic.getLong("id"), dynamic -> dynamic, (v1, v2) -> v1));
        List<Long> appFileIdList = Arrays.stream(appFiles).map(dynamic -> dynamic.getLong("id")).collect(Collectors.toList());
        DynamicObject[] appFileStatusRecByFileId = AppFileHelper.getAppFileStatusRecByFileId(appFileIdList);
        if (null == appFileStatusRecByFileId || appFileStatusRecByFileId.length == 0) {
            LOG.error(String.format("params employee %s have not appFileStatusRec,please check", Arrays.toString(employeeIdList.toArray())));
            return Maps.newHashMap();
        }
        ArrayList appFileStatusDynamicList = Lists.newArrayListWithCapacity((int)appFileStatusRecByFileId.length);
        Map<Long, List<DynamicObject>> appFileGroupStatusRercordMap = Arrays.stream(appFileStatusRecByFileId).collect(Collectors.groupingBy(dynamic -> dynamic.getLong("appfile_id")));
        appFileGroupStatusRercordMap.forEach((appFileId, list) -> {
            list = list.stream().sorted(Comparator.comparing(dynamic -> dynamic.getDate("operatetime"), Comparator.reverseOrder())).collect(Collectors.toList());
            DynamicObject nowStatusDynamic = (DynamicObject)list.get(0);
            String nowNewFileStatus = nowStatusDynamic.getString("newfilestatus");
            if (AppFileStatusEnum.EXPIRED.getValue().equals(nowNewFileStatus) || AppFileStatusEnum.IN_PROCESS.getValue().equals(nowNewFileStatus)) {
                return;
            }
            List suitableList = list.stream().filter(dynamicObject -> AppFileStatusEnum.IN_PROCESS.getValue().equals(dynamicObject.getString("oldfilestatus")) && (AppFileStatusEnum.OUT.getValue().equals(dynamicObject.getString("newfilestatus")) || AppFileStatusEnum.TBEMP.getValue().equals(dynamicObject.getString("newfilestatus")))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(suitableList = suitableList.stream().sorted(Comparator.comparing(dynamic -> dynamic.getDate("operatetime"), Comparator.reverseOrder())).collect(Collectors.toList()))) {
                return;
            }
            DynamicObject suitableFile = (DynamicObject)suitableList.get(0);
            if (suitableFile.getDate("operatetime").getTime() >= start.getTime() && suitableFile.getDate("operatetime").getTime() <= end.getTime()) {
                appFileStatusDynamicList.add(suitableFile);
            }
        });
        if (CollectionUtils.isEmpty((Collection)appFileStatusDynamicList)) {
            LOG.error(String.format("params employee %s have not suitable appFileStatusRec,please check", Arrays.toString(employeeIdList.toArray())));
            return Maps.newHashMap();
        }
        appFileStatusRecByFileId = appFileStatusDynamicList.toArray(new DynamicObject[0]);
        Map<Long, List<DynamicObject>> appFileGroupMap = Arrays.stream(appFileStatusRecByFileId).collect(Collectors.groupingBy(dynamic -> dynamic.getLong("appfile_id")));
        HashMap resultMap = Maps.newHashMap();
        appFileMap.forEach((id, dynamic) -> {
            List dynamicObjects = (List)appFileGroupMap.get(id);
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                return;
            }
            DynamicObject fileChangeDynamic = (DynamicObject)dynamicObjects.get(0);
            Long stdRsmId = (Long)appFileStdIdMap.get(id);
            if (null == stdRsmId || 0L == stdRsmId) {
                return;
            }
            Long employeeId = (Long)stdIdEmployeeMap.get(stdRsmId);
            if (null == employeeId || 0L == employeeId) {
                return;
            }
            Object resultObj = resultMap.get(String.valueOf(employeeId));
            HashMap data = Maps.newHashMap();
            List<Map<String, Object>> maps = CastUtils.castDynamicToMap(new DynamicObject[]{dynamic});
            Map<String, Object> map = maps.get(0);
            String operateTime = fileChangeDynamic.getDate("operatetime") == null ? null : HRInteDateTimeUtil.formatDate((String)"tsirm_appfilestatusrectpl", (String)"operatetime", (Date)fileChangeDynamic.getDate("operatetime"));
            map.put("operatetime", operateTime);
            String applyTime = map.get("applytime") == null ? null : (map.get("applytime") instanceof Date ? HRInteDateTimeUtil.formatDate((String)"tsirm_appfilemdl", (String)"applytime", (Date)((Date)map.get("applytime"))) : map.get("applytime").toString());
            map.put("applytime", applyTime);
            if (null == resultObj) {
                data.put("data", Lists.newArrayList((Object[])new Map[]{map}));
                resultMap.put(String.valueOf(employeeId), data);
            } else {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(resultObj), Map.class);
                Object o = dataMap.get("data");
                List dataList = Lists.newArrayList();
                if (null != o) {
                    dataList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(o), ArrayList.class);
                }
                dataList.add(map);
                data.put("data", dataList);
                resultMap.put(String.valueOf(employeeId), data);
            }
        });
        return resultMap;
    }

    public Map<String, Object> getInterviewDetail(Long appFileId) {
        DynamicObject appFile = TsrbsHelper.selectById(appFileId, "tsirm_appfilemdl");
        if (null == appFile) {
            return Maps.newHashMap();
        }
        String selectProperties = "intvgroup.id,application.id,round.interviewtheme.id,round.interviewstage.id,intvgroup.intvstarttime,intvgroup.intvdate,intvevlstatus";
        List<DynamicObject> appFileTasks = TsrbsHelper.selectByFilter(selectProperties, new QFilter[]{new QFilter("application", "=", (Object)appFileId)}, "tsirm_appfiletask");
        if (CollectionUtils.isEmpty(appFileTasks)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        ArrayList dataList = Lists.newArrayList();
        appFileTasks.forEach(appFileTask -> {
            HashMap data = Maps.newHashMap();
            List<DynamicObject> evlInfoList = IntvEvlHelper.getInstance().selectIntvEvaluationByGroupIdAndApplicationId(appFileTask.getLong("intvgroup.id"), appFileTask.getLong("application.id"));
            String totalResult = appFileTask.getString("intvevlstatus");
            long recId = appFileTask.getLong("round.interviewstage.id");
            long interviewTypId = appFileTask.getLong("round.interviewtheme.id");
            String intDate = HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)appFileTask.getDate("intvgroup.intvdate"));
            String startTime = IntvDateUtil.formatTime((Long)appFileTask.getLong("intvgroup.intvstarttime"), (String)"HH:mm:ss");
            List<DynamicObject> sortIntEvl = evlInfoList.stream().sorted(Comparator.comparing(intvEvl -> intvEvl.getLong("id"))).sorted(Comparator.comparingLong(intvEvl -> intvEvl.getDynamicObject("interviewer").getLong("id"))).collect(Collectors.toList());
            ArrayList evlInfoMapList = Lists.newArrayList();
            sortIntEvl.forEach(evaluation -> {
                DynamicObject interviewer = evaluation.getDynamicObject("interviewer");
                String interviewerName = interviewer.getString("name");
                String content = evaluation.getString("interviewcontent");
                String intvResult = evaluation.getString("intvevlrslt");
                Date evaluateDate = evaluation.getDate("interviewevaluationtime");
                HashMap evlMap = Maps.newHashMap();
                evlMap.put("interviewerName", interviewerName);
                evlMap.put("content", content);
                evlMap.put("intvResult", intvResult);
                evlMap.put("evaluateDate", evaluateDate);
                evlMap.put("evlid", evaluation.getString("id"));
                QFilter qFilter = new QFilter("id", "=", (Object)evaluation.getLong("round.id"));
                List<DynamicObject> intvRoundList = TsrbsHelper.selectByFilter("roundid, interviewevl", qFilter.toArray(), "tsirm_intvroundtpl");
                if (!CollectionUtils.isEmpty(intvRoundList)) {
                    evlMap.put("evltableid", intvRoundList.get(0).getLong("interviewevl"));
                }
                evlInfoMapList.add(evlMap);
            });
            data.put("interviewTime", intDate + " " + startTime);
            data.put("interviewRecId", recId);
            data.put("interviewType", interviewTypId);
            data.put("interviewTotalResult", totalResult);
            data.put("interviewInfoList", evlInfoMapList);
            dataList.add(data);
        });
        result.put(String.valueOf(appFileId), dataList);
        return result;
    }
}

