/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.application.external;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ExtGptService {
    private static final Log LOG = LogFactory.getLog(ExtGptService.class);
    private static final ExtGptService EXT_GPT_SERVICE = new ExtGptService();
    private static final String GPT_DATA_KEY = "data";
    private static final String GPT_RESULT_KEY = "llmValue";
    private static final String ERROR_CODE = "errCode";
    public static final String TIPS_DELETE_CODE = "ai.gai.10009";
    private static final Long GPT_GROUP_ID = 606L;

    private ExtGptService() {
    }

    public static ExtGptService getInstance() {
        return EXT_GPT_SERVICE;
    }

    public Map<String, Object> syncCall(long gptId, String input, Map<String, String> param) {
        if (HRStringUtils.isBlank((CharSequence)input)) {
            input = ResManager.loadKDString((String)"\u751f\u6210", (String)"ExtGptService_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
        }
        long start = System.currentTimeMillis();
        Map map = (Map)HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])new Object[]{gptId, input, param});
        LOG.info("ExtGptService invoke GPT cost  " + (System.currentTimeMillis() - start));
        return map;
    }

    public String getSyncGPTResult(long gptId, String input, Map<String, String> param) {
        LOG.info(String.format("ExtGptService getSyncGPTResult gpt  %d  input %s ,param %s,", gptId, input, JSONObject.toJSONString(param)));
        Map<String, Object> map = this.syncCall(gptId, input, param);
        if (null == map || map.isEmpty()) {
            LOG.error(String.format("GPT result is empty by gpt ID %s and input %s", gptId, input));
            return "";
        }
        LOG.info(String.format("ExtGptService getSyncGPTResult gpt result %s", JSONObject.toJSONString(map)));
        Object errorCodeObj = map.get(ERROR_CODE);
        if (TIPS_DELETE_CODE.equals(errorCodeObj)) {
            return TIPS_DELETE_CODE;
        }
        Object statusObject = map.get("status");
        if (null == statusObject || !((Boolean)statusObject).booleanValue()) {
            LOG.error(String.format("GPT result status is  empty by gpt ID %s and input %s and result is %s", gptId, input, SerializationUtils.toJsonString(map)));
            return "";
        }
        Object dataObject = map.get(GPT_DATA_KEY);
        if (null == dataObject) {
            LOG.error(String.format("GPT result data is error by gpt ID %s and input %s and result is %s", gptId, input, SerializationUtils.toJsonString(map)));
            return "";
        }
        JSONObject dataJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataObject));
        return dataJson.getString(GPT_RESULT_KEY);
    }

    public Boolean isHaveGPTCert() {
        long userId = RequestContext.get().getCurrUserId();
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)GPT_GROUP_ID);
        if (null == licenseCheckResult) {
            return false;
        }
        return licenseCheckResult.getHasLicense();
    }
}

