/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AdvBillTplDataHelper {
    private static final HRBaseServiceHelper ADVBILLTPLDATAHELPER = new HRBaseServiceHelper("tsirm_advertbill");

    private AdvBillTplDataHelper() {
    }

    public static AdvBillTplDataHelper getInstance() {
        return AdvBillTplDataHelperHolder.ADVBILLTPLDATAHELPER;
    }

    public DynamicObject generateEmptyAdvertBill() {
        return ADVBILLTPLDATAHELPER.generateEmptyDynamicObject();
    }

    public void saveAdvertBill(DynamicObject advertBill) {
        if (Objects.isNull(advertBill)) {
            return;
        }
        ADVBILLTPLDATAHELPER.saveOne(advertBill);
    }

    public void updateBill(DynamicObject advertBill) {
        if (!HRObjectUtils.isEmpty((Object)advertBill)) {
            ADVBILLTPLDATAHELPER.updateDataOne(advertBill);
        }
    }

    public DynamicObject genAdvBillByAdvertEdit(DynamicObject advert) {
        if (HRObjectUtils.isEmpty((Object)advert)) {
            return null;
        }
        DynamicObject advertBill = this.generateEmptyAdvertBill();
        String number = CodeRuleServiceHelper.getNumber((String)"tsirm_advertbill", (DynamicObject)advertBill, null);
        advertBill.set("billstatus", (Object)"A");
        advertBill.set("auditstatus", (Object)"A");
        advertBill.set("billno", (Object)number);
        String billName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5e7f\u544a\u7533\u8bf7\u5355", (String)"AdvertTplExCommonHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), advert.getString("name"));
        advertBill.set("name", (Object)billName);
        DynamicObjectCollection currencyColl = advertBill.getDynamicObjectCollection("adminorgs");
        advertBill.set("adminorg", (Object)advert.getDynamicObject("position").getDynamicObject("adminorg"));
        advertBill.set("advertbuorg", (Object)advert.getDynamicObject("position").getDynamicObject("createorg"));
        advertBill.set("position", (Object)advert.getDynamicObject("position"));
        DynamicObject channel = advert.getDynamicObject("channel");
        advertBill.set("category", (Object)channel.getString("name"));
        advertBill.set("creator", (Object)TSCRequestContext.getUserId());
        advertBill.set("modifier", (Object)TSCRequestContext.getUserId());
        DynamicObjectCollection billEntity = advertBill.getDynamicObjectCollection("entryentity");
        DynamicObject billEntry = billEntity.addNew();
        HRDynamicObjectUtils.copy((DynamicObject)advert, (DynamicObject)billEntry);
        billEntry.set("entityname", (Object)advert.getString("name"));
        billEntry.set("advertid", (Object)advert.getLong("id"));
        return advertBill;
    }

    public DynamicObject saveAdvBillByAdvertEdit(DynamicObject advert) {
        DynamicObject advertBill = this.genAdvBillByAdvertEdit(advert);
        this.saveAdvertBill(advertBill);
        return advertBill;
    }

    public DynamicObject queryAdvertBillWFNodeById(Long billId) {
        return ADVBILLTPLDATAHELPER.queryOne("id,nownode,nownodeauditor", (Object)billId);
    }

    public void deleteBillWhenTest(Long advertId) {
        QFilter of = QFilter.of((String)"entryentity.advertid = ? and billstatus in (?, ?, ?)", (Object[])new Object[]{advertId, "B", "D", "G"});
        ADVBILLTPLDATAHELPER.deleteByFilter(of.toArray());
    }

    private static class AdvBillTplDataHelperHolder {
        private static final AdvBillTplDataHelper ADVBILLTPLDATAHELPER = new AdvBillTplDataHelper();

        private AdvBillTplDataHelperHolder() {
        }
    }
}

