/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AdvHisChannelHelper {
    private static Log LOGGER = LogFactory.getLog(AdvHisChannelHelper.class);
    private static DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    private AdvHisChannelHelper() {
    }

    public static List<Long> getHisChannelByUser(String posCategoryNumber) {
        List channelList;
        try {
            long userId = TSCRequestContext.getUserId();
            String key = posCategoryNumber + "&" + userId;
            String channelStr = (String)CACHE.get(key);
            channelList = HRStringUtils.isEmpty((String)channelStr) ? AdvHisChannelHelper.getHisChannelByPosCategory(posCategoryNumber) : (List)SerializationUtils.deSerializeFromBase64((String)channelStr);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u9009\u62e9\u6e20\u9053\u5386\u53f2\u5931\u8d25", (Throwable)e);
            return null;
        }
        return channelList;
    }

    public static List<Long> getHisChannelByPosCategory(String posCategoryNumber) {
        String key = posCategoryNumber;
        String channelStr = (String)CACHE.get(key);
        if (HRStringUtils.isEmpty((String)channelStr)) {
            return null;
        }
        List channelList = (List)SerializationUtils.deSerializeFromBase64((String)channelStr);
        return channelList;
    }

    public static void putHisChannel(String posCategoryNumber, List<Long> channelList) {
        try {
            long userId = TSCRequestContext.getUserId();
            String key = posCategoryNumber + "&" + userId;
            String keyWithNoUser = posCategoryNumber;
            String value = SerializationUtils.serializeToBase64(channelList);
            CACHE.put(key, (Object)value, 30, TimeUnit.DAYS);
            CACHE.put(keyWithNoUser, (Object)value, 30, TimeUnit.DAYS);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u9009\u62e9\u6e20\u9053\u5386\u53f2\u5931\u8d25", (Throwable)e);
        }
    }

    public static void removeHisSelect(String posCategoryNumber) {
        try {
            long userId = TSCRequestContext.getUserId();
            String key = posCategoryNumber + "&" + userId;
            String keyWithNoUser = posCategoryNumber;
            CACHE.remove(new String[]{key, keyWithNoUser});
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u9009\u62e9\u6e20\u9053\u5386\u53f2\u5931\u8d25", (Throwable)e);
        }
    }
}

