/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvBillTplDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPublishHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExCommonHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;
import kd.tsc.tsirm.common.enums.advert.ChannelFieldEnum;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class AdvertApprovalHelper {
    private static final Log LOGGER = LogFactory.getLog(AdvertApprovalHelper.class);
    private static final String MODULE = AdvertApprovalHelper.class.getName();
    private static final String OP_SUBMIT_VALIDATE = "submitvalidate";
    private static AdvertApprovalDataHelper approvalDataHelper = AdvertApprovalDataHelper.getInstance();

    private AdvertApprovalHelper() {
    }

    public static DynamicObject loadOne(Long approvalId) {
        return approvalDataHelper.loadSingle(approvalId);
    }

    public static boolean existById(Object approvalId) {
        return approvalDataHelper.isExists(approvalId);
    }

    public static void setCommonDataFormSnap(IFormView view, DynamicObject approval) {
        DynamicObjectCollection advSnaps = approval.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)advSnaps)) {
            return;
        }
        DynamicObject snap = (DynamicObject)advSnaps.get(0);
        DynamicObject advert = view.getModel().getDataEntity(true);
        AdvertPublishHelper.setPosOrgAndBu(view, approval);
        AdvertTplExCommonHelper.advertCopySrcToDest(advert, snap, null, false);
        DynamicObject position = approval.getDynamicObject("position");
        view.getModel().setValue("position", (Object)position.getLong("id"));
        for (DynamicObject advSnap : advSnaps) {
            long channelId = advSnap.getLong("channel_id");
            if (ChannelFieldEnum.isAutoPubAndClose((long)channelId)) continue;
            advert.set("startdate", (Object)advSnap.getDate("startdate"));
            advert.set("enddate", (Object)advSnap.getDate("enddate"));
        }
    }

    public static List<Long> getAllChannelBySnaps(DynamicObject approval) {
        ArrayList<Long> channelIds = new ArrayList<Long>();
        DynamicObjectCollection advSnaps = approval.getDynamicObjectCollection("entryentity");
        for (DynamicObject advSnap : advSnaps) {
            channelIds.add(advSnap.getLong("channel_id"));
        }
        return channelIds;
    }

    public static DynamicObject getAdvByChannelSnap(DynamicObject approval, Long channelId) {
        DynamicObjectCollection advSnaps = approval.getDynamicObjectCollection("entryentity");
        for (DynamicObject advSnap : advSnaps) {
            DynamicObject channel = advSnap.getDynamicObject("channel");
            if (channel.getLong("id") != channelId.longValue()) continue;
            return advSnap;
        }
        return null;
    }

    private static QFilter advertApprovalFilter(String startTime, String endTime) {
        QFilter qFilter1 = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{"creator", "id"}), "=", (Object)TSCRequestContext.getUserId());
        QFilter qFilter2 = new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"B", "G", "D"}));
        QFilter retQFilter = qFilter1.and(qFilter2);
        if (HRStringUtils.isNotEmpty((String)startTime)) {
            retQFilter.and(new QFilter("createtime", ">=", (Object)LocalDateTime.parse(startTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        if (HRStringUtils.isNotEmpty((String)endTime)) {
            retQFilter.and(new QFilter("createtime", "<=", (Object)LocalDateTime.parse(endTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        QFilter position = AdvertTplExDataHelper.getAdvertPositionPerm("position");
        QFilter recruitTypeQFilter = new QFilter("entryentity.reccategory.id", "=", (Object)1030L);
        return retQFilter.and(position).and(recruitTypeQFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapperAdvertSnapsForSave(DynamicObject pageApproval, DynamicObject baseInfo, Map<Long, DynamicObject> channelDataMap) {
        if (HRObjectUtils.isEmpty((Object)pageApproval)) {
            return;
        }
        Long approvalId = pageApproval.getLong("id");
        DynamicObject approval = AdvertApprovalHelper.loadOne(approvalId);
        DynamicObjectCollection advertSnapList = approval.getDynamicObjectCollection("entryentity");
        for (DynamicObject advertSnap : advertSnapList) {
            DynamicObject channel = advertSnap.getDynamicObject("channel");
            DynamicObject channelFlexData = channelDataMap.get(channel.getLong("id"));
            AdvertTplExCommonHelper.advertCopySrcToDest(advertSnap, baseInfo, channelFlexData, true);
        }
        try (TXHandle tx = TX.required();){
            AdvBillTplDataHelper.getInstance().saveAdvertBill(approval);
            approvalDataHelper.snapWriteBackToAdvert(approval);
        }
    }

    public static boolean assembleApprovalSnapByPage(IFormView approvalDetailView, BeforeDoOperationEventArgs args) {
        IFormView publishView = AdvertPublishHelper.getPageFromCache(approvalDetailView, "cachePublicPageId");
        if (null == publishView) {
            return false;
        }
        boolean validResult = AdvertPublishHelper.validateOperator(publishView, approvalDetailView);
        if (!validResult) {
            args.setCancel(true);
            return false;
        }
        OperationResult operationResult = publishView.invokeOperation(OP_SUBMIT_VALIDATE);
        if (null != operationResult) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            AtomicBoolean ifReturn = new AtomicBoolean(false);
            Optional.ofNullable(allErrorOrValidateInfo).filter(list -> list.size() > 0).ifPresent(errorList -> {
                approvalDetailView.showOperationResult(operationResult);
                args.setCancel(true);
                ifReturn.set(true);
            });
            if (ifReturn.get()) {
                return false;
            }
        }
        DynamicObject baseInfo = publishView.getModel().getDataEntity(true);
        Map<Long, DynamicObject> channelData = AdvertApprovalHelper.getChannelData(publishView);
        DynamicObject approval = approvalDetailView.getModel().getDataEntity(true);
        AdvertApprovalHelper.wrapperAdvertSnapsForSave(approval, baseInfo, channelData);
        approvalDetailView.getModel().updateCache();
        return true;
    }

    private static Map<Long, DynamicObject> getChannelData(IFormView publishView) {
        Map allCache = publishView.getPageCache().getAll();
        HashMap<Long, DynamicObject> channelData = new HashMap<Long, DynamicObject>(allCache.size());
        for (Map.Entry entry : allCache.entrySet()) {
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith("cache_channel_page_id_")) continue;
            String pageId = (String)entry.getValue();
            long channelId = Long.parseLong(cacheKey.replace("cache_channel_page_id_", ""));
            Object[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
            if (ArrayUtils.isEmpty((Object[])fieldsByChannel)) {
                channelData.put(channelId, null);
                continue;
            }
            IFormView channelView = publishView.getView(pageId);
            DynamicObject childInfo = channelView.getModel().getDataEntity(true);
            channelData.put(channelId, childInfo);
        }
        return channelData;
    }

    public static void solveApprovalCallBack(IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("editadvert".equals(actionId)) {
            view.activate();
            String returnData = (String)closedCallBackEvent.getReturnData();
            if (HRStringUtils.isEmpty((String)returnData)) {
                returnData = view.getPageCache().get("datachange");
            }
            if (HRStringUtils.isNotEmpty((String)returnData)) {
                view.invokeOperation("refresh");
            }
            if (!HRStringUtils.equals((String)"1", (String)returnData) && !HRStringUtils.equals(null, (String)returnData)) {
                view.showSuccessNotification(returnData);
            }
            view.getPageCache().remove("datachange");
        } else if ("close_approval_detail".equals(actionId)) {
            view.activate();
            String returnData = (String)closedCallBackEvent.getReturnData();
            view.invokeOperation("refresh");
            if (HRStringUtils.isNotEmpty((String)returnData)) {
                view.showSuccessNotification(returnData);
            }
        }
    }

    public static void loadPublishAdvPage(IFormView view) {
        OperationStatus status = view.getFormShowParameter().getStatus();
        String approvalId = AdvertApprovalHelper.getApprovalId(view);
        if (HRStringUtils.isBlank((CharSequence)approvalId)) {
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tsirm_advertpublish_inh");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("advertpubflex");
        showParameter.setCustomParam("approvalid", (Object)approvalId);
        showParameter.setStatus(status);
        BillOperationStatus billOperationStatus = BillOperationStatus.VIEW;
        if (status.getValue() == OperationStatus.EDIT.getValue()) {
            billOperationStatus = BillOperationStatus.EDIT;
        }
        showParameter.setBillStatus(billOperationStatus);
        view.getPageCache().put("cachePublicPageId", showParameter.getPageId());
        view.showForm((FormShowParameter)showParameter);
    }

    private static String getApprovalId(IFormView view) {
        String approvalId = (String)view.getFormShowParameter().getCustomParam("businessKey");
        if (HRStringUtils.isEmpty((String)approvalId)) {
            approvalId = view.getModel().getDataEntity().getString("id");
        }
        if (HRStringUtils.isEmpty((String)approvalId)) {
            LOGGER.error(ResManager.loadKDString((String)"\u5e7f\u544a\u5ba1\u6279\u5355\u7f16\u7801\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)(MODULE + "_0"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        return approvalId;
    }
}

