/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvBillTplDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.valid.FieldValidHelper;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.common.constants.advert.AdvertConstants;
import kd.tsc.tsirm.common.enums.advert.ChannelFieldEnum;
import kd.tsc.tsirm.common.util.CommonUtils;
import kd.tsc.tsrbd.business.domain.recruscene.service.RecruSceneService;
import kd.tsc.tsrbs.business.domain.commrec.service.CommrecBaseHelper;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class AdvertBusinessHelper {
    private static final String MODULE = AdvertBusinessHelper.class.getName();
    private static AdvertBizService advertBizService = AdvertBizService.getInstance();
    protected static final String CUSTOM_STYLE = "eyJ0eXBlIjowLCJjb250ZW50IjoiJCB7XG4gd2lkdGg6IDEwNnB4ICFpbXBvcnRhbnQ7XG59In0=";

    private AdvertBusinessHelper() {
    }

    public static boolean checkPositionOpen(DynamicObject position) {
        DynamicObject newPosition = PositionDataHelper.queryOneByPositionId(position.getLong("id"));
        if (HRObjectUtils.isEmpty((Object)newPosition)) {
            return false;
        }
        String positionStatus = newPosition.getString("positionstatus");
        return HRStringUtils.equals((String)positionStatus, (String)"A") || HRStringUtils.equals((String)positionStatus, (String)"C");
    }

    public static Pair<Boolean, String> checkPositionAudit(DynamicObject advOrBill) {
        DynamicObject position;
        if (advOrBill.containsProperty("channel")) {
            long channelId = advOrBill.getLong("channel.id");
            boolean channelIdIsEnable = AdvertBizService.getInstance().getChannelIdIsEnable(channelId);
            if (!channelIdIsEnable) {
                return Pair.of((Object)false, (Object)ResManager.loadKDString((String)"\u6e20\u9053\u5df2\u7981\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6e20\u9053\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdvertTplExCommonHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            }
        }
        if (HRObjectUtils.isEmpty((Object)(position = advOrBill.getDynamicObject("position")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)(MODULE + "_2"), (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        String positionStatus = (position = PositionDataHelper.queryOneByPositionId(position.getLong("id"))).getString("positionstatus");
        if (HRStringUtils.equals((String)positionStatus, (String)"C")) {
            return Pair.of((Object)true, (Object)ResManager.loadKDString((String)"\u804c\u4f4d\u4e3a\u6682\u505c\u72b6\u6001\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\u7f16\u8f91\u5e7f\u544a\u3002", (String)(MODULE + "_0"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)positionStatus, (String)"D")) {
            return Pair.of((Object)false, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62db\u8058\u804c\u4f4d\u72b6\u6001\u4e3a\u201c\u62db\u8058\u4e2d/\u5df2\u6682\u505c\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)(MODULE + "_1"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        return Pair.of((Object)true, (Object)"");
    }

    public static void setAdvertPageData(IFormView formView, FieldValidHelper validHelper) {
        OperationStatus pageStatus = IntrecoPageHelper.getPageStatus(formView);
        IDataModel model = formView.getModel();
        if (pageStatus.getValue() == OperationStatus.VIEW.getValue()) {
            formView.setVisible(Boolean.FALSE, AdvertConstants.FLEX_RANGE_EDIT);
            formView.setVisible(Boolean.TRUE, AdvertConstants.FLEX_RANGE_DETAIL);
            String salaryShowText = validHelper.getSalaryShowText();
            if (HRStringUtils.isNotEmpty((String)salaryShowText)) {
                model.setValue("salaryshow", (Object)salaryShowText);
            } else {
                formView.setVisible(Boolean.TRUE, new String[]{"salaryflex"});
                formView.setVisible(Boolean.FALSE, new String[]{"issalarynego", "salaryshow"});
                IntrecoPageHelper.asyncUpdateCustomStyle(formView, CUSTOM_STYLE, "salarydown", "salaryup");
            }
            String workexpShowText = validHelper.getWorkexpShowText();
            if (HRStringUtils.isNotEmpty((String)workexpShowText)) {
                model.setValue("workexpshow", (Object)workexpShowText);
            } else {
                formView.setVisible(Boolean.TRUE, new String[]{"workexpflex"});
                formView.setVisible(Boolean.FALSE, new String[]{"isworkexplimit", "workexpshow"});
                IntrecoPageHelper.asyncUpdateCustomStyle(formView, CUSTOM_STYLE, "workexpdown", "workexpup");
            }
            String educationShowText = validHelper.getEducationShowText();
            model.setValue("educationshow", (Object)educationShowText);
            String recruitNumShowText = validHelper.getRecruitNumShowText();
            model.setValue("recruitnumshow", (Object)recruitNumShowText);
        } else if (pageStatus.getValue() == OperationStatus.EDIT.getValue()) {
            formView.setVisible(Boolean.TRUE, AdvertConstants.FLEX_RANGE_EDIT);
            formView.setVisible(Boolean.TRUE, new String[]{"isworkexplimit", "issalarynego"});
            formView.setVisible(Boolean.FALSE, AdvertConstants.FLEX_RANGE_DETAIL);
            IntrecoPageHelper.asyncUpdateCustomStyle(formView, "", "workexpdown", "workexpup", "salarydown", "salaryup");
        }
    }

    public static Long newAdvBillByAdv(DynamicObject queryAdvert) {
        DynamicObject newAdvertBill = AdvBillTplDataHelper.getInstance().saveAdvBillByAdvertEdit(queryAdvert);
        long advertId = queryAdvert.getLong("id");
        AdvertDetailExDataHelper.getInstance().updateByNewAdvBill(newAdvertBill, advertId, "A");
        return newAdvertBill.getLong("id");
    }

    public static void previewAdvert(IFormView view, Long advertId) {
        DynamicObject advertDetail = AdvertDetailExDataHelper.getInstance().queryAdvertDetail(advertId);
        if (!HRStringUtils.equals((String)advertDetail.getString("advertstatus"), (String)"S") || !HRStringUtils.equals((String)advertDetail.getString("advertisementrd"), (String)"A")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5e7f\u544a\u53d1\u5e03\u72b6\u6001\u53ca\u53d1\u5e03\u65b9\u5f0f\u662f\u5426\u6b63\u786e", (String)(MODULE + "_2"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        String advWeblink = String.format("?formId=%s&pkId=%s&from=%s", "tsirp_intrecoadvdetail", advertId, "from_preview");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_previewadv");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("advweblink", (Object)advWeblink);
        view.showForm(showParameter);
    }

    public static void isRewardSwitch(String name, ChangeData changeData, IFormView formView) {
        if (StringUtils.equals((CharSequence)name, (CharSequence)"isreward")) {
            Boolean isShow = (Boolean)changeData.getNewValue();
            if (isShow.booleanValue()) {
                formView.setVisible(Boolean.TRUE, new String[]{"reward", "rewardcurrency"});
                formView.setEnable(Boolean.TRUE, new String[]{"reward", "rewardcurrency"});
            } else {
                formView.setVisible(Boolean.FALSE, new String[]{"reward", "rewardcurrency"});
            }
        }
    }

    public static void showCustomConfirm(String detailMessage, AbstractFormPlugin formPlugin, IFormView formView) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("datachange", (IFormPlugin)formPlugin);
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        formView.showConfirm(msg, detailMessage, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
    }

    public static List<Long> removeRecRuceneId(List<Long> recRuceneIds) {
        DynamicObject[] recRucenes = RecruSceneService.getSceneByIds(recRuceneIds);
        ArrayList rightIds = Lists.newArrayListWithExpectedSize((int)recRuceneIds.size());
        block0: for (DynamicObject dynamicObject : recRucenes) {
            DynamicObjectCollection recruitmentCategories = dynamicObject.getDynamicObjectCollection("recruitmentcategory");
            for (DynamicObject recruitmentCategory : recruitmentCategories) {
                long baseDataId = recruitmentCategory.getLong("fbasedataid_id");
                if (baseDataId != 1030L) continue;
                rightIds.add(dynamicObject.getLong("id"));
                continue block0;
            }
        }
        return rightIds;
    }

    public static QFilter getAdvListDefaultFilter() {
        QFilter defaultFilter = new QFilter("reccategory", "=", (Object)1030L);
        return defaultFilter.and(new QFilter("channel", "!=", (Object)1180L));
    }

    public static void changeChannelRangeDate(String name, IFormView publishView) {
        if (HRStringUtils.equals((String)"startdate", (String)name) || HRStringUtils.equals((String)"enddate", (String)name)) {
            Map allCache = publishView.getPageCache().getAll();
            for (Map.Entry entry : allCache.entrySet()) {
                Date date;
                IDataModel channelModel;
                long channelId;
                IFormView channelView;
                if (!((String)entry.getKey()).startsWith("cache_channel_page_id_") || null == (channelView = publishView.getView((String)entry.getValue())) || !ChannelFieldEnum.isAutoPubAndClose((long)(channelId = ((Long)(channelModel = channelView.getModel()).getValue("channel_id")).longValue())) || null != (date = (Date)channelModel.getValue(name))) continue;
                channelModel.setValue(name, publishView.getModel().getValue(name));
                publishView.sendFormAction(channelView);
            }
        }
    }

    public static void tipPositionStop(IFormView view, DynamicObject advert) {
        Pair<Boolean, String> result = AdvertBusinessHelper.checkPositionAudit(advert);
        if (((Boolean)result.getLeft()).booleanValue() && HRStringUtils.isNotEmpty((String)((String)result.getRight()))) {
            view.showTipNotification((String)result.getRight());
        }
    }

    public static DynamicObject[] queryPubAdvertForJob(Date now) {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)4);
        filters.add(new QFilter("advertstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "E"})));
        filters.add(new QFilter("startdate", "<=", (Object)CommonUtils.getBeginDate((Date)now)));
        Date lastDate = HRDateTimeUtils.addDay((Date)now, (long)-1L);
        filters.add(new QFilter("startdate", ">", (Object)CommonUtils.getEndDate((Date)lastDate)));
        filters.add(new QFilter("approvestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"Z", "C"})));
        DynamicObject[] pubAdvList = AdvertDetailExDataHelper.getInstance().getAdvertListByFilter(filters.toArray(new QFilter[0]), null);
        return pubAdvList;
    }

    public static void sendSystemAdvertNotice(Map<Long, List<DynamicObject>> modifierMap, boolean isEnable) {
        if (MapUtils.isEmpty(modifierMap)) {
            return;
        }
        modifierMap.forEach((modifier, advertList) -> AdvertBusinessHelper.doMessagePublish(modifier, advertList, isEnable));
    }

    private static void doMessagePublish(Long userId, List<DynamicObject> advertList, boolean isEnable) {
        if (CollectionUtils.isEmpty(advertList)) {
            return;
        }
        String title = isEnable ? ResManager.loadKDString((String)"\u81ea\u52a8\u53d1\u5e03\u5e7f\u544a\u6267\u884c\u7ed3\u679c", (String)(MODULE + "_0"), (String)"tsc-tsirm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u81ea\u52a8\u505c\u7528\u5e7f\u544a\u6267\u884c\u7ed3\u679c", (String)(MODULE + "_1"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        int size = advertList.size();
        int errorNum = 0;
        int successNum = 0;
        if (isEnable) {
            for (DynamicObject adv : advertList) {
                if (HRStringUtils.equals((String)adv.getString("advertstatus"), (String)"S")) {
                    ++successNum;
                    continue;
                }
                if (!HRStringUtils.equals((String)adv.getString("advertstatus"), (String)"E")) continue;
                ++errorNum;
            }
        } else {
            for (DynamicObject adv : advertList) {
                if (HRStringUtils.equals((String)adv.getString("advertstatus"), (String)"D")) {
                    ++successNum;
                    continue;
                }
                if (!HRStringUtils.equals((String)adv.getString("advertstatus"), (String)"S")) continue;
                ++errorNum;
            }
        }
        String opName = ResManager.loadKDString((String)"\u53d1\u5e03", (String)(MODULE + "_7"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        if (!isEnable) {
            opName = ResManager.loadKDString((String)"\u505c\u7528", (String)(MODULE + "_8"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        String content = size == successNum ? String.format(ResManager.loadKDString((String)"\u4eca\u65e5\u5171%s%d\u6761\u5e7f\u544a\uff0c\u5176\u4e2d%d\u6761%s\u6210\u529f\uff01", (String)(MODULE + "_4"), (String)"tsc-tsirm-business", (Object[])new Object[0]), opName, size, successNum, opName) : (size == errorNum ? String.format(ResManager.loadKDString((String)"\u4eca\u65e5\u5171%s%d\u6761\u5e7f\u544a\uff0c\u5176\u4e2d%d\u6761%s\u5931\u8d25\uff01", (String)(MODULE + "_5"), (String)"tsc-tsirm-business", (Object[])new Object[0]), opName, size, errorNum, opName) : String.format(ResManager.loadKDString((String)"\u4eca\u65e5\u5171%s%d\u6761\u5e7f\u544a\uff0c\u5176\u4e2d%d\u6761%s\u6210\u529f\uff0c%d\u6761%s\u5931\u8d25\uff01", (String)(MODULE + "_6"), (String)"tsc-tsirm-business", (Object[])new Object[0]), opName, size, successNum, opName, errorNum, opName));
        String url = isEnable ? UrlService.getDomainContextUrl() + "/?formId=" + "tsirm_adverttplexlistb" + "&type=list&list_formId=bos_list&startdate=13&advertstatus=" + "A" + "," + "E" : UrlService.getDomainContextUrl() + "/?formId=" + "tsirm_adverttplexlistb" + "&type=list&list_formId=bos_list&enddate=11&advertstatus=" + "S";
        String senderName = ResManager.loadKDString((String)"\u4eba\u624d\u4f9b\u5e94\u4e91", (String)(MODULE + "_3"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String tag = ResManager.loadKDString((String)"\u901a\u77e5", (String)(MODULE + "_2"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        CommrecBaseHelper.sendMessage((String)title, (String)content, (List)Lists.newArrayList((Object[])new Long[]{userId}), (long)1L, (String)senderName, (String)url, (String)tag);
    }

    public static DynamicObject[] queryDisableAdvertForJob(Date now) {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)4);
        filters.add(new QFilter("advertstatus", "=", (Object)"S"));
        filters.add(new QFilter("approvestatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{"B", "G", "D"})));
        filters.add(new QFilter("enddate", "<", (Object)CommonUtils.getBeginDate((Date)now)));
        Date lastDate = HRDateTimeUtils.addDay((Date)now, (long)-1L);
        filters.add(new QFilter("enddate", ">=", (Object)CommonUtils.getBeginDate((Date)lastDate)));
        return AdvertDetailExDataHelper.getInstance().getAdvertListByFilter(filters.toArray(new QFilter[filters.size()]), null);
    }

    public static void showEnableAdvTip(IFormView view, OperationResult operationResult) {
        if (!operationResult.isShowMessage()) {
            Pair result = (Pair)SerializationUtils.deSerializeFromBase64((String)operationResult.getMessage());
            if (HRStringUtils.isEmpty((String)((String)result.getLeft()))) {
                view.showSuccessNotification((String)((List)result.getRight()).get(0));
            } else {
                List msgLsit = (List)result.getRight();
                if (HRStringUtils.equals((String)"fail", (String)((String)result.getLeft())) && msgLsit != null && msgLsit.size() == 1) {
                    view.showErrorNotification((String)msgLsit.get(0));
                } else {
                    FormShowParameter parameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)result.getLeft(), (Object)result.getRight(), (boolean)false);
                    view.showForm(parameter);
                }
            }
        }
    }

    public static boolean isAdvertCanDelivery(Long advertId) {
        DynamicObject advertDy = AdvertDetailExDataHelper.getInstance().queryAdvertDetail(advertId);
        return !"D".equals(advertDy.getString("advertstatus"));
    }
}

