/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.common.util.CommonUtils;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;
import kd.tsc.tsrbs.common.utils.ObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class AdvertConfigHelper {
    private static final String MODULE = AdvertConfigHelper.class.getName();
    private static final String CONF_PAGE_ID = "tsrbd_adconfig";
    private static final String CONF_AUDIT = "audit";
    private static final String CONF_CHANNEL = "recruchnlnm";
    private static final BizConfigParamHelper BIZ_CONFIG = new BizConfigParamHelper();

    private AdvertConfigHelper() {
    }

    public static Boolean needAuditByChannel(Long channelId) {
        Object[] channels;
        String data = AdvertConfigHelper.auditConfOrigin();
        if (HRStringUtils.isBlank((CharSequence)data)) {
            return true;
        }
        Boolean isNeedAudit = Boolean.TRUE;
        if (HRStringUtils.equals((String)data, (String)"3")) {
            isNeedAudit = Boolean.FALSE;
        } else if (HRStringUtils.equals((String)data, (String)"2") && !ArrayUtils.contains((Object[])(channels = (Object[])BIZ_CONFIG.get(CONF_PAGE_ID, CONF_CHANNEL)), (Object)channelId)) {
            isNeedAudit = Boolean.FALSE;
        }
        return isNeedAudit;
    }

    private static String auditConfOrigin() {
        String data = (String)BIZ_CONFIG.get(CONF_PAGE_ID, CONF_AUDIT);
        if (HRStringUtils.isEmpty((String)data)) {
            return "";
        }
        return data;
    }

    public static boolean isAllAudit() {
        String data = AdvertConfigHelper.auditConfOrigin();
        return HRStringUtils.equals((String)data, (String)"1") || HRStringUtils.isBlank((CharSequence)data);
    }

    public static Boolean needAuditByChannel(DynamicObject advert) {
        DynamicObject channel = advert.getDynamicObject("channel");
        long channelId = 0L;
        if (!HRObjectUtils.isEmpty((Object)channel)) {
            channelId = channel.getLong("id");
        }
        return AdvertConfigHelper.needAuditByChannel(channelId);
    }

    public static Pair<Boolean, List<Long>> getAuditConf() {
        String data = (String)BIZ_CONFIG.get(CONF_PAGE_ID, CONF_AUDIT);
        if (HRStringUtils.isEmpty((String)data)) {
            return Pair.of((Object)true, (Object)Lists.newArrayList());
        }
        Boolean isNeedAudit = Boolean.TRUE;
        Object[] channelArr = null;
        ArrayList channels = null;
        if (HRStringUtils.equals((String)data, (String)"3")) {
            isNeedAudit = Boolean.FALSE;
        } else if (HRStringUtils.equals((String)data, (String)"2") && ArrayUtils.isNotEmpty((Object[])(channelArr = (Object[])BIZ_CONFIG.get(CONF_PAGE_ID, CONF_CHANNEL)))) {
            channels = Lists.newArrayListWithExpectedSize((int)channelArr.length);
            for (Object obj : channelArr) {
                channels.add((Long)obj);
            }
        }
        return Pair.of((Object)isNeedAudit, channels);
    }

    public static Pair<Boolean, List<Long>> getConfByChannel(List<Long> channelIds) {
        Pair<Boolean, List<Long>> auditConf = AdvertConfigHelper.getAuditConf();
        if (((Boolean)auditConf.getLeft()).booleanValue()) {
            List confAuditChannels = (List)auditConf.getRight();
            if (CollectionUtils.isNotEmpty((Collection)confAuditChannels)) {
                confAuditChannels.retainAll(channelIds);
                return Pair.of((Object)Boolean.TRUE, (Object)confAuditChannels);
            }
            return Pair.of((Object)Boolean.TRUE, channelIds);
        }
        return Pair.of((Object)Boolean.FALSE, null);
    }

    public static Boolean isHasAdvertWorkFlow() {
        String sql = "SELECT COUNT(1) AS HASFLOW FROM T_WF_PROCDEF WHERE FENTRABILL = ? and fenable='enable'";
        return (Boolean)HRDBUtil.query((DBRoute)new DBRoute("wfs"), (String)sql, (Object[])new Object[]{"tsirm_advertbill"}, resultSet -> {
            boolean next = resultSet.next();
            if (next) {
                return resultSet.getInt("HASFLOW") >= 1;
            }
            return Boolean.FALSE;
        });
    }

    public static Pair<Boolean, List<Long>> isAuditChannelChange(List<Long> channelIds, List<Long> notAuditChannelIds) {
        List newNotChannelIds = CommonUtils.copyList(notAuditChannelIds);
        Pair<Boolean, List<Long>> auditConf = AdvertConfigHelper.getAuditConf();
        if (((Boolean)auditConf.getLeft()).booleanValue()) {
            List right = (List)auditConf.getRight();
            if (CollectionUtils.isEmpty((Collection)right)) {
                if (CollectionUtils.isEmpty(notAuditChannelIds)) {
                    return Pair.of((Object)Boolean.FALSE, notAuditChannelIds);
                }
                return Pair.of((Object)Boolean.TRUE, notAuditChannelIds);
            }
            List copyNeedChannelIds = CommonUtils.copyList(channelIds);
            List copyNotChannelIds = CommonUtils.copyList(notAuditChannelIds);
            copyNeedChannelIds.removeAll(right);
            copyNotChannelIds.retainAll(right);
            if (CollectionUtils.isEmpty((Collection)copyNeedChannelIds) && CollectionUtils.isEmpty((Collection)copyNotChannelIds)) {
                return Pair.of((Object)Boolean.FALSE, notAuditChannelIds);
            }
            newNotChannelIds.addAll(copyNeedChannelIds);
            newNotChannelIds.removeAll(copyNotChannelIds);
            return Pair.of((Object)Boolean.TRUE, (Object)newNotChannelIds);
        }
        if (CollectionUtils.isEmpty(channelIds)) {
            return Pair.of((Object)Boolean.FALSE, notAuditChannelIds);
        }
        notAuditChannelIds.addAll(channelIds);
        return Pair.of((Object)Boolean.TRUE, notAuditChannelIds);
    }

    public static Tuple<Boolean, Integer> getAdTopNumConf() {
        Map configDataMap = BIZ_CONFIG.get(CONF_PAGE_ID);
        Object islimittop = configDataMap.get("islimittop");
        return Tuple.create((Object)(islimittop == null ? Boolean.TRUE : ObjectUtils.getBooleanValOfObject(islimittop)), (Object)ObjectUtils.getIntValOfObject(configDataMap.get("topnum")));
    }

    public static Tuple<Boolean, Integer> getAdUrgentNumConf() {
        Map configDataMap = BIZ_CONFIG.get(CONF_PAGE_ID);
        Object islimiturgent = configDataMap.get("islimiturgent");
        return Tuple.create((Object)(islimiturgent == null ? Boolean.TRUE : ObjectUtils.getBooleanValOfObject(islimiturgent)), (Object)ObjectUtils.getIntValOfObject(configDataMap.get("urgentnum")));
    }

    public static Tuple<Boolean, Integer> getAdTopDateNumConf() {
        Map configDataMap = BIZ_CONFIG.get(CONF_PAGE_ID);
        Object isLimitTopDate = configDataMap.get("islimittopdate");
        return Tuple.create((Object)(isLimitTopDate == null ? Boolean.TRUE : ObjectUtils.getBooleanValOfObject(isLimitTopDate)), (Object)ObjectUtils.getIntValOfObject(configDataMap.get("topdatenum")));
    }

    public static Tuple<Boolean, Integer> getAdUrgentDateNumConf() {
        Map configDataMap = BIZ_CONFIG.get(CONF_PAGE_ID);
        Object isLimitUrgentDate = configDataMap.get("islimiturgentdate");
        return Tuple.create((Object)(isLimitUrgentDate == null ? Boolean.TRUE : ObjectUtils.getBooleanValOfObject(isLimitUrgentDate)), (Object)ObjectUtils.getIntValOfObject(configDataMap.get("urgentdatenum")));
    }
}

