/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.tsirm.extpoint.advert.IAdvertService;
import kd.tsc.tsirm.business.domain.advert.service.AdvHisChannelHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.valid.CommonValidate;
import kd.tsc.tsirm.business.domain.advert.service.valid.FieldValidHelper;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecValidate;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;
import kd.tsc.tsirm.business.domain.intreco.service.RewardRuleService;
import kd.tsc.tsirm.common.constants.position.PositionConstants;
import kd.tsc.tsirm.common.enums.advert.ChannelFieldEnum;
import kd.tsc.tsrbd.common.constants.ChannelConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class AdvertPublishHelper {
    private static final String MODULE = AdvertPublishHelper.class.getName();
    private static AdvertBizService advertBizService = AdvertBizService.getInstance();
    private static Map<String, String> fieldMap = new HashMap<String, String>(16);
    public static final String[] ONLY_SHOW = new String[]{"advertbuorg", "adminorg"};

    private AdvertPublishHelper() {
    }

    public static IFormView getPageFromCache(IFormView thisView, String pageMark) {
        String pageId = thisView.getPageCache().get(pageMark);
        IFormView view = thisView.getView(pageId);
        return view;
    }

    public static void addSelectChannel(DynamicObject channel, IFormView channelView) {
        DynamicObject parentAdvert = channelView.getParentView().getModel().getDataEntity(true);
        DynamicObjectCollection selectChannels = parentAdvert.getDynamicObjectCollection("selectpubchannel");
        DynamicObject newChannel = selectChannels.addNew();
        newChannel.set("fbasedataid_id", (Object)channel.getLong("id"));
        parentAdvert.set("selectpubchannel", (Object)selectChannels);
        channelView.sendFormAction(channelView.getParentView());
    }

    public static void addSelectChannel(Long channelId, IFormView formView) {
        DynamicObject publishAdvert = formView.getModel().getDataEntity(true);
        DynamicObjectCollection selectChannels = publishAdvert.getDynamicObjectCollection("selectpubchannel");
        DynamicObject newChannel = selectChannels.addNew();
        newChannel.set("fbasedataid_id", (Object)channelId);
        publishAdvert.set("selectpubchannel", (Object)selectChannels);
    }

    public static void deleteSelectChannel(DynamicObjectCollection selectChannels, List<Long> deleteChannelIds) {
        Iterator iterator = selectChannels.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            for (long deleteChannelId : deleteChannelIds) {
                if (next.getLong("fbasedataid_id") != deleteChannelId) continue;
                iterator.remove();
            }
        }
    }

    public static List<Long> getSelectChannelsByPage(IFormView commonView) {
        DynamicObjectCollection selectChannels = commonView.getModel().getDataEntity(true).getDynamicObjectCollection("selectpubchannel");
        List<Long> channelIdList = selectChannels.stream().map(channel -> channel.getLong("fbasedataid_id")).collect(Collectors.toList());
        return channelIdList;
    }

    public static Pair<List<Long>, List<Long>> getAddAndDelData(IFormView formView, ListSelectedRowCollection listSelectedRows) {
        List<Long> selectedChannels = AdvertPublishHelper.getSelectChannelsByPage(formView);
        ArrayList<Long> returnChannelIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow selectRow : listSelectedRows) {
            Long returnChannelId = (Long)selectRow.getPrimaryKeyValue();
            returnChannelIds.add(returnChannelId);
        }
        ArrayList newSelectedChannels = new ArrayList(selectedChannels.size());
        CollectionUtils.addAll(newSelectedChannels, (Object[])new Object[selectedChannels.size()]);
        Collections.copy(newSelectedChannels, selectedChannels);
        selectedChannels.removeAll(returnChannelIds);
        returnChannelIds.removeAll(newSelectedChannels);
        return Pair.of(returnChannelIds, selectedChannels);
    }

    public static FormShowParameter createChannelFlex(Container flexPanel, Map<String, Object> param, Long channelId, OperationStatus status) {
        String flexKey = flexPanel.getKey().concat("_" + channelId);
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexKey);
        flexPanel.deleteControls(new String[]{flexKey});
        flexPanel.addControls(Collections.singletonList(flex.createControl()));
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tsirm_advertchannelex");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(flex.getKey());
        showParameter.setStatus(status);
        showParameter.setSendToClient(true);
        if (!HRObjectUtils.isEmpty(param)) {
            showParameter.setCustomParams(param);
        }
        return showParameter;
    }

    public static FormShowParameter createChannelFlex(Container flexPanel, Map<String, Object> param, Long channelId) {
        return AdvertPublishHelper.createChannelFlex(flexPanel, param, channelId, OperationStatus.EDIT);
    }

    public static List<FormShowParameter> addAndDelChannelFlex(Container flexPanel, Pair<List<Long>, List<Long>> result, IFormView view) {
        List rights = (List)result.getRight();
        for (Long channelId : rights) {
            String flexKey = flexPanel.getKey().concat("_" + channelId);
            flexPanel.deleteControls(new String[]{flexKey});
            view.getPageCache().remove("cache_channel_page_id_" + channelId);
        }
        List lefts = (List)result.getLeft();
        ArrayList<FormShowParameter> showParameters = new ArrayList<FormShowParameter>(lefts.size());
        for (Long channelId : lefts) {
            FormShowParameter channelFlexParam = AdvertPublishHelper.createChannelFlex(flexPanel, null, channelId);
            channelFlexParam.setCustomParam("channel", (Object)String.valueOf(channelId));
            showParameters.add(channelFlexParam);
        }
        return showParameters;
    }

    public static List<FormShowParameter> createChannelFlex(Container flexPanel, DynamicObject approval, OperationStatus status) {
        List<Long> channels = AdvertApprovalHelper.getAllChannelBySnaps(approval);
        return AdvertPublishHelper.getChannelParameters(flexPanel, channels, status);
    }

    public static List<FormShowParameter> getChannelParameters(Container flexPanel, List<Long> channels, OperationStatus status) {
        ArrayList<FormShowParameter> showParameters = new ArrayList<FormShowParameter>(channels.size());
        for (long channelId : channels) {
            FormShowParameter formShowParameter = AdvertPublishHelper.createChannelFlex(flexPanel, null, channelId, status);
            formShowParameter.setCustomParam("channel", (Object)String.valueOf(channelId));
            showParameters.add(formShowParameter);
        }
        return showParameters;
    }

    public static void setPositionDataToCommon(IFormView view, DynamicObject position) {
        IDataModel model = view.getModel();
        model.setValue("name", position.get("name"));
        model.setValue("reccategory", (Object)position.getDynamicObject("reccategory"));
        AdvertPublishHelper.setPosOrgAndBu(view, position);
        model.setValue("recruscene", (Object)position.getDynamicObject("recruscene"));
        model.setValue("poscategory", (Object)position.getDynamicObject("poscategory"));
        model.setValue("workaddr", (Object)position.getDynamicObjectCollection("workaddrs"));
        model.setValue("salarytype", (Object)position.getDynamicObject("salarytype"));
        model.setValue("currency", (Object)position.getDynamicObject("currency"));
        Long salaryDown = position.getLong("salarydown");
        Long salaryUp = position.getLong("salaryup");
        model.setValue("salarydown", (Object)salaryDown);
        model.setValue("salaryup", (Object)salaryUp);
        boolean isSalaryNego = position.getBoolean("issalarynego");
        model.setValue("issalarynego", (Object)isSalaryNego);
        model.setValue("holdofftyp", (Object)position.getDynamicObject("holdofftyp"));
        int workExpDown = position.getInt("workexpdown");
        int workExpUp = position.getInt("workexpup");
        model.setValue("workexpdown", (Object)workExpDown);
        model.setValue("workexpup", (Object)workExpUp);
        boolean isWorkExpLimit = position.getBoolean("isworkexplimit");
        model.setValue("isworkexplimit", (Object)isWorkExpLimit);
        DynamicObject education = position.getDynamicObject("education");
        Boolean isEduLimit = position.getBoolean("isedulimit");
        model.setValue("education", (Object)education);
        model.setValue("isedulimit", (Object)isEduLimit);
        int recruitNum = position.getInt("recruitnum");
        boolean isRecnumLimit = position.getBoolean("isrecnumlimit");
        model.setValue("recruitnum", (Object)recruitNum);
        model.setValue("isrecnumlimit", (Object)isRecnumLimit);
        model.setValue("posrespon", (Object)position.getLocaleString("posrespon"));
        model.setValue("posqual", (Object)position.getLocaleString("anoposrequirement"));
        model.setValue("position", (Object)position.getLong("id"));
        model.setValue("jobseq", (Object)position.getDynamicObject("jobseq"));
        model.setValue("lowjobgrade", (Object)position.getDynamicObject("lowjobgrade"));
        model.setValue("highjobgrade", (Object)position.getDynamicObject("highjobgrade"));
        model.setValue("lowjoblevel", (Object)position.getDynamicObject("lowjoblevel"));
        model.setValue("highjoblevel", (Object)position.getDynamicObject("highjoblevel"));
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, IAdvertService.class, (String)"kd.sdk.tsc.tsirm.extpoint.advert.IAdvertService", null);
        proxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                Map map = plugin.autoBringinFromPosition(position);
                map.forEach((key, value) -> {
                    if (model.getDataEntity().getDataEntityType().getProperties().contains(key)) {
                        model.setValue(key, value);
                    }
                });
            }
            return null;
        });
    }

    public static boolean validateOperator(IFormView publishView, IFormView publishViewParent) {
        IFormView showTipView = publishView;
        if (null != publishViewParent) {
            showTipView = publishViewParent;
        }
        DynamicObject baseInfo = publishView.getModel().getDataEntity(true);
        CommonValidate commonValidate = new CommonValidate(baseInfo);
        Map allCache = publishView.getPageCache().getAll();
        StringBuilder notice = null == publishViewParent ? commonValidate.validateCommonInput(publishView).wrapperNotice() : commonValidate.validateCommonInput(publishView, publishViewParent, AdvertPublishHelper.isBaseInfoHasTime(allCache)).wrapperNotice();
        boolean hasAnyChannel = false;
        for (Map.Entry entry : allCache.entrySet()) {
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith("cache_channel_page_id_")) continue;
            hasAnyChannel = true;
            String pageId = (String)entry.getValue();
            long channelId = Long.parseLong(cacheKey.replace("cache_channel_page_id_", ""));
            IFormView channelView = publishView.getView(pageId);
            if (null == channelView) {
                String err = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u5e03\u6e20\u9053\uff01", (String)(MODULE + "_0"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
                notice.append(err);
                continue;
            }
            DynamicObject childInfo = channelView.getModel().getDataEntity(true);
            List<Long> disableChannelIds = AdvertBizService.getInstance().getDisableChannelIds();
            if (disableChannelIds.contains(channelId)) {
                String channelName = childInfo.getDynamicObject("channel").getString("name");
                String message = String.format(ResManager.loadKDString((String)"%s\u6e20\u9053\u5df2\u7981\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6e20\u9053\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChannelAdvDetailPlugin_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), channelName);
                notice.append(message);
                continue;
            }
            Object[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
            if (ArrayUtils.isEmpty((Object[])fieldsByChannel)) continue;
            IntrecValidate intrecValidate = new IntrecValidate(childInfo);
            StringBuilder validResult = null == publishViewParent ? intrecValidate.validateChannelInput(channelView, publishView).getValidResult() : intrecValidate.validateChannelInput(channelView, publishViewParent).getValidResult();
            if (notice.length() == 0 && validResult.length() > 0) {
                validResult = intrecValidate.wrapperNotice();
            }
            notice.append((CharSequence)validResult);
        }
        if (notice.length() == 0) {
            if (!hasAnyChannel) {
                String err = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u5e03\u6e20\u9053\uff01", (String)(MODULE + "_0"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
                showTipView.showTipNotification(err);
                return false;
            }
            return true;
        }
        if (notice.indexOf("\u3001") >= 0) {
            notice.deleteCharAt(notice.length() - 1);
        }
        notice.append("\u3002");
        showTipView.showTipNotification(notice.toString());
        return false;
    }

    private static boolean isBaseInfoHasTime(Map<String, String> allCache) {
        int noFieldCount = 0;
        for (Map.Entry<String, String> entry : allCache.entrySet()) {
            long channelId;
            Object[] fieldsByChannel;
            String cacheKey = entry.getKey();
            if (!cacheKey.startsWith("cache_channel_page_id_") || !ArrayUtils.isEmpty((Object[])(fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)(channelId = Long.parseLong(cacheKey.replace("cache_channel_page_id_", ""))))))) continue;
            ++noFieldCount;
        }
        return noFieldCount > 0;
    }

    public static boolean validateOperator(IFormView advertDetailView) {
        DynamicObject baseInfo = advertDetailView.getModel().getDataEntity(true);
        CommonValidate commonValidate = new CommonValidate(baseInfo);
        StringBuilder notice = commonValidate.validateCommonInput(advertDetailView).wrapperNotice();
        long channelId = baseInfo.getLong("channel_id");
        Object[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
        if (ArrayUtils.isNotEmpty((Object[])fieldsByChannel)) {
            IntrecValidate intrecValidate = new IntrecValidate(baseInfo);
            StringBuilder validResult = intrecValidate.validateChannelInput(null, advertDetailView).getValidResult();
            if (notice.length() == 0 && validResult.length() > 0) {
                validResult = intrecValidate.wrapperNotice();
            }
            notice.append((CharSequence)validResult);
        }
        if (notice.length() == 0) {
            return true;
        }
        if (notice.indexOf("\u3001") >= 0) {
            notice.deleteCharAt(notice.length() - 1);
        }
        notice.append("\u3002");
        advertDetailView.showTipNotification(notice.toString());
        return false;
    }

    public static void initAdvertF7Element(ListShowParameter formShowParameter, String property, DynamicObject createOrg) {
        switch (property) {
            case "poscategory": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u804c\u4f4d\u7c7b\u522b", (String)(MODULE + "_2"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
                QFilter qFilter = new QFilter("level", "=", (Object)3);
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "holdofftyp": {
                QFilter qFilter = new QFilter("id", "in", Arrays.asList(PositionConstants.HOLD_OFFICE_TYPE_FULL_TIME, PositionConstants.HOLD_OFFICE_TYPE_PART_TIME)).and("enable", "=", (Object)"1");
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "recruscene": {
                QFilter qFilter = new QFilter("recruitmentcategory.fbasedataid", "=", (Object)1030L).and("enable", "=", (Object)"1");
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public static void salaryTypePropertyChange(String propertyName, IFormView formView) {
        if ("salarytype".equals(propertyName)) {
            DynamicObject salaryType = formView.getModel().getDataEntity().getDynamicObject("salarytype");
            FieldEdit currency = (FieldEdit)formView.getControl("currency");
            if (salaryType != null) {
                currency.setMustInput(true);
            }
            boolean isEnable = true;
            if (salaryType == null) {
                currency.setMustInput(false);
                formView.getModel().setValue("salaryup", null);
                formView.getModel().setValue("salarydown", null);
                formView.getModel().setValue("issalarynego", (Object)Boolean.TRUE);
                formView.getModel().setValue("currency", null);
                formView.updateView("issalarynego");
                isEnable = false;
            } else if (formView.getModel().getDataEntity().getDynamicObject("currency") != null) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u4ed8\u85aa\u7c7b\u578b\u5df2\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5\u4ed8\u85aa\u5e01\u522b\u53ca\u85aa\u8d44\u8303\u56f4\u662f\u5426\u9700\u8981\u4fee\u6539", (String)(MODULE + "_3"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
            }
            formView.setEnable(Boolean.valueOf(isEnable), new String[]{"issalarynego"});
        }
    }

    public static void currencyPropertyChange(String propertyName, IFormView formView) {
        if ("currency".equals(propertyName) && formView.getModel().getDataEntity().getDynamicObject("currency") == null) {
            formView.getModel().setValue("salaryup", null);
            formView.getModel().setValue("salarydown", null);
            formView.getModel().setValue("issalarynego", (Object)"1");
        }
    }

    public static void otherPropertyChange(String name, IFormView formView) {
        if (HRStringUtils.equals((String)"1", (String)fieldMap.get(name))) {
            FieldValidHelper helper = new FieldValidHelper(formView);
            helper.validRangeField("salaryup", "salarydown", name, ResManager.loadKDString((String)"\u85aa\u8d44\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u85aa\u8d44\u4e0a\u9650", (String)(MODULE + "_4"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)"2", (String)fieldMap.get(name))) {
            FieldValidHelper helper = new FieldValidHelper(formView);
            helper.validRangeField("workexpup", "workexpdown", name, ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u5de5\u4f5c\u5e74\u9650\u4e0a\u9650", (String)(MODULE + "_5"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)"3", (String)fieldMap.get(name))) {
            FieldValidHelper helper = new FieldValidHelper(formView);
            helper.validField(name);
        } else if (HRStringUtils.equals((String)"4", (String)fieldMap.get(name))) {
            FieldValidHelper helper = new FieldValidHelper(formView);
            helper.validFieldNumber(name);
        } else if (HRStringUtils.equals((String)"5", (String)fieldMap.get(name))) {
            DynamicObject advert = formView.getModel().getDataEntity(true);
            advertBizService.setAdvFullName(advert);
            AdvertPublishHelper.ignoreFullNameChange(advert, formView);
        } else if (HRStringUtils.equals((String)"6", (String)fieldMap.get(name))) {
            FieldValidHelper helper = new FieldValidHelper(formView);
            helper.validField(name);
            DynamicObject advert = formView.getModel().getDataEntity(true);
            advertBizService.setAdvFullName(advert);
            AdvertPublishHelper.ignoreFullNameChange(advert, formView);
        }
    }

    private static void ignoreFullNameChange(DynamicObject advert, IFormView formView) {
        DataEntityState dataEntityState = advert.getDataEntityState();
        DataEntityPropertyCollection properties = advert.getDataEntityType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"fullname");
        if (!HRObjectUtils.isEmpty((Object)iDataEntityProperty)) {
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        formView.getModel().updateCache();
    }

    public static void initSalaryType(IFormView formView) {
        DynamicObject salaryType = formView.getModel().getDataEntity().getDynamicObject("salarytype");
        FieldEdit currency = (FieldEdit)formView.getControl("currency");
        if (salaryType != null && currency != null) {
            currency.setMustInput(true);
        } else {
            formView.getModel().setValue("issalarynego", (Object)Boolean.TRUE);
            formView.setEnable(Boolean.FALSE, new String[]{"issalarynego"});
        }
    }

    public static void rangeDatePropertyChange(String name, IFormView view) {
        FieldValidHelper fieldValidHelper;
        IDataModel model = view.getModel();
        Date endDate = (Date)model.getValue("enddate");
        Date startDate = (Date)model.getValue("startdate");
        boolean pass = true;
        if ("startdate".equals(name) && !HRObjectUtils.isEmpty((Object)endDate)) {
            fieldValidHelper = new FieldValidHelper(view);
            pass = fieldValidHelper.validRangeDate("startdate", "enddate", true, ResManager.loadKDString((String)"\u9700\u65e9\u4e8e\u622a\u6b62\u65e5\u671f", (String)(MODULE + "_1"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        if ("enddate".equals(name) && !HRObjectUtils.isEmpty((Object)startDate)) {
            fieldValidHelper = new FieldValidHelper(view);
            pass = fieldValidHelper.validRangeDate("startdate", "enddate", false, ResManager.loadKDString((String)"\u9700\u665a\u4e8e\u751f\u6548\u65e5\u671f", (String)(MODULE + "_6"), (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        if (pass) {
            AdvertBusinessHelper.changeChannelRangeDate(name, view);
        }
    }

    public static void setPosOrgAndBu(IFormView formView, DynamicObject src) {
        IDataModel model = formView.getModel();
        DynamicObject adminOrgs = src.getDynamicObject("adminorg");
        model.setValue("adminorg", (Object)adminOrgs);
        String entityName = src.getDataEntityType().getName();
        if (!model.getDataEntity().containsProperty("advertbuorg")) {
            return;
        }
        if (HRStringUtils.equals((String)entityName, (String)"tsirm_positiontpl")) {
            model.setValue("advertbuorg", (Object)src.getDynamicObject("createorg"));
        } else if (HRStringUtils.equals((String)entityName, (String)"tsirm_advertbilltpl")) {
            model.setValue("advertbuorg", (Object)src.getDynamicObject("advertbuorg"));
        } else {
            model.setValue("advertbuorg", (Object)src.getDynamicObject("advertbuorg"));
        }
    }

    public static void loadIntrecoFlex(IFormView view, DynamicObject position, FormShowParameter formShowParameter) {
        DynamicObject adminOrgs = position.getDynamicObject("adminorg");
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        if (adminOrgs != null) {
            param.put("reqorg", adminOrgs.getLocaleString("name"));
        }
        param.put("adminorgsdpt", position.getDynamicObjectCollection("adminorgsdpt"));
        param.put("channel", String.valueOf(ChannelConstants.INTRECO_CHANNEL_ID));
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsrbd_rewardrule");
        DataEntityCacheManager dataEntityCacheManager = new DataEntityCacheManager(dynamicObject.getDataEntityType());
        dataEntityCacheManager.removeByDt();
        Pair<Long, DynamicObject> rewardResult = RewardRuleService.getInstance().getRewardResultByPos(position);
        if (!HRObjectUtils.isEmpty(rewardResult)) {
            param.put("isreward", Boolean.TRUE);
            param.put("rewardruleresult", rewardResult.getRight());
            param.put("rewardrule", rewardResult.getLeft());
        } else {
            param.put("isreward", Boolean.FALSE);
        }
        Container flexPanel = (Container)view.getControl("advertchannelflex");
        if (null == formShowParameter) {
            formShowParameter = AdvertPublishHelper.createChannelFlex(flexPanel, param, ChannelConstants.INTRECO_CHANNEL_ID, OperationStatus.EDIT);
        } else {
            formShowParameter.setCustomParams(param);
        }
        view.getPageCache().put("cache_channel_page_id_" + ChannelConstants.INTRECO_CHANNEL_ID, formShowParameter.getPageId());
        AdvertPublishHelper.addSelectChannel(ChannelConstants.INTRECO_CHANNEL_ID, view);
        view.showForm(formShowParameter);
    }

    public static void loadForPublish(IFormView view, DynamicObject position) {
        String posCategoryNumber;
        AdvertPublishHelper.setPositionDataToCommon(view, position);
        DynamicObject posCategory = position.getDynamicObject("poscategory");
        List<Long> latestChannelIdList = null;
        if (!HRObjectUtils.isEmpty((Object)posCategory) && CollectionUtils.isNotEmpty(latestChannelIdList = AdvHisChannelHelper.getHisChannelByUser(posCategoryNumber = posCategory.getString("number")))) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recruchnlnm");
            DynamicObject[] querys = serviceHelper.query("id", new QFilter[]{new QFilter("id", "in", latestChannelIdList).and("enable", "=", (Object)"1")});
            latestChannelIdList = Arrays.stream(querys).map(query -> query.getLong("id")).sorted().collect(Collectors.toList());
        }
        AdvertPublishHelper.loadIntrecoAndOtherData(view, position, latestChannelIdList);
    }

    private static void loadIntrecoAndOtherData(IFormView view, DynamicObject position, List<Long> latestChannelIdList) {
        Container flexPanel = (Container)view.getControl("advertchannelflex");
        if (CollectionUtils.isEmpty(latestChannelIdList)) {
            AdvertPublishHelper.loadIntrecoFlex(view, position, null);
        } else {
            List<FormShowParameter> channelParameters = AdvertPublishHelper.getChannelParameters(flexPanel, latestChannelIdList, OperationStatus.EDIT);
            AdvertPublishHelper.goForChannelFlex(view, channelParameters);
        }
    }

    public static void goForChannelFlex(IFormView view, List<FormShowParameter> channelParameters) {
        DynamicObject position = (DynamicObject)view.getModel().getValue("position");
        for (FormShowParameter channelParameter : channelParameters) {
            long channelId = Long.parseLong((String)channelParameter.getCustomParam("channel"));
            if (channelId == ChannelConstants.INTRECO_CHANNEL_ID && !HRObjectUtils.isEmpty((Object)position)) {
                AdvertPublishHelper.loadIntrecoFlex(view, position, channelParameter);
                continue;
            }
            AdvertPublishHelper.addSelectChannel(channelId, view);
            view.getPageCache().put("cache_channel_page_id_" + channelId, channelParameter.getPageId());
            view.showForm(channelParameter);
        }
    }

    public static void loadForApproval(IFormView view) {
        DynamicObject approval = AdvertPublishHelper.setAdvertSnapDataToCommon(view);
        AdvertPublishHelper.loadChannelByApproval(view, approval);
    }

    private static DynamicObject setAdvertSnapDataToCommon(IFormView view) {
        String approvalId = (String)view.getFormShowParameter().getCustomParam("approvalid");
        if (HRStringUtils.isEmpty((String)approvalId)) {
            return null;
        }
        DynamicObject approval = AdvertApprovalHelper.loadOne(Long.parseLong(approvalId));
        AdvertApprovalHelper.setCommonDataFormSnap(view, approval);
        return approval;
    }

    private static void loadChannelByApproval(IFormView view, DynamicObject approval) {
        Container flexPanel = (Container)view.getControl("advertchannelflex");
        if (HRObjectUtils.isEmpty((Object)approval)) {
            return;
        }
        IntrecoPageHelper.setObjData2Cache(approval, "advertApprovalCacheId", view.getPageCache());
        OperationStatus status = view.getFormShowParameter().getStatus();
        List<FormShowParameter> channelFlex = AdvertPublishHelper.createChannelFlex(flexPanel, approval, status);
        AdvertPublishHelper.goForChannelFlex(view, channelFlex);
    }

    public static void changePageForEdit(IFormView formView) {
        formView.setStatus(OperationStatus.EDIT);
        ((BillShowParameter)formView.getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
        formView.updateView();
    }

    public static boolean showPosStatusTip(IFormView formView) {
        DynamicObject advertOrBill = formView.getModel().getDataEntity(true);
        Pair<Boolean, String> result = AdvertBusinessHelper.checkPositionAudit(advertOrBill);
        if (((Boolean)result.getLeft()).booleanValue() && HRStringUtils.isNotEmpty((String)((String)result.getRight()))) {
            formView.showTipNotification((String)result.getRight());
            return true;
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            formView.showErrorNotification((String)result.getRight());
            return false;
        }
        return true;
    }

    static {
        fieldMap.put("salarydown", "1");
        fieldMap.put("salaryup", "1");
        fieldMap.put("workexpdown", "2");
        fieldMap.put("workexpup", "2");
        fieldMap.put("posqual", "3");
        fieldMap.put("workaddr", "3");
        fieldMap.put("reccategory", "3");
        fieldMap.put("poscategory", "3");
        fieldMap.put("posrespon", "3");
        fieldMap.put("education", "3");
        fieldMap.put("isedulimit", "3");
        fieldMap.put("recruitnum", "4");
        fieldMap.put("isdisposcode", "5");
        fieldMap.put("name", "6");
    }
}

