/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvBillTplDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvHisChannelHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.common.constants.advert.AdvertFieldConstants;
import kd.tsc.tsirm.common.enums.advert.ChannelFieldEnum;
import kd.tsc.tsirm.common.util.CommonUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class AdvertTplExCommonHelper {
    private static final Log logger = LogFactory.getLog(AdvertTplExCommonHelper.class);
    private static AdvertBizService advertBizService = AdvertBizService.getInstance();

    public static Pair<String, List<String>> fastRelease(DynamicObject dataEntity) {
        advertBizService.setAdvFullName(dataEntity);
        DynamicObjectCollection channelDetails = dataEntity.getDynamicObjectCollection("entryentity");
        int channelNum = channelDetails.size();
        ArrayList adverts = Lists.newArrayListWithCapacity((int)channelNum);
        long[] ids = ID.genLongIds((int)channelNum);
        DynamicObjectCollection advertCollection = dataEntity.getDynamicObjectCollection("selectpubchannel");
        ArrayList channelIdList = Lists.newArrayListWithExpectedSize((int)channelNum);
        for (int num2 = 0; num2 < channelNum; ++num2) {
            DynamicObject emptyAdvert = AdvertTplExCommonHelper.getAdvert(dataEntity, (DynamicObject)channelDetails.get(num2), ids[num2], (DynamicObject)advertCollection.get(num2));
            adverts.add(emptyAdvert);
            channelIdList.add(emptyAdvert.getDynamicObject("channel").getLong("id"));
        }
        List numberArr = CodeRuleServiceHelper.getNumbers((String)"tsirm_advertpublish", (List)adverts);
        IntStream.range(0, adverts.size()).forEach(num -> ((DynamicObject)adverts.get(num)).set("number", numberArr.get(num)));
        Pair<List<DynamicObject>, Pair<List<DynamicObject>, List<DynamicObject>>> approvalResult = AdvertTplExCommonHelper.getNeedApprovalAdverts(channelNum, adverts, channelIdList);
        DynamicObject posCategory = dataEntity.getDynamicObject("poscategory");
        if (!Objects.isNull(posCategory)) {
            AdvHisChannelHelper.putHisChannel(posCategory.getString("number"), channelIdList);
        }
        return AdvertTplExCommonHelper.touchOffWorkFlowOrNot(adverts, (List)approvalResult.getLeft(), (List)((Pair)approvalResult.getRight()).getLeft(), (List)((Pair)approvalResult.getRight()).getRight());
    }

    public static List<IOperateInfo> getAuditAdvErrors(List<DynamicObject> notHasWorkFlowList) {
        ArrayList errorInfoList = Lists.newArrayListWithExpectedSize((int)10);
        if (CollectionUtils.isEmpty(notHasWorkFlowList)) {
            return errorInfoList;
        }
        for (DynamicObject advert : notHasWorkFlowList) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue((Object)advert.getLong("id"));
            errorInfo.setMessage(advert.get("number") + "\uff1a " + AdvertFieldConstants.notHasWorkFlow());
            errorInfoList.add(errorInfo);
        }
        return errorInfoList;
    }

    private static List<IOperateInfo> getDisableChannelAdvErrors(List<DynamicObject> disableChannelList) {
        ArrayList errorInfoList = Lists.newArrayListWithExpectedSize((int)10);
        if (CollectionUtils.isEmpty(disableChannelList)) {
            return errorInfoList;
        }
        if (disableChannelList.size() == 1) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            String channelName = disableChannelList.get(0).getDynamicObject("channel").getString("name");
            errorInfo.setPkValue((Object)disableChannelList.get(0).getLong("id"));
            errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\u6e20\u9053\u5df2\u7981\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6e20\u9053\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChannelAdvDetailPlugin_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), channelName));
            errorInfoList.add(errorInfo);
            return errorInfoList;
        }
        for (DynamicObject advert : disableChannelList) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            String channelName = advert.getDynamicObject("channel").getString("name");
            errorInfo.setPkValue((Object)advert.getLong("id"));
            errorInfo.setMessage(ResManager.loadKDString((String)"{0}:\"{1}\"\u6e20\u9053\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", (String)"AdvertTplExCommonHelper_4", (String)"tsc-tsirm-business", (Object[])new Object[]{advert.get("number"), channelName}));
            errorInfoList.add(errorInfo);
        }
        return errorInfoList;
    }

    private static Pair<String, List<String>> touchOffWorkFlowOrNot(List<DynamicObject> adverts, List<DynamicObject> disableChannelAdverts, List<DynamicObject> needApprovalAdverts, List<DynamicObject> notConfChannels) {
        ArrayList directPubList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList waitPubList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList auditAdverts = Lists.newArrayListWithExpectedSize((int)10);
        auditAdverts.addAll(needApprovalAdverts);
        auditAdverts.addAll(notConfChannels);
        auditAdverts.addAll(disableChannelAdverts);
        List<DynamicObject> notCommentAdvert = adverts.stream().filter(notComment -> !auditAdverts.stream().map(all -> all.getDynamicObject("channel").getLong("id")).collect(Collectors.toList()).contains(notComment.getDynamicObject("channel").getLong("id"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notCommentAdvert)) {
            for (DynamicObject advert : notCommentAdvert) {
                boolean isDirectPub = advertBizService.pubOrWaitByStart(advert);
                if (isDirectPub) {
                    directPubList.add(advert);
                    continue;
                }
                waitPubList.add(advert);
            }
            AdvertDetailExDataHelper.getInstance().saveAdverts(notCommentAdvert);
            advertBizService.updateOnePosAdvCount(notCommentAdvert);
        }
        if (!CollectionUtils.isEmpty(needApprovalAdverts)) {
            DynamicObject advbillTpl = AdvertTplExCommonHelper.generateAdvbillTpl(needApprovalAdverts);
            AdvertTplExCommonHelper.setAdverts(adverts, needApprovalAdverts, advbillTpl);
            AdvertDetailExDataHelper.getInstance().saveAdverts(needApprovalAdverts);
            String matchErrMsg = AdvertTplExCommonHelper.matchWorkflowCheck(advbillTpl);
            logger.info("fast publish  by work flow suit result {}", (Object)matchErrMsg);
            if (HRStringUtils.isNotEmpty((String)matchErrMsg)) {
                notConfChannels.addAll(needApprovalAdverts);
                needApprovalAdverts = Collections.emptyList();
            } else {
                logger.info("fast publish  by execute work flow ");
                AdvertTplExCommonHelper.touchOffWorkFlow(advbillTpl);
            }
        }
        List<IOperateInfo> notConfErrors = AdvertTplExCommonHelper.getAuditAdvErrors(notConfChannels);
        List<IOperateInfo> disableErrors = AdvertTplExCommonHelper.getDisableChannelAdvErrors(disableChannelAdverts);
        logger.info("get publish msg by needApprovalAdverts {},directPubList {},waitPubList {}, notConfErrors {},disableErrors {}", new Object[]{needApprovalAdverts.size(), directPubList.size(), waitPubList.size(), notConfErrors.size(), disableErrors.size()});
        return advertBizService.getPublishMsg(needApprovalAdverts, directPubList, waitPubList, notConfErrors, disableErrors, false);
    }

    @NotNull
    private static Pair<List<DynamicObject>, Pair<List<DynamicObject>, List<DynamicObject>>> getNeedApprovalAdverts(int channelNum, List<DynamicObject> adverts, List<Long> channelIdList) {
        ArrayList channelNeedApprovals = Lists.newArrayListWithExpectedSize((int)channelNum);
        Pair<Boolean, List<Long>> confByChannel = AdvertConfigHelper.getConfByChannel(channelIdList);
        logger.info("conf channel info is {} ", confByChannel);
        if (((Boolean)confByChannel.getLeft()).booleanValue()) {
            channelNeedApprovals.addAll(CollectionUtils.isEmpty((Collection)((Collection)confByChannel.getRight())) ? Collections.emptyList() : (Collection)confByChannel.getRight());
        }
        ArrayList needApprovalAdverts = Lists.newArrayListWithCapacity((int)channelNum);
        ArrayList errorAdvertList = Lists.newArrayListWithCapacity((int)channelNum);
        ArrayList disableAdvertList = Lists.newArrayListWithCapacity((int)channelNum);
        List<Long> disableChannelIds = AdvertBizService.getInstance().getDisableChannelIds();
        boolean advertWorkFlow = AdvertConfigHelper.isHasAdvertWorkFlow();
        adverts.forEach(advert -> {
            long advertChannelId = advert.getDynamicObject("channel").getLong("id");
            if (!disableChannelIds.isEmpty() && disableChannelIds.contains(advertChannelId)) {
                disableAdvertList.add(advert);
            } else if (!channelNeedApprovals.isEmpty() && channelNeedApprovals.contains(advertChannelId)) {
                if (advertWorkFlow) {
                    needApprovalAdverts.add(advert);
                } else {
                    errorAdvertList.add(advert);
                }
            }
        });
        return Pair.of((Object)disableAdvertList, (Object)Pair.of((Object)needApprovalAdverts, (Object)errorAdvertList));
    }

    private static void setAdverts(List<DynamicObject> adverts, List<DynamicObject> needApprovalAdverts, DynamicObject advbillTpl) {
        adverts.forEach(advert -> {
            if (needApprovalAdverts.contains(advert)) {
                advert.set("approvalid", (Object)advbillTpl.getLong("id"));
                advert.set("approvestatus", (Object)"B");
                advert.set("advbillno", (Object)advbillTpl.getString("billno"));
            } else {
                advert.set("approvalid", (Object)0L);
                advert.set("approvestatus", (Object)"");
                advert.set("advbillno", (Object)"");
                advert.set("advertstatus", (Object)"S");
            }
        });
    }

    @NotNull
    private static DynamicObject getAdvert(DynamicObject dataEntity, DynamicObject channelObject, long id, DynamicObject channel) {
        DynamicObject emptyAdvert = AdvertDetailExDataHelper.getInstance().generateEmptyAdvert();
        HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)emptyAdvert);
        emptyAdvert.set("id", (Object)id);
        long channelId = channelObject.getLong("channelet");
        Object[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
        if (ArrayUtils.isNotEmpty((Object[])fieldsByChannel)) {
            Arrays.stream(fieldsByChannel).forEach(fieldName -> {
                String entryEntityFieldName = fieldName + "et";
                emptyAdvert.set(fieldName, channelObject.get(entryEntityFieldName));
            });
        }
        emptyAdvert.set("channel", (Object)channel.getDynamicObject("fbasedataid"));
        emptyAdvert.set("advertstatus", (Object)"A");
        emptyAdvert.set("approvestatus", (Object)"A");
        emptyAdvert.set("advertisementrd", (Object)channel.getDynamicObject("fbasedataid").getString("advertisement"));
        return emptyAdvert;
    }

    public static void activeOldAdvertBill(DynamicObject dataEntity, List<DynamicObject> advertBillList, Boolean needAuditByChannel) {
        String status = dataEntity.getString("advertstatus");
        if ("D".equals(status) && needAuditByChannel.booleanValue()) {
            AdvertTplExCommonHelper.needAudit(dataEntity, advertBillList, "D");
        } else if ("E".equals(status) && needAuditByChannel.booleanValue()) {
            AdvertTplExCommonHelper.needAudit(dataEntity, advertBillList, "E");
            dataEntity.set("failreason", (Object)" ");
        } else if (!needAuditByChannel.booleanValue()) {
            dataEntity.set("advertstatus", (Object)"S");
            dataEntity.set("failreason", (Object)" ");
            dataEntity.set("approvestatus", (Object)"Z");
            advertBizService.advPubStatusByRangeDate(dataEntity, new Date());
        }
    }

    private static void needAudit(DynamicObject dataEntity, List<DynamicObject> advertBillList, String advStatus) {
        dataEntity.set("approvestatus", (Object)"B");
        dataEntity.set("enable", (Object)1);
        dataEntity.set("advertstatus", (Object)advStatus);
        DynamicObject advBillTpl = AdvertTplExCommonHelper.generateAdvbillTpl(Collections.singletonList(dataEntity));
        Optional.ofNullable(advBillTpl).ifPresent(advBill -> {
            advertBillList.add(advBillTpl);
            dataEntity.set("advbillno", (Object)advBillTpl.getString("billno"));
            dataEntity.set("approvalid", (Object)advBillTpl.getLong("id"));
            dataEntity.set("vid", (Object)((DynamicObject)advBillTpl.getDynamicObjectCollection("entryentity").get(0)).getLong("id"));
        });
    }

    public static String matchWorkflowCheck(DynamicObject advbillTpl) {
        if (!WorkflowServiceHelper.existProcDefByEntityNumber((String)"tsirm_advertbill").booleanValue() || CollectionUtils.isEmpty((Collection)WorkflowServiceHelper.getEnabledProcesses((DynamicObject)advbillTpl, (String)"submit"))) {
            return ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5de5\u4f5c\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"AdvertTplExCommonHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        return null;
    }

    public static void touchOffWorkFlow(DynamicObject advbillTpl) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("isStrict", String.valueOf(false));
        options.setVariableValue("ignoreValidation", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"submit", (String)"tsirm_advertbill", (DynamicObject[])new DynamicObject[]{advbillTpl}, (OperateOption)options);
    }

    public static void touchOffWorkFlows(List<DynamicObject> advbillTplList) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("isStrict", String.valueOf(false));
        options.setVariableValue("ignoreValidation", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"submit", (String)"tsirm_advertbill", (DynamicObject[])advbillTplList.toArray(new DynamicObject[advbillTplList.size()]), (OperateOption)options);
    }

    private static DynamicObject generateAdvbillTpl(List<DynamicObject> adverts) {
        if (CollectionUtils.isEmpty(adverts)) {
            logger.error("advert is empty ,return empty data ,flow is over");
            return null;
        }
        DynamicObject firstAdvert = adverts.get(0);
        DynamicObject advertBill = AdvBillTplDataHelper.getInstance().generateEmptyAdvertBill();
        advertBill.set("id", (Object)ID.genLongId());
        String number = CodeRuleServiceHelper.getNumber((String)"tsirm_advertbill", (DynamicObject)advertBill, null);
        advertBill.set("billno", (Object)number);
        advertBill.set("billstatus", (Object)"A");
        advertBill.set("auditstatus", (Object)"B");
        String billName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5e7f\u544a\u7533\u8bf7\u5355", (String)"AdvertTplExCommonHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), firstAdvert.getString("name"));
        advertBill.set("name", (Object)billName);
        advertBill.set("adminorg", (Object)firstAdvert.getDynamicObject("adminorg"));
        advertBill.set("advertbuorg", (Object)firstAdvert.getDynamicObject("position").getDynamicObject("createorg"));
        advertBill.set("position", (Object)firstAdvert.getDynamicObject("position"));
        String channelNames = adverts.stream().map(adv -> adv.getDynamicObject("channel").getString("name") + ",").collect(Collectors.joining());
        channelNames = CommonUtils.subStrBySize((String)channelNames, (int)190);
        advertBill.set("category", (Object)channelNames);
        advertBill.set("creator", (Object)TSCRequestContext.getUserId());
        DynamicObjectCollection billEntity = advertBill.getDynamicObjectCollection("entryentity");
        int index = 0;
        for (DynamicObject advert : adverts) {
            DynamicObject billEntry = billEntity.addNew();
            HRDynamicObjectUtils.copy((DynamicObject)advert, (DynamicObject)billEntry);
            billEntry.set("entityname", (Object)advert.getString("name"));
            billEntry.set("advertid", (Object)advert.getLong("id"));
            billEntry.set("seq", (Object)index);
            ++index;
        }
        return advertBill;
    }

    public static List<DynamicObject> updateAdvertByApproval(DynamicObject[] dynamicObjects, boolean isDirectPub) {
        LinkedList<DynamicObject> saveObjs = new LinkedList<DynamicObject>();
        ArrayList directPubAdvList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject advertApproval : dynamicObjects) {
            DynamicObject[] advertObjs;
            DynamicObjectCollection approvalEntry = advertApproval.getDynamicObjectCollection("entryentity");
            Map<Long, DynamicObject> approvalAdvertMap = approvalEntry.stream().collect(Collectors.toMap(approve -> approve.getLong("advertid_id"), approvalAdvert -> approvalAdvert));
            for (DynamicObject advertObj : advertObjs = AdvertDetailExDataHelper.getInstance().getAdvertListByIds(approvalAdvertMap.keySet())) {
                long advertId = advertObj.getLong("id");
                DynamicObject advertSnap = approvalAdvertMap.get(advertId);
                if (!(advertSnap.getBoolean("isaudit") ^ isDirectPub)) continue;
                AdvertTplExCommonHelper.advertCopySrcToDest(advertObj, advertSnap);
                if (isDirectPub) {
                    advertBizService.pubOrWaitByStart(advertObj);
                    approvalEntry.remove((Object)advertSnap);
                    directPubAdvList.add(advertObj);
                }
                saveObjs.add(advertObj);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)directPubAdvList)) {
            advertBizService.updateOnePosAdvCount(directPubAdvList);
        }
        AdvertDetailExDataHelper.getInstance().saveAdvertDetail(saveObjs);
        return saveObjs;
    }

    public static void advertCopySrcToDest(DynamicObject dest, DynamicObject src) {
        AdvertTplExCommonHelper.advertCopySrcToDest(dest, src, null, true);
    }

    public static void advertCopySrcToDest(DynamicObject dest, DynamicObject src, DynamicObject channelData, boolean isSetChannel) {
        block10: {
            block9: {
                dest.set("fullname", src.get("fullname"));
                String srcObjName = src.getDynamicObjectType().getName();
                String destObjName = dest.getDynamicObjectType().getName();
                Object srcName = HRStringUtils.equals((String)srcObjName, (String)"entryentity") ? src.get("entityname") : src.get("name");
                if (HRStringUtils.equals((String)destObjName, (String)"entryentity")) {
                    dest.set("entityname", srcName);
                } else {
                    dest.set("name", srcName);
                }
                dest.set("isdisposcode", src.get("isdisposcode"));
                dest.set("reccategory", src.get("reccategory"));
                dest.set("recruscene", src.get("recruscene"));
                dest.set("poscategory", src.get("poscategory"));
                DynamicObjectCollection destWkAddr = dest.getDynamicObjectCollection("workaddr");
                DynamicObjectCollection sourceWkAddr = src.getDynamicObjectCollection("workaddr");
                if (CollectionUtils.isNotEmpty((Collection)sourceWkAddr) && null != destWkAddr) {
                    destWkAddr.clear();
                    sourceWkAddr.forEach(row -> {
                        if (null == row) {
                            return;
                        }
                        DynamicObject newRow = destWkAddr.addNew();
                        newRow.set("fbasedataid", (Object)row.getDynamicObject("fbasedataid"));
                    });
                }
                dest.set("salarytype", src.get("salarytype"));
                dest.set("currency", src.get("currency"));
                dest.set("issalarynego", src.get("issalarynego"));
                dest.set("salarydown", src.get("salarydown"));
                dest.set("salaryup", src.get("salaryup"));
                dest.set("holdofftyp", src.get("holdofftyp"));
                dest.set("workexpdown", src.get("workexpdown"));
                dest.set("workexpup", src.get("workexpup"));
                dest.set("isworkexplimit", src.get("isworkexplimit"));
                dest.set("education", src.get("education"));
                dest.set("isedulimit", src.get("isedulimit"));
                dest.set("recruitnum", src.get("recruitnum"));
                dest.set("isrecnumlimit", src.get("isrecnumlimit"));
                dest.set("jobseq", (Object)src.getDynamicObject("jobseq"));
                dest.set("lowjobgrade", (Object)src.getDynamicObject("lowjobgrade"));
                dest.set("highjobgrade", (Object)src.getDynamicObject("highjobgrade"));
                dest.set("lowjoblevel", (Object)src.getDynamicObject("lowjoblevel"));
                dest.set("highjoblevel", (Object)src.getDynamicObject("highjoblevel"));
                dest.set("posrespon", src.get("posrespon"));
                dest.set("posqual", src.get("posqual"));
                dest.set("poshighlight", src.get("poshighlight"));
                dest.set("startdate", src.get("startdate"));
                dest.set("enddate", src.get("enddate"));
                if (!isSetChannel) {
                    return;
                }
                if (channelData == null) break block9;
                long channelId = channelData.getLong("channel_id");
                String[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
                if (null == fieldsByChannel) {
                    return;
                }
                for (String fieldName : fieldsByChannel) {
                    dest.set(fieldName, channelData.get(fieldName));
                }
                break block10;
            }
            long channelId = src.getLong("channel_id");
            Object[] fieldsByChannel = ChannelFieldEnum.getFieldsByChannel((long)channelId);
            if (null == fieldsByChannel) {
                return;
            }
            if (!ArrayUtils.isNotEmpty((Object[])fieldsByChannel)) break block10;
            for (Object fieldName : fieldsByChannel) {
                if ("adminorgsdpt".equals(fieldName)) {
                    DynamicObjectCollection adminorgsdpt = dest.getDynamicObjectCollection("adminorgsdpt");
                    DynamicObjectCollection source = src.getDynamicObjectCollection("adminorgsdpt");
                    if (!CollectionUtils.isNotEmpty((Collection)source)) continue;
                    adminorgsdpt.clear();
                    source.forEach(row -> {
                        if (null != row) {
                            DynamicObject newRow = adminorgsdpt.addNew();
                            newRow.set("fbasedataid", (Object)row.getDynamicObject("fbasedataid"));
                        }
                    });
                    continue;
                }
                dest.set((String)fieldName, src.get((String)fieldName));
            }
        }
    }
}

