/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsirm.common.entity.advert.HandlerResult;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.HRStructureTreeOrgHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertTplExDataHelper {
    private static final HRBaseServiceHelper ADVERTTPLEXDATAHELPER = new HRBaseServiceHelper("tsirm_adverttplex");
    private static final String SELECT_PROPERTIES = "id,status,advertstatus,refreshtime,stoptime,pubtime,advertpubstatus,channel,position,approvalid";

    private AdvertTplExDataHelper() {
    }

    public static QFilter getAdvertPositionPerm(String filterKey) {
        PositionPermService positionPermService = PositionPermService.getInstance(null);
        QFilter qFilter = positionPermService.getHavePermPositionQFilter();
        if (qFilter == null) {
            return null;
        }
        List<Long> positionIds = positionPermService.listHavePermPosition(qFilter);
        return new QFilter(filterKey, "in", positionIds);
    }

    public static boolean getAdvertOrgPerm(Long userId) {
        return PermissionServiceHelper.isSuperUser((long)userId);
    }

    public static boolean getAdvertOrgPerm() {
        return AdvertTplExDataHelper.getAdvertOrgPerm(TSCRequestContext.getUserId());
    }

    @Deprecated
    public static QFilter getOrgPerm(String filterKey) {
        HasPermOrgResult userHasPermOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)TSCRequestContext.getUserId());
        List hasPermOrgIds = userHasPermOrgIds.getHasPermOrgs();
        return new QFilter(filterKey, "in", (Object)hasPermOrgIds);
    }

    public static List<Long> getAllPermOrgIds(String entityId) {
        Pair permOrg = HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserPermOrg((String)"tsirm", (String)entityId, (String)"47150e89000000ac");
        return (List)permOrg.getValue();
    }

    public Map<Long, HandlerResult> countAdvert(List<Long> param) {
        DynamicObject[] adverts;
        HashMap result = Maps.newHashMapWithExpectedSize((int)param.size());
        QFilter qFilter = new QFilter("position", "in", param);
        qFilter.and(new QFilter("channel", "!=", (Object)1180));
        for (DynamicObject advert : adverts = ADVERTTPLEXDATAHELPER.query("id,advertstatus,position", qFilter.toArray())) {
            DynamicObject position = advert.getDynamicObject("position");
            HandlerResult handlerResult = result.getOrDefault(position.getLong("id"), new HandlerResult());
            String status = advert.getString("advertstatus");
            handlerResult.setAdvStatus(status);
            result.put(position.getLong("id"), handlerResult);
        }
        return result;
    }

    public void calculatePosAdvNum(DynamicObject[] dbDataEntities) {
        List<Long> positionIds = Arrays.stream(dbDataEntities).map(adv -> adv.getDynamicObject("position").getLong("id")).collect(Collectors.toList());
        Map<Long, HandlerResult> positionAdvCounts = this.countAdvert(positionIds);
        PositionDataHelper.updatePubCountByPositionId(positionAdvCounts, positionIds);
    }

    public static AdvertTplExDataHelper getInstance() {
        return AdvertTplExDataHelperHolder.ADVERT_TPL_EX_DATA_HELPER;
    }

    public DynamicObject generateEmptyAdvert() {
        return ADVERTTPLEXDATAHELPER.generateEmptyDynamicObject();
    }

    public DynamicObject queryAdvert(Long advertId) {
        if (HRObjectUtils.isEmpty((Object)advertId)) {
            return this.generateEmptyAdvert();
        }
        return ADVERTTPLEXDATAHELPER.queryOne(SELECT_PROPERTIES, new QFilter("id", "=", (Object)advertId));
    }

    private static class AdvertTplExDataHelperHolder {
        private static final AdvertTplExDataHelper ADVERT_TPL_EX_DATA_HELPER = new AdvertTplExDataHelper();

        private AdvertTplExDataHelperHolder() {
        }
    }
}

