/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

public class AdvertUpadteHelper {
    public Boolean updateAdvertisementByPositionId(Long positionId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_adverttplex");
        HRBaseServiceHelper positionServiceHelper = new HRBaseServiceHelper("tsirm_positiontpl");
        if (positionId == null) {
            return Boolean.FALSE;
        }
        ArrayList<DynamicObject> allAdverts = new ArrayList<DynamicObject>(10);
        QFilter selectAdvertFilter = new QFilter("position", "=", (Object)positionId).and(new QFilter("channel", "=", (Object)1180));
        DynamicObject[] adverts = serviceHelper.loadDynamicObjectArray(selectAdvertFilter.toArray());
        QFilter selectPositionFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject position = positionServiceHelper.loadDynamicObject(selectPositionFilter.toArray());
        for (DynamicObject advert : adverts) {
            this.workaddrAssignment(advert, position);
            this.advertUpdate(advert, position);
            allAdverts.add(advert);
        }
        if (!allAdverts.isEmpty()) {
            serviceHelper.update(allAdverts.toArray(new DynamicObject[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void advertUpdate(DynamicObject advert, DynamicObject position) {
        advert.set("name", (Object)position.getLocaleString("name"));
        advert.set("fullname", (Object)(position.getLocaleString("name") + "(" + position.getString("number") + ")"));
        advert.set("reccategory", (Object)position.getDynamicObject("reccategory"));
        advert.set("recruscene", (Object)position.getDynamicObject("recruscene"));
        advert.set("poscategory", (Object)position.getDynamicObject("poscategory"));
        advert.set("salarytype", (Object)position.getDynamicObject("salarytype"));
        advert.set("currency", (Object)position.getDynamicObject("currency"));
        advert.set("salarydown", (Object)position.getLong("salarydown"));
        advert.set("salaryup", (Object)position.getLong("salaryup"));
        boolean isSalaryNego = position.getBoolean("issalarynego");
        if (position.getLong("salarydown") == 0L && position.getLong("salaryup") == 0L && !isSalaryNego) {
            isSalaryNego = true;
        }
        advert.set("issalarynego", (Object)isSalaryNego);
        advert.set("holdofftyp", (Object)position.getDynamicObject("holdofftyp"));
        advert.set("workexpdown", (Object)position.getInt("workexpdown"));
        advert.set("workexpup", (Object)position.getInt("workexpup"));
        boolean isWorkExpLimit = position.getBoolean("isworkexplimit");
        if (position.getInt("workexpdown") == 0 && position.getInt("workexpup") == 0 && !isWorkExpLimit) {
            isWorkExpLimit = true;
        }
        advert.set("isworkexplimit", (Object)isWorkExpLimit);
        DynamicObject education = position.getDynamicObject("education");
        boolean isEduLimit = position.getBoolean("isedulimit");
        if (HRObjectUtils.isEmpty((Object)position.getDynamicObject("education")) && !position.getBoolean("isedulimit")) {
            isEduLimit = true;
        }
        advert.set("education", (Object)education);
        advert.set("isedulimit", (Object)isEduLimit);
        int recruitNum = position.getInt("recruitnum");
        boolean isRecnumLimit = position.getBoolean("isrecnumlimit");
        if (recruitNum == 0 && !isRecnumLimit) {
            isRecnumLimit = true;
        }
        advert.set("recruitnum", (Object)recruitNum);
        advert.set("isrecnumlimit", (Object)isRecnumLimit);
        advert.set("posrespon", (Object)position.getLocaleString("posrespon"));
        advert.set("posqual", (Object)position.getLocaleString("anoposrequirement"));
        advert.set("position", (Object)position.getLong("id"));
    }

    public void workaddrAssignment(DynamicObject advert, DynamicObject position) {
        DynamicObjectCollection workAddrCollection = advert.getDynamicObjectCollection("workaddr");
        workAddrCollection.clear();
        if (position.getDynamicObjectCollection("workaddr").size() > 0) {
            for (int num = 0; num < position.getDynamicObjectCollection("workaddr").size(); ++num) {
                DynamicObject workAddrDynamicObject = workAddrCollection.addNew();
                workAddrDynamicObject.set("fbasedataid", (Object)((DynamicObject)position.getDynamicObjectCollection("workaddr").get(num)).getDynamicObject("fbasedataid"));
            }
        }
    }
}

