/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service.schedule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;

public class DisableAdvertJob
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date now = new Date();
        DynamicObject[] queryList = AdvertBusinessHelper.queryDisableAdvertForJob(now);
        ArrayList advertLists = Lists.newArrayListWithExpectedSize((int)queryList.length);
        HashMap creatorMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject advert : queryList) {
            boolean isSuccess = this.doDisableAdvert(advert);
            this.updateAdvert(advert, isSuccess, advertLists);
            long creator = advert.getDynamicObject("creator").getLong("id");
            long modifier = 0L;
            if (null != advert.getDynamicObject("modifyuser")) {
                modifier = advert.getDynamicObject("modifyuser").getLong("id");
            }
            if (modifier != 0L && modifier != creator) {
                this.putMapByUser(creatorMap, modifier, advert);
            }
            this.putMapByUser(creatorMap, creator, advert);
            advert.set("istop", (Object)false);
            advert.set("isurgent", (Object)false);
            advert.set("topuser", null);
            advert.set("topstarttime", null);
            advert.set("topendtime", (Object)now);
            advert.set("urgentuser", null);
            advert.set("urgentstarttime", null);
            advert.set("urgentendtime", (Object)now);
        }
        AdvertDetailExDataHelper.getInstance().saveAdvertDetail(advertLists);
        AdvertTplExDataHelper.getInstance().calculatePosAdvNum(queryList);
        AdvertBusinessHelper.sendSystemAdvertNotice(creatorMap, false);
    }

    private void putMapByUser(Map<Long, List<DynamicObject>> messageMap, long userId, DynamicObject advert) {
        List modifyAdv = messageMap.getOrDefault(userId, new ArrayList(10));
        modifyAdv.add(advert);
        messageMap.put(userId, modifyAdv);
    }

    private void updateAdvert(DynamicObject advert, boolean isPubSuccess, List<DynamicObject> advertLists) {
        Date date = new Date();
        if (isPubSuccess) {
            advert.set("stoptime", (Object)date);
            advert.set("refreshtime", (Object)date);
            advert.set("advertstatus", (Object)"D");
        }
        advertLists.add(advert);
    }

    private boolean doDisableAdvert(DynamicObject advert) {
        return true;
    }
}

