/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service.schedule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;

public class PublishAdvertJob
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date now = new Date();
        DynamicObject[] queryList = AdvertBusinessHelper.queryPubAdvertForJob(now);
        ArrayList advertLists = Lists.newArrayListWithExpectedSize((int)queryList.length);
        HashMap creatorMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject advert : queryList) {
            boolean enable = advert.getDynamicObject("channel").getBoolean("enable");
            boolean posClose = AdvertBizService.getInstance().checkPositionClose(advert);
            boolean isSuccess = this.doPublishAdvert(advert);
            if (!enable) {
                this.setFialAdvert(advert, advertLists);
            } else {
                if (posClose) continue;
                this.updateAdvert(advert, isSuccess, advertLists);
            }
            long creator = advert.getDynamicObject("creator").getLong("id");
            long modifier = 0L;
            if (null != advert.getDynamicObject("modifyuser")) {
                modifier = advert.getDynamicObject("modifyuser").getLong("id");
            }
            if (modifier != 0L && modifier != creator) {
                this.putMapByUser(creatorMap, modifier, advert);
            }
            this.putMapByUser(creatorMap, creator, advert);
        }
        AdvertDetailExDataHelper.getInstance().saveAdvertDetail(advertLists);
        AdvertTplExDataHelper.getInstance().calculatePosAdvNum(queryList);
        AdvertBusinessHelper.sendSystemAdvertNotice(creatorMap, true);
    }

    private void putMapByUser(Map<Long, List<DynamicObject>> messageMap, long userId, DynamicObject advert) {
        List modifyAdv = messageMap.getOrDefault(userId, new ArrayList(10));
        modifyAdv.add(advert);
        messageMap.put(userId, modifyAdv);
    }

    private void updateAdvert(DynamicObject advert, boolean isPubSuccess, List<DynamicObject> advertLists) {
        Date date = new Date();
        advert.set("pubtime", (Object)date);
        advert.set("refreshtime", (Object)date);
        advert.set("advertstatus", (Object)"S");
        advert.set("failreason", (Object)" ");
        advertLists.add(advert);
    }

    private void setFialAdvert(DynamicObject advert, List<DynamicObject> advertLists) {
        advert.set("advertstatus", (Object)"E");
        advert.set("failreason", (Object)ResManager.loadKDString((String)"\u6e20\u9053\u5df2\u88ab\u7981\u7528", (String)"AdvertTplExCommonHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        advertLists.add(advert);
    }

    private boolean doPublishAdvert(DynamicObject advert) {
        return true;
    }
}

