/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service.state;

import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPublishHelper;
import kd.tsc.tsirm.business.domain.advert.service.state.StateChangeAdvertPage;
import kd.tsc.tsirm.common.enums.advert.ChannelFieldEnum;
import org.apache.commons.lang3.tuple.Pair;

public class ApprovalBillPageViewState
implements StateChangeAdvertPage {
    public static final String BAR_EDIT = "bar_edit";
    public static final String BAR_UNSUBMIT = "bar_unsubmit";
    public static final String BAR_VIEWFLOWCHART = "bar_viewflowchart";
    public static final String BAR_SAVE = "bar_save";
    public static final String BAR_SUBMIT = "bar_submit";
    public static final String BAR_DELETE = "bar_del";
    private static final String BAR_ABANDON = "abandon";
    private static final String SLOT_FLEX = "slotflex";
    private static final String SHOW_POS_TIP = "showPosTip";

    @Override
    public void showPageViewAfterLoadData(IFormView formView, OperationStatus operationStatus) {
        this.showPubWaitModifyTip(formView);
        String approvalId = (String)formView.getFormShowParameter().getCustomParam("businessKey");
        if (HRStringUtils.isNotEmpty((String)approvalId)) {
            formView.setVisible(Boolean.FALSE, new String[]{"aduitrecordflex", SLOT_FLEX});
            this.showPosStatusTipWhenEdit(formView);
        } else {
            String showTip = formView.getPageCache().get(SHOW_POS_TIP);
            if (operationStatus.getValue() == OperationStatus.EDIT.getValue() && HRStringUtils.isEmpty((String)showTip)) {
                AdvertPublishHelper.showPosStatusTip(formView);
                formView.getPageCache().put(SHOW_POS_TIP, "1");
            }
        }
        this.isAuditChangeInPage(formView);
        this.showAdvValidTime(formView);
    }

    @Override
    public void showPageBar(IFormView formView, OperationStatus operationStatus) {
        OperationStatus status = formView.getFormShowParameter().getStatus();
        String auditStatus = (String)formView.getModel().getValue("billstatus");
        formView.getFormShowParameter().getStatus();
        formView.setVisible(Boolean.FALSE, new String[]{BAR_EDIT, BAR_UNSUBMIT, BAR_SAVE, BAR_SUBMIT, BAR_VIEWFLOWCHART, BAR_DELETE, "refresh", BAR_ABANDON});
        switch (auditStatus) {
            case "B": {
                formView.setVisible(Boolean.TRUE, new String[]{BAR_UNSUBMIT, BAR_VIEWFLOWCHART, "refresh"});
                break;
            }
            case "A": {
                if (status.getValue() == OperationStatus.VIEW.getValue()) {
                    formView.setVisible(Boolean.TRUE, new String[]{BAR_EDIT, BAR_DELETE, BAR_VIEWFLOWCHART, "refresh"});
                    break;
                }
                formView.setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT, BAR_VIEWFLOWCHART});
                break;
            }
            case "G": {
                if (status.getValue() == OperationStatus.VIEW.getValue()) {
                    formView.setVisible(Boolean.TRUE, new String[]{BAR_EDIT, BAR_VIEWFLOWCHART, "refresh", BAR_ABANDON});
                    break;
                }
                formView.setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT});
                break;
            }
            case "D": {
                formView.setVisible(Boolean.TRUE, new String[]{BAR_VIEWFLOWCHART, "refresh"});
                break;
            }
            case "C": 
            case "E": {
                formView.setVisible(Boolean.TRUE, new String[]{BAR_VIEWFLOWCHART});
                break;
            }
        }
    }

    private void showPosStatusTipWhenEdit(IFormView formView) {
        DynamicObject approval = formView.getModel().getDataEntity(true);
        Pair<Boolean, String> result = AdvertBusinessHelper.checkPositionAudit(approval);
        String msg = null;
        if (((Boolean)result.getLeft()).booleanValue() && HRStringUtils.isNotEmpty((String)((String)result.getRight()))) {
            msg = ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u6682\u505c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5ba1\u6279\u5e7f\u544a\u3002", (String)"ApprovalBillPageViewState_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        } else if (!((Boolean)result.getLeft()).booleanValue()) {
            msg = ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u5173\u95ed/\u5df2\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5ba1\u6279\u5e7f\u544a\u3002", (String)"ApprovalBillPageViewState_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.isNotEmpty(msg)) {
            formView.showTipNotification(msg);
        }
    }

    private void showAdvValidTime(IFormView formView) {
        DynamicObjectCollection advSnaps = formView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        boolean isShowRange = false;
        for (DynamicObject advSnap : advSnaps) {
            long channelId = advSnap.getLong("channel_id");
            if (ChannelFieldEnum.isAutoPubAndClose((long)channelId)) continue;
            isShowRange = true;
        }
        String publishViewId = formView.getPageCache().get("cachePublicPageId");
        IFormView publishView = formView.getView(publishViewId);
        publishView.setVisible(Boolean.valueOf(isShowRange), new String[]{"startdate", "enddate"});
        formView.sendFormAction(publishView);
    }

    private void isAuditChangeInPage(IFormView formView) {
        String customParam = (String)formView.getFormShowParameter().getCustomParam("from");
        String count = formView.getPageCache().get(formView.getPageId() + "COUNT");
        if (HRStringUtils.isNotEmpty((String)customParam) && formView.getEntityId().equals("tsirm_advertbill") && HRStringUtils.isBlank((CharSequence)count)) {
            formView.showSuccessNotification(customParam);
            formView.getFormShowParameter().getCustomParams().remove("from");
            formView.getPageCache().put(formView.getPageId() + "COUNT", "1");
        }
    }

    private void showPubWaitModifyTip(IFormView formView) {
        String opPubWait = (String)formView.getFormShowParameter().getCustomParam("waitpubmodify");
        Boolean isShowTip = Boolean.FALSE;
        if (HRStringUtils.equals((String)opPubWait, (String)"1")) {
            isShowTip = Boolean.TRUE;
            formView.getFormShowParameter().setCustomParam("waitpubmodify", (Object)"0");
            formView.cacheFormShowParameter();
        }
        formView.setVisible(isShowTip, new String[]{"tipsflex"});
    }
}

