/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.advert.service.state;

import java.util.Date;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPublishHelper;
import kd.tsc.tsirm.business.domain.advert.service.state.StateChangeAdvertPage;
import kd.tsc.tsirm.business.domain.advert.service.valid.FieldValidHelper;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;

public class ChannelDetailViewState
implements StateChangeAdvertPage {
    public static final String BAR_EDIT = "bar_edit";
    public static final String BAR_START = "bar_start";
    public static final String BAR_STOP = "bar_stop";
    public static final String BAR_PREVIEW = "bar_preview";
    public static final String BAR_REFRESH = "bar_refresh";
    public static final String BAR_MODIFY = "bar_modify";
    public static final String FLEX_STARTTIME = "starttimeflex";
    public static final String FLEX_STOPTIME = "stoptimeflex";
    public static final String TOP = "top";
    public static final String UN_TOP = "untop";
    public static final String URGENT = "urgent";
    public static final String UN_URGENT = "unurgent";

    @Override
    public void showPageViewAfterLoadData(IFormView formView, OperationStatus operationStatus) {
        Date pubTime;
        DynamicObject advert = formView.getModel().getDataEntity();
        AdvertBizService.getInstance().judgeFieldShow(formView, advert.getLong("channel_id"), operationStatus, true);
        IntrecoPageHelper.isShowElement(formView, "istop", "title_istop");
        IntrecoPageHelper.isShowElement(formView, "isurgent", "title_isurgent");
        IntrecoPageHelper.isShowElement(formView, "isreward", "reawrdflex");
        IntrecoPageHelper.isShowElement(formView, "reward", "title_reward");
        IntrecoPageHelper.isShowElement(formView, "rewardpoint", "title_rewardpoint");
        formView.setEnable(Boolean.FALSE, AdvertPublishHelper.ONLY_SHOW);
        String advStatus = (String)formView.getModel().getValue("advertstatus");
        formView.setVisible(Boolean.FALSE, new String[]{FLEX_STOPTIME});
        if (HRStringUtils.equals((String)advStatus, (String)"D")) {
            formView.setVisible(Boolean.TRUE, new String[]{FLEX_STOPTIME});
        }
        if (HRObjectUtils.isEmpty((Object)(pubTime = (Date)formView.getModel().getValue("pubtime")))) {
            formView.setVisible(Boolean.FALSE, new String[]{FLEX_STARTTIME});
        }
        Boolean flag = operationStatus.getValue() == OperationStatus.VIEW.getValue();
        formView.setVisible(Boolean.valueOf(flag == false), new String[]{"name", "isdisposcode"});
        formView.setVisible(flag, new String[]{"fullname"});
        if (!flag.booleanValue()) {
            formView.setEnable(Boolean.FALSE, new String[]{"number"});
        }
        AdvertPublishHelper.initSalaryType(formView);
        AdvertBusinessHelper.setAdvertPageData(formView, new FieldValidHelper(formView));
        if (operationStatus.getValue() == OperationStatus.EDIT.getValue()) {
            AdvertBusinessHelper.tipPositionStop(formView, advert);
        }
    }

    @Override
    public void showPageBar(IFormView formView, OperationStatus operationStatus) {
        DynamicObject advertDetail = formView.getModel().getDataEntity(true);
        String advStatus = advertDetail.getString("advertstatus");
        DynamicObject channel = advertDetail.getDynamicObject("channel");
        boolean channelStatus = channel.getBoolean("enable");
        formView.setVisible(Boolean.FALSE, new String[]{BAR_EDIT, BAR_START, BAR_STOP, BAR_PREVIEW, BAR_REFRESH, "barpublish", BAR_MODIFY, TOP, UN_TOP, URGENT, UN_URGENT});
        boolean isViewStatus = operationStatus.getValue() == OperationStatus.VIEW.getValue();
        formView.setVisible(Boolean.valueOf(isViewStatus), new String[]{"refresh"});
        boolean top = advertDetail.getBoolean("istop");
        formView.setVisible(Boolean.valueOf(top), new String[]{UN_TOP});
        boolean urgent = advertDetail.getBoolean("isurgent");
        formView.setVisible(Boolean.valueOf(urgent), new String[]{UN_URGENT});
        switch (advStatus) {
            case "S": {
                if (AdvertConfigHelper.needAuditByChannel(advertDetail).booleanValue()) {
                    this.showPubSuccessBar(formView, channelStatus);
                    break;
                }
                if (isViewStatus) {
                    this.showPubSuccessBar(formView, channelStatus);
                    break;
                }
                formView.setVisible(Boolean.valueOf(channelStatus), new String[]{"barpublish"});
                break;
            }
            case "D": {
                formView.setVisible(Boolean.valueOf(channelStatus), new String[]{BAR_START});
                break;
            }
            case "E": {
                formView.setVisible(Boolean.valueOf(channelStatus), new String[]{BAR_START});
                break;
            }
            case "K": {
                if (isViewStatus) {
                    formView.setVisible(Boolean.valueOf(channelStatus), new String[]{BAR_EDIT});
                    break;
                }
                formView.setVisible(Boolean.valueOf(channelStatus), new String[]{"barpublish"});
                break;
            }
            case "A": {
                if (isViewStatus) {
                    formView.setVisible(Boolean.valueOf(channelStatus), new String[]{BAR_MODIFY});
                    break;
                }
                formView.setVisible(Boolean.valueOf(channelStatus), new String[]{"barpublish"});
                break;
            }
        }
    }

    private void showPubSuccessBar(IFormView formView, Boolean channelStatus) {
        boolean top;
        formView.setVisible(channelStatus, new String[]{BAR_EDIT, BAR_STOP});
        DynamicObject advert = formView.getModel().getDataEntity(true);
        String pubType = advert.getString("advertisementrd");
        if (!HRStringUtils.equals((String)pubType, (String)"D")) {
            formView.setVisible(Boolean.TRUE, new String[]{BAR_PREVIEW, BAR_REFRESH});
        }
        formView.setVisible(Boolean.valueOf(!(top = advert.getBoolean("istop"))), new String[]{TOP});
        boolean urgent = advert.getBoolean("isurgent");
        formView.setVisible(Boolean.valueOf(!urgent), new String[]{URGENT});
    }
}

