/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileFilterHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOfferHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFilePositionHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileDataHelper {
    private static final Log logger = LogFactory.getLog(AppFileDataHelper.class);

    private AppFileDataHelper() {
    }

    public static boolean isExistFilterTaskByAppFileId(Long appFileId) {
        return AppFileFilterHelper.isExistFilterTaskByAppFileId(appFileId);
    }

    public static Map<Long, String> queryPosPrinByAppFileId(List<Long> posIds) {
        return AppFilePositionHelper.queryPosPrinByAppFileId(posIds);
    }

    public static DynamicObject queryAppFileById(Object appFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilemdl");
        return helper.queryOne(appFileId);
    }

    public static DynamicObject queryAppFileById(String properties, Object appFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilemdl");
        return helper.queryOne(properties, appFileId);
    }

    public static int queryOtherAppCount(Long mid, Long appFileId) {
        return AppFileStdRsmHelper.queryOtherAppCount(mid, appFileId);
    }

    public static boolean haveAuthorityForAppFile(Long appFileId, String appId) {
        return AppFileRightHelper.hasRight(appFileId, appId, (Long)TSCRequestContext.getUserId(), "47150e89000000ac");
    }

    public static Set<Long> getAppFileIdsByStdRsmMidsAndPositionId(Set<Long> stdRsmMids, Long positionId) {
        return AppFileStdRsmHelper.getAppFileIdsByStdRsmMidsAndPositionId(stdRsmMids, positionId);
    }

    public static void updateAppFileFilterFeedBackData(List<Long> appFileIdList) {
        AppFileFilterHelper.updateAppFileFilterFeedBackData(appFileIdList);
    }

    public static List<Map<String, Object>> offerInit(DynamicObject[] dataEntities) {
        ArrayList offerCreateReqVos = Lists.newArrayList();
        for (DynamicObject dataEntity : dataEntities) {
            if (!AppFileOfferHelper.validateOfferStatus(dataEntity)) continue;
            HashMap offerCreateReqVo = Maps.newHashMap();
            offerCreateReqVo.put("appFileId", dataEntity.getLong("id"));
            offerCreateReqVo.put("busunitId", dataEntity.getLong("createorg.id"));
            offerCreateReqVo.put("busunitName", dataEntity.getString("createorg.name"));
            offerCreateReqVo.put("phone", dataEntity.getString("phone"));
            offerCreateReqVo.put("email", dataEntity.getString("email"));
            offerCreateReqVo.put("age", dataEntity.getInt("appres.age"));
            offerCreateReqVo.put("gender", dataEntity.getLong("appres.gender.id"));
            offerCreateReqVo.put("nationality", dataEntity.getString("appres.natreg.name"));
            offerCreateReqVo.put("nationalityId", dataEntity.getLong("appres.natreg.id"));
            offerCreateReqVo.put("userName", dataEntity.getString("name"));
            offerCreateReqVo.put("workage", dataEntity.getInt("appres.workingyears"));
            offerCreateReqVos.add(offerCreateReqVo);
        }
        Object obj = DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"socialOfferServiceApi", (String)"createOfferBatch", (Object[])new Object[]{SerializationUtils.toJsonString((Object)offerCreateReqVos)});
        if (obj != null && HRStringUtils.isNotEmpty((String)obj.toString())) {
            ArrayList returnData = (ArrayList)SerializationUtils.fromJsonString((String)obj.toString(), ArrayList.class);
            AppFileDataHelper.updateOfferStatus(returnData);
            return returnData;
        }
        return Lists.newArrayList();
    }

    public static void updateOfferStatus(List<Map<String, Object>> appFileIdOfferStatusList) {
        ArrayList appFileIdList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        ArrayList offerStatusList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        ArrayList inductionStatusList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        ArrayList isDisCardList = Lists.newArrayListWithCapacity((int)appFileIdOfferStatusList.size());
        for (Map<String, Object> data : appFileIdOfferStatusList) {
            Object appFileId = data.get("appFileId");
            if (appFileId == null) continue;
            appFileIdList.add(Long.parseLong(appFileId.toString()));
            offerStatusList.add(data.get("offerStatus"));
            inductionStatusList.add(data.get("inductionStatus"));
            isDisCardList.add(data.get("appfileInProcess"));
        }
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIdList, TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"offerstatus", "laborrelstatus", "filestatus", "emptime", "number", "stdrsm.id"}));
                HashMap idDyMaps = Maps.newHashMapWithExpectedSize((int)appFiles.length);
                for (DynamicObject appFile : appFiles) {
                    idDyMaps.put(appFile.getLong("id"), appFile);
                }
                ArrayList revertAppFiles = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
                for (int i = 0; i < appFileIdList.size(); ++i) {
                    DynamicObject appFile = (DynamicObject)idDyMaps.get(appFileIdList.get(i));
                    if (offerStatusList.get(i) != null) {
                        appFile.set("offerstatus", offerStatusList.get(i));
                    }
                    if (!"true".equals(isDisCardList.get(i)) || !AppFileHelper.isToBeEmployed(appFile)) continue;
                    revertAppFiles.add(appFile);
                }
                AppFileStatusHelper.revertInProcess(revertAppFiles);
                AppFileStatusHelper.setInductionStatus(appFileIdList, idDyMaps, inductionStatusList);
                AppFileHelper.update(appFiles);
            }
            catch (Exception ex) {
                tx.markRollback();
                logger.error("updateOfferStatus.error", (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void updateAppFileLastFilterFKStartTime(List<Long> appFileIdList, Date date) {
        DynamicObject[] appFiles;
        for (DynamicObject appFile : appFiles = AppFileHelper.queryAppFiles(appFileIdList, "lastfilterfkstarttime")) {
            appFile.set("lastfilterfkstarttime", (Object)date);
        }
        AppFileHelper.update(appFiles);
    }

    public static DynamicObject[] queryHireInfoAppFile(List<Long> appFileIdList) {
        String selectProps = TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"empolyfeedbackresult", "jobrankstatus", "setsalarystatus", "employapprlsatatus", "employrecomnewesttime", "employapprlnewesttime", "lasthirejobrankstarttime", "lasthiresalarystartime"});
        return AppFileHelper.queryAppFiles(appFileIdList, selectProps);
    }

    public static void updateHireInfoAppFile(DynamicObject[] appFiles) {
        AppFileHelper.update(appFiles);
    }

    public static DynamicObject[] queryAppFileNameAndPhoto(List<Long> appFileIds) {
        String selectProperties = "id,name,appres.photo,appres,position";
        return AppFileHelper.queryAppFiles(appFileIds, selectProperties);
    }

    public static Map<Long, DynamicObject> getAppFileNameAndPhotoMap(List<Long> appFileIds) {
        DynamicObject[] appFiles = AppFileDataHelper.queryAppFileNameAndPhoto(appFileIds);
        HashMap<Long, DynamicObject> appFileMap = new HashMap<Long, DynamicObject>(appFileIds.size());
        for (int i = 0; i < appFiles.length; ++i) {
            appFileMap.put(appFiles[i].getLong("id"), appFiles[i]);
        }
        return appFileMap;
    }

    public static DynamicObject getAdminorgByAppFileId(Long appFileId) {
        String selectProperties = "id,adminorg";
        return AppFileHelper.queryOne(appFileId, selectProperties);
    }
}

