/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class AppFileDomainService {
    private AppFileDomainService() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateAppFileExam(Map<Long, DynamicObject> appFileIdAndExamDyn) {
        DynamicObject[] appFileDyns;
        for (DynamicObject appFileDyn : appFileDyns = AppFileDomainService.getAppFiles(appFileIdAndExamDyn)) {
            Long appFileId = appFileDyn.getLong("id");
            DynamicObject examDyn = appFileIdAndExamDyn.get(appFileId);
            String lastExamName = null;
            String lastExamResult = null;
            Date lastExamTime = null;
            if (examDyn != null) {
                lastExamName = examDyn.getString("name");
                lastExamTime = examDyn.getDate("examtime");
                lastExamResult = examDyn.getString("result");
            }
            appFileDyn.set("lastexamatitle", (Object)lastExamName);
            appFileDyn.set("lastexamatime", (Object)lastExamTime);
            appFileDyn.set("lastexamaresult", (Object)lastExamResult);
        }
        HRBaseServiceHelper appFileService = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_appfilemdl");
        appFileService.update(appFileDyns);
    }

    public static void updateAppFileExamWritten(Map<Long, DynamicObject> appFileIdAndExamDyn) {
        DynamicObject[] appFileDyns;
        for (DynamicObject appFileDyn : appFileDyns = AppFileDomainService.getAppFiles(appFileIdAndExamDyn)) {
            Long appFileId = appFileDyn.getLong("id");
            DynamicObject examDyn = appFileIdAndExamDyn.get(appFileId);
            String score = null;
            Date lastExamTime = null;
            ILocaleString title = null;
            String result = null;
            if (examDyn != null) {
                lastExamTime = examDyn.getDate("examtime");
                score = examDyn.getString("score");
                title = examDyn.getLocaleString("name");
                result = examDyn.getString("result");
            }
            appFileDyn.set("lastexamwname", title);
            appFileDyn.set("lastexamwtime", (Object)lastExamTime);
            appFileDyn.set("lastexamwscore", (Object)score);
            appFileDyn.set("lastresult", (Object)result);
        }
        HRBaseServiceHelper appFileService = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_appfilemdl");
        appFileService.update(appFileDyns);
    }

    private static DynamicObject[] getAppFiles(Map<Long, DynamicObject> appFileIdAndExamDyn) {
        ArrayList appFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdAndExamDyn.size());
        appFileIdAndExamDyn.forEach((appFileId, examDyn) -> appFileIds.add(appFileId));
        HRBaseServiceHelper appFileService = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_appfilemdl");
        return appFileService.loadDynamicObjectArray(new QFilter("id", "in", (Object)appFileIds).toArray());
    }
}

