/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileFlowLockConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileFlowLockStatusEnum;
import kd.tsc.tsrbd.business.domain.config.service.ConfigSysCfgParamHelper;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileFlowLockHelper {
    private static final Log logger = LogFactory.getLog(AppFileFlowLockHelper.class);
    private static final int LOCK_TIME_DAYS = 5;
    private static final String KEY_FLOWLOCKTTL = "flowlockctl";
    private static final HRBaseServiceHelper FLOW_LOCK_HELPER = new HRBaseServiceHelper("tsirm_appfileflowlock");
    private static final String SELECT_PROPS = "stdrsmid,appfile,locktime,autounlocktime,locker,islocked,unlocktype";

    private AppFileFlowLockHelper() {
    }

    public static void lockAppFile(Long stdRsmId, Long appFileId, Date lockTime, Date autoUnLockTime) {
        AppFileFlowLockHelper.lockAppFile(stdRsmId, appFileId, lockTime, autoUnLockTime, TSCRequestContext.getUserId());
    }

    public static void lockAppFile(Long stdRsmId, Long appFileId, Date lockTime, Date autoUnLockTime, Long lockerId) {
        DynamicObject flowLockDy = AppFileFlowLockHelper.genFlowLockInfos(stdRsmId, appFileId, lockTime, autoUnLockTime, lockerId);
        flowLockDy.set("islocked", (Object)AppFileFlowLockConstants.STS_LOCKED);
        AppFileFlowLockHelper.saveLockInfos(new DynamicObject[]{flowLockDy});
    }

    public static void saveLockInfos(DynamicObject[] lockInfos) {
        try (TXHandle tx = TX.required();){
            try {
                FLOW_LOCK_HELPER.save(lockInfos);
                Set stdRsmIdSet = Arrays.stream(lockInfos).map(dyo -> dyo.getLong("stdrsmid")).collect(Collectors.toSet());
                Set lockIdSet = Arrays.stream(lockInfos).map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
                QFilter oldLockInfoFilter = new QFilter("stdrsmid", "in", stdRsmIdSet);
                oldLockInfoFilter.and("id", "not in", lockIdSet);
                FLOW_LOCK_HELPER.deleteByFilter(oldLockInfoFilter.toArray());
            }
            catch (Exception exception) {
                tx.markRollback();
                logger.error("lockAppFiles.error", (Throwable)exception);
            }
        }
    }

    public static void lockAppFile(DynamicObject appFile) {
        Date lockTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date autoUnLockTime = AppFileFlowLockHelper.getAutoUnLockTime(lockTime);
        AppFileFlowLockHelper.lockAppFile(appFile.getLong("stdrsm.id"), appFile.getLong("id"), lockTime, autoUnLockTime);
    }

    public static void lockAppFiles(List<Long> appFileIds, Long lockerId) {
        if (!appFileIds.isEmpty()) {
            DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIds, "stdrsm.id");
            List<Long> stdRsmIds = Arrays.stream(appFiles).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
            Date lockTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
            Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIds);
            for (DynamicObject appFile : appFiles) {
                Long stdRsmId = appFile.getLong("stdrsm.id");
                DynamicObject lockInfo = flowLockInfos.get(stdRsmId);
                if (lockInfo != null) continue;
                Date autoUnLockTime = AppFileFlowLockHelper.getAutoUnLockTime(lockTime);
                AppFileFlowLockHelper.lockAppFile(appFile.getLong("stdrsm.id"), appFile.getLong("id"), lockTime, autoUnLockTime, lockerId);
            }
        }
    }

    public static void unLockAppFile(List<Long> stdRsmIdList) {
        AppFileFlowLockHelper.unLockAppFile(stdRsmIdList, "0");
    }

    public static void unLockAppFile(List<Long> stdRsmIdList, String unLockType) {
        try {
            DynamicObject[] flowLockInfos = AppFileFlowLockHelper.getFlowLockDys(stdRsmIdList, AppFileFlowLockConstants.STS_LOCKED);
            if (flowLockInfos.length > 0) {
                for (DynamicObject flowLockInfo : flowLockInfos) {
                    flowLockInfo.set("islocked", (Object)AppFileFlowLockConstants.STS_UNLOCKED);
                    flowLockInfo.set("unlocktype", (Object)unLockType);
                }
                AppFileFlowLockHelper.saveLockInfos(flowLockInfos);
            }
        }
        catch (RuntimeException ex) {
            logger.error("unLockAppFile.error:{}", stdRsmIdList, (Object)ex);
            throw ex;
        }
    }

    private static DynamicObject genFlowLockInfos(Long stdRsmId, Long appFileId, Date lockTime, Date autoUnLockTime, Long lockerId) {
        DynamicObject flowLockDy = FLOW_LOCK_HELPER.generateEmptyDynamicObject();
        flowLockDy.set("id", (Object)ID.genLongId());
        flowLockDy.set("stdrsmid", (Object)stdRsmId);
        flowLockDy.set("appfile", (Object)appFileId);
        flowLockDy.set("locktime", (Object)lockTime);
        flowLockDy.set("autounlocktime", (Object)autoUnLockTime);
        flowLockDy.set("locker", (Object)lockerId);
        return flowLockDy;
    }

    public static Map<Long, String> getFlowLockData(List<DynamicObject> appFiles) {
        return AppFileFlowLockHelper.getFlowLockData(appFiles, false);
    }

    public static Map<Long, String> getFlowLockData(List<DynamicObject> appFiles, boolean ignoreAppFileStatus) {
        HashMap result = Maps.newHashMap();
        List<Long> stdRsmIds = appFiles.stream().map(dyo -> dyo.getLong("stdrsm.id")).filter(id -> id != 0L).collect(Collectors.toList());
        Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIds);
        for (DynamicObject row : appFiles) {
            boolean status;
            long appFileId = row.getLong("id");
            long stdRsmId = row.getLong("stdrsm.id");
            DynamicObject lockInfo = flowLockInfos.get(stdRsmId);
            boolean bl = status = !ignoreAppFileStatus && !AppFileHelper.isInProcessOrEmp(row);
            if (lockInfo == null || status) {
                result.put(appFileId, AppFileFlowLockStatusEnum.UNLOCK.getStatus());
                continue;
            }
            if (HRObjectUtils.equals((Object)lockInfo.getLong("appfile.id"), (Object)appFileId)) {
                result.put(appFileId, AppFileFlowLockStatusEnum.BLUE_LOCK.getStatus());
                continue;
            }
            result.put(appFileId, AppFileFlowLockStatusEnum.GRAY_LOCK.getStatus());
        }
        return result;
    }

    public static Map<Long, DynamicObject> getFlowLockInfosByStdRsmId(List<Long> stdRsmIdList) {
        return AppFileFlowLockHelper.getFlowLockInfos(stdRsmIdList, AppFileFlowLockConstants.STS_LOCKED);
    }

    public static Map<Long, DynamicObject> getFlowLockInfos(List<Long> stdRsmIdList, Boolean isLocked) {
        HashMap result = Maps.newHashMap();
        if (!stdRsmIdList.isEmpty()) {
            DynamicObject[] flowLockInfos;
            for (DynamicObject flowLockInfo : flowLockInfos = AppFileFlowLockHelper.getFlowLockDys(stdRsmIdList, isLocked)) {
                result.put(flowLockInfo.getLong("stdrsmid"), flowLockInfo);
            }
        }
        return result;
    }

    private static DynamicObject[] getFlowLockDys(List<Long> stdRsmIdList, Boolean isLocked) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        QFilter[] qFilters = new QFilter[]{AppFileFlowLockHelper.getLockedQFilter(stdRsmIdList, nowTime, isLocked)};
        return FLOW_LOCK_HELPER.query(SELECT_PROPS, qFilters);
    }

    public static DynamicObject getFlowLockInfo(Long stdRsmId) {
        Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfos(Collections.singletonList(stdRsmId), AppFileFlowLockConstants.STS_LOCKED);
        return flowLockInfos.get(stdRsmId);
    }

    public static QFilter getLockedQFilter(List<Long> stdRsmIdList, Date currDate, boolean isLocked) {
        QFilter qFilter = new QFilter("autounlocktime", ">", (Object)currDate);
        qFilter.and("islocked", "=", (Object)isLocked);
        qFilter.and("stdrsmid", "in", stdRsmIdList);
        return qFilter;
    }

    public static Date getAutoUnLockTime(Date lockTime) {
        long flowLockTTL;
        Object flowLockTTLObj = ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)KEY_FLOWLOCKTTL);
        if (flowLockTTLObj != null && (flowLockTTL = Long.parseLong(flowLockTTLObj.toString())) > 0L) {
            return HRDateTimeUtils.addDay((Date)lockTime, (long)flowLockTTL);
        }
        return HRDateTimeUtils.addDay((Date)lockTime, (long)5L);
    }

    public static void showFlowLockInfoPage(Long appFileId, IFormView view) {
        DynamicObject appFile = AppFileHelper.queryOne(appFileId);
        Long stdRsmId = appFile.getLong("stdrsm.id");
        DynamicObject flowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(stdRsmId);
        if (flowLockInfo != null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tsirm_appfileflowlockinfo");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("data", (Object)DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{flowLockInfo}, (DynamicObjectType)flowLockInfo.getDynamicObjectType()));
            view.showForm(showParameter);
        } else {
            view.showTipNotification(TSCBaseKDString.dataChangedTip());
        }
    }

    public static void showLockConfirm(AbstractFormPlugin plugin, List<Pair<String, String>> numberNamePairList) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("lock", (IFormPlugin)plugin);
        String name = AppFileOpHelper.getErrorMulTipHead(numberNamePairList, false);
        String confirmMessage = String.format(Locale.ROOT, AppFileResManagerHelper.getLockSureDesc(), name);
        plugin.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public static void showUnLockConfirm(AbstractFormPlugin plugin, List<Pair<String, String>> numberNamePairList) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("unlock", (IFormPlugin)plugin);
        String name = AppFileOpHelper.getErrorMulTipHead(numberNamePairList, false);
        String confirmMessage = String.format(Locale.ROOT, AppFileResManagerHelper.getUnLockSureDesc(), name);
        plugin.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public static void mergeCandidate(Long mainId, Long subId) {
        try (TXHandle tx = TX.required();){
            DynamicObject subStdFlowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(subId);
            if (subStdFlowLockInfo == null) {
                return;
            }
            try {
                DynamicObject mainStdFlowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(mainId);
                if (mainStdFlowLockInfo == null) {
                    long lockAppFileId = subStdFlowLockInfo.getLong("appfile.id");
                    DynamicObject lockAppFile = AppFileHelper.queryOne(lockAppFileId);
                    Long positionId = lockAppFile.getLong("position.id");
                    DynamicObject[] mainAppFiles = AppFileHelper.queryAppFiles("id", new QFilter[]{AppFileHelper.getInAppFileQFilter(mainId, positionId)});
                    if (mainAppFiles.length > 0) {
                        subStdFlowLockInfo.set("appfile", (Object)mainAppFiles[0].getLong("id"));
                    }
                    subStdFlowLockInfo.set("stdrsmid", (Object)mainId);
                    AppFileFlowLockHelper.saveLockInfos(new DynamicObject[]{subStdFlowLockInfo});
                } else {
                    AppFileFlowLockHelper.unLockAppFile(Collections.singletonList(subId));
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                logger.error("mergeCandidate.error", (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void eliminateAppFiles(DynamicObject[] appFiles) {
        Map<Long, String> flowLockData = AppFileFlowLockHelper.getFlowLockData(Lists.newArrayList((Object[])appFiles), true);
        List<Long> stdRsmIdList = Arrays.stream(appFiles).filter(appFile -> AppFileFlowLockStatusEnum.BLUE_LOCK.getStatus().equals(flowLockData.get(appFile.getLong("id")))).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
        AppFileFlowLockHelper.unLockAppFile(stdRsmIdList, "1");
    }

    public static void archiveAppFiles(DynamicObject[] appFiles) {
        Map<Long, String> flowLockData = AppFileFlowLockHelper.getFlowLockData(Lists.newArrayList((Object[])appFiles), true);
        List<Long> stdRsmIdList = Arrays.stream(appFiles).filter(appFile -> AppFileFlowLockStatusEnum.BLUE_LOCK.getStatus().equals(flowLockData.get(appFile.getLong("id")))).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
        AppFileFlowLockHelper.unLockAppFile(stdRsmIdList, "3");
    }

    public static void recoverAppFile(DynamicObject[] appFiles) {
        List<Long> stdRsmIdList = Arrays.stream(appFiles).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> flowLockInfosHis = AppFileFlowLockHelper.getFlowLockInfos(stdRsmIdList, AppFileFlowLockConstants.STS_UNLOCKED);
        ArrayList updateFlowLockDyLists = Lists.newArrayListWithExpectedSize((int)flowLockInfosHis.size());
        for (DynamicObject appFile : appFiles) {
            Long lockedAppFileId;
            Long stdRsmId = appFile.getLong("stdrsm.id");
            Long appFileId = appFile.getLong("id");
            DynamicObject flowLockInfoHis = flowLockInfosHis.get(stdRsmId);
            if (flowLockInfoHis == null || !"1".equals(flowLockInfoHis.getString("unlocktype")) || !appFileId.equals(lockedAppFileId = Long.valueOf(flowLockInfoHis.getLong("appfile.id")))) continue;
            flowLockInfoHis.set("islocked", (Object)AppFileFlowLockConstants.STS_LOCKED);
            flowLockInfoHis.set("unlocktype", (Object)" ");
            updateFlowLockDyLists.add(flowLockInfoHis);
        }
        AppFileFlowLockHelper.saveLockInfos(updateFlowLockDyLists.toArray(new DynamicObject[0]));
    }

    public static Date getDate(String dateStr) {
        if (HRStringUtils.isNotEmpty((String)dateStr)) {
            try {
                return HRDateTimeUtils.parseDate((String)dateStr);
            }
            catch (ParseException e) {
                logger.error("AppFileFlowLockHelper.parseDateError", (Throwable)e);
            }
        }
        return null;
    }

    public static List<Long> getLockKeys() {
        QFilter qFilter = new QFilter("autounlocktime", ">", (Object)LocalDateTime.now());
        qFilter.and("islocked", "=", (Object)AppFileFlowLockConstants.STS_LOCKED);
        DynamicObject[] flowLockDys = FLOW_LOCK_HELPER.query(SELECT_PROPS, qFilter.toArray());
        return Arrays.stream(flowLockDys).map(dy -> dy.getLong("stdrsmid")).collect(Collectors.toList());
    }

    public static List<Long> getLockedAppFileIdList() {
        Map<Long, DynamicObject> lockedInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(AppFileFlowLockHelper.getLockKeys());
        return lockedInfoMap.values().stream().map(map -> map.getLong("appfile.id")).collect(Collectors.toList());
    }

    public static boolean isLocked(DynamicObject appFile) {
        Long stdRsmId = appFile.getLong("stdrsm.id");
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        QFilter[] qFilters = new QFilter[]{AppFileFlowLockHelper.getLockedQFilter(Collections.singletonList(stdRsmId), nowTime, true)};
        DynamicObject[] flowLockInfo = FLOW_LOCK_HELPER.query("id", qFilters);
        return flowLockInfo != null && flowLockInfo.length > 0;
    }

    public static List<Pair<ExtendedDataEntity, String>> getValidateFlowLockStatusTipList(Collection<ExtendedDataEntity> dataEntities) {
        List<Long> stdRsmIdList = dataEntities.stream().map(dyo -> dyo.getDataEntity().getLong("stdrsm.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> lockInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIdList);
        ArrayList tipList = Lists.newArrayListWithExpectedSize((int)dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject appFile = dataEntity.getDataEntity();
            Long stdRsmId = appFile.getLong("stdrsm.id");
            DynamicObject lockInfo = lockInfoMap.get(stdRsmId);
            if (lockInfo == null || appFile.getLong("id") != lockInfo.getLong("appfile.id") || String.valueOf(TSCRequestContext.getUserId()).equals(lockInfo.getString("locker.id"))) continue;
            String errorTip = ResManager.loadKDString((String)"\u5019\u9009\u4eba{0}\u5df2\u88ab{1}\u9501\u5b9a\uff0c\u4e0d\u80fd\u8fdb\u884c\u6dd8\u6c70\u3002", (String)"AppFileFlowLockHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[]{appFile.getString("name"), lockInfo.getString("locker.name")});
            tipList.add(Pair.of((Object)dataEntity, (Object)errorTip));
        }
        return tipList;
    }

    public static void unLockEmpedAppFiles(List<DynamicObject> appFiles) {
        if (!appFiles.isEmpty()) {
            ArrayList unLockStdRsmIds = Lists.newArrayListWithExpectedSize((int)appFiles.size());
            List<Long> stdRsmIds = appFiles.stream().map(dyo -> dyo.getLong("stdrsm.id")).filter(id -> id != 0L).collect(Collectors.toList());
            Map<Long, DynamicObject> flowLockInfos = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIds);
            for (DynamicObject appFile : appFiles) {
                long appFileId = appFile.getLong("id");
                long stdRsmId = appFile.getLong("stdrsm.id");
                DynamicObject lockInfo = flowLockInfos.get(stdRsmId);
                if (lockInfo == null || !HRObjectUtils.equals((Object)lockInfo.getLong("appfile.id"), (Object)appFileId)) continue;
                unLockStdRsmIds.add(stdRsmId);
            }
            AppFileFlowLockHelper.unLockAppFile(unLockStdRsmIds, "2");
        }
    }

    public static void showArchiveConfirm(AbstractFormPlugin plugin, List<Pair<String, String>> numberNamePairList) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("archive", (IFormPlugin)plugin);
        String confirmMessage = ResManager.loadKDString((String)"\u53d8\u52a8\u540e\uff0c\u5019\u9009\u4eba\u5c06\u65e0\u6cd5\u7ee7\u7eed\u63a8\u8fdb\u6d41\u7a0b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AppFileFlowLockHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        plugin.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public static List<String> checkAppFileIsGrayLock(List<Long> appFileIds, String opName) {
        ArrayList<String> msgList = new ArrayList<String>(2);
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles("id, stdrsm, filestatus, name, number", new QFilter[]{new QFilter("id", "in", appFileIds)});
        HashMap<Long, DynamicObject> appFileMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : appFiles) {
            appFileMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        ArrayList<DynamicObject> appFileColl = new ArrayList<DynamicObject>(appFiles.length);
        Collections.addAll(appFileColl, appFiles);
        Map<Long, String> flowLockInfos = AppFileFlowLockHelper.getFlowLockData(appFileColl);
        ArrayList<Long> grayAppFileIdList = new ArrayList<Long>(flowLockInfos.size());
        for (DynamicObject appFileDy : appFiles) {
            String lockInfo = flowLockInfos.get(appFileDy.getLong("id"));
            if (!AppFileFlowLockStatusEnum.GRAY_LOCK.getStatus().equals(lockInfo)) continue;
            grayAppFileIdList.add(appFileDy.getLong("id"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (ObjectUtils.isNotEmpty(grayAppFileIdList)) {
            int i;
            DynamicObject appFileDy;
            if (grayAppFileIdList.size() > 3) {
                for (i = 0; i < grayAppFileIdList.size(); ++i) {
                    Long appFileId = (Long)grayAppFileIdList.get(i);
                    appFileDy = (DynamicObject)appFileMap.get(appFileId);
                    stringBuilder.append(ResManager.loadKDString((String)"{0}}\uff1a{1}\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u8fdb\u884c{2}\u3002", (String)"AppFileFlowLockHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[]{appFileDy.getString("number"), appFileDy.getString("name"), opName}));
                    if (i == grayAppFileIdList.size() - 1) continue;
                    stringBuilder.append("\n");
                }
            } else {
                for (i = 0; i < grayAppFileIdList.size(); ++i) {
                    Long appFileId = (Long)grayAppFileIdList.get(i);
                    appFileDy = (DynamicObject)appFileMap.get(appFileId);
                    stringBuilder.append(appFileDy.getString("number"));
                    if (i == grayAppFileIdList.size() - 1) {
                        stringBuilder.append("\uff1a");
                        stringBuilder.append(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u8fdb\u884c{0}\u3002", (String)"AppFileFlowLockHelper_4", (String)"tsc-tsirm-business", (Object[])new Object[]{opName}));
                        continue;
                    }
                    stringBuilder.append('\u3001');
                }
            }
        }
        if (ObjectUtils.isNotEmpty((Object)stringBuilder.toString())) {
            if (grayAppFileIdList.size() > 3) {
                msgList.add(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e{1}\u5931\u8d25\uff0c\u8bf7\u79fb\u9664\u540e\u91cd\u65b0\u64cd\u4f5c", (String)"AppFileFlowLockHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[]{grayAppFileIdList.size(), opName}));
            }
            msgList.add(stringBuilder.toString());
        }
        return msgList;
    }

    public static List<Long> getGrayLockAppFileIdList() {
        QFilter qFilter = new QFilter("islocked", "=", (Object)true);
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        qFilter.and("autounlocktime", ">", (Object)nowTime);
        DynamicObject[] lockInfoDys = FLOW_LOCK_HELPER.query("stdrsmid, appfile.id", new QFilter[]{qFilter});
        List<Long> appFileGrayIdList = new ArrayList<Long>(16);
        if (ObjectUtils.isNotEmpty((Object)lockInfoDys)) {
            List stdRsmIdList = Arrays.stream(lockInfoDys).map(dynamicObject -> dynamicObject.getLong("stdrsmid")).collect(Collectors.toList());
            List appFileIdList = Arrays.stream(lockInfoDys).map(dynamicObject -> dynamicObject.getLong("appfile.id")).collect(Collectors.toList());
            QFilter qFilter1 = new QFilter("stdrsm", "in", stdRsmIdList);
            qFilter1.and("id", "not in", appFileIdList);
            DynamicObject[] appFileDys = AppFileHelper.queryAppFiles("id", new QFilter[]{qFilter1});
            if (ObjectUtils.isNotEmpty((Object)appFileDys)) {
                appFileGrayIdList = Arrays.stream(appFileDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            }
        }
        return appFileGrayIdList;
    }
}

