/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import com.google.common.collect.Lists;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileFlowLockStatusEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;

public class AppFileHeadHelper {
    public static final String KEY_STDRESENTRYPIC = "stdresentrypic";
    public static final String KEY_LBLCURLINKSTATUS = "lblcurlinkstatus";
    public static final String LABEL_POSITION = "lblposname";
    public static final String KEY_SIMILARIMG = "similarimg";
    public static final String KEY_GRAYLOCKPIC = "graylockpic";
    public static final String KEY_BLUELOCKPIC = "bluelockpic";
    public static final String KEY_BLACKLIST_ICON = "blacklisticon";
    public static final String KEY_ELIMINATEDPIC = "eliminatedpic";
    public static final String KEY_INVALIDPIC = "invalidpic";
    public static final String KEY_INPROCESSPIC = "inprocesspic";
    public static final String KEY_TBEMPPIC = "tbemppic";
    public static final String KEY_EMPEDPIC = "empedpic";
    public static final String KEY_ENDEMPPIC = "endemppic";

    public static void setHeadInfo(DynamicObject appFile, AbstractFormPlugin plugin) {
        if (appFile != null) {
            AppFileHeadHelper headHelper = new AppFileHeadHelper();
            headHelper.initAppResInfo(appFile.getDynamicObject("appres"), plugin.getView());
            DynamicObject position = appFile.getDynamicObject("position");
            AppFileHeadHelper.initPositionInfo(position, plugin);
            Label lblNumber = (Label)plugin.getControl("lblnumber");
            lblNumber.setText(appFile.getString("number"));
            DynamicObject recruStg = appFile.getDynamicObject("recrustg");
            DynamicObject recruStat = appFile.getDynamicObject("recrustat");
            if (recruStg != null) {
                Label lblLinkStatus = (Label)plugin.getControl(KEY_LBLCURLINKSTATUS);
                String recruStatName = recruStat == null ? ResManager.loadKDString((String)"\u65e0", (String)"AppFileHeadPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) : recruStat.getString("name");
                lblLinkStatus.setText(String.format("%s-%s", recruStg.getString("name"), recruStatName));
            }
        }
    }

    private static void initPositionInfo(DynamicObject position, AbstractFormPlugin plugin) {
        if (position != null) {
            String nothing = ResManager.loadKDString((String)"\u65e0", (String)"AppFileHeadPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            Label lblPosName = (Label)plugin.getControl(LABEL_POSITION);
            lblPosName.setText(position.getString("name"));
            Label lblPosBUName = (Label)plugin.getControl("lblposbuname");
            DynamicObject useOrg = position.getDynamicObject("createorg");
            String useOrgName = useOrg == null ? nothing : useOrg.getString("name");
            lblPosBUName.setText(useOrgName);
            Label lblAdmin = (Label)plugin.getControl("lbladmin");
            DynamicObject adminOrg = position.getDynamicObject("adminorg");
            String adminOrgName = adminOrg == null ? nothing : adminOrg.getString("name");
            lblAdmin.setText(adminOrgName);
        }
    }

    public void initAppResInfo(DynamicObject appRes, IFormView view) {
        RsmCommonService.initAppResInfo((DynamicObject)appRes, (IFormView)view);
    }

    public static void openInterviewerPositionForm(IFormView iFormView, long positionId, String positionName) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tsirm_position_view");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setCustomParam("positionId", (Object)String.valueOf(positionId));
        baseShowParameter.setCustomParam("posInterviewerForm", (Object)Boolean.TRUE);
        baseShowParameter.setCaption(positionName);
        baseShowParameter.setPkId((Object)positionId);
        StringBuilder pageId = new StringBuilder(String.valueOf(TSCRequestContext.getUserId()));
        pageId.append(positionId);
        pageId.append(iFormView.getPageId());
        baseShowParameter.setPageId(pageId.toString());
        iFormView.showForm((FormShowParameter)baseShowParameter);
    }

    public static void setPicVisible(AbstractFormPlugin plugin, DynamicObject appFile) {
        if (appFile != null) {
            AppFileHeadHelper.setFileStatusPicVisible(plugin, appFile);
            AppFileHeadHelper.showFlowStatusPic(plugin, appFile);
        }
    }

    private static void setFileStatusPicVisible(AbstractFormPlugin plugin, DynamicObject appFile) {
        String fileStatus = appFile.getString("filestatus");
        plugin.getView().setVisible(Boolean.valueOf(AppFileHelper.isOut(fileStatus)), new String[]{KEY_ELIMINATEDPIC});
        plugin.getView().setVisible(Boolean.valueOf(AppFileHelper.isInvalid(fileStatus)), new String[]{KEY_INVALIDPIC});
        plugin.getView().setVisible(Boolean.valueOf(AppFileHelper.isInProcess(fileStatus)), new String[]{KEY_INPROCESSPIC});
        plugin.getView().setVisible(Boolean.valueOf(AppFileHelper.isToBeEmployed(fileStatus)), new String[]{KEY_TBEMPPIC});
        plugin.getView().setVisible(Boolean.valueOf(AppFileHelper.isEmployed(fileStatus)), new String[]{KEY_EMPEDPIC});
        plugin.getView().setVisible(Boolean.valueOf(AppFileHelper.isEndEmployed(fileStatus)), new String[]{KEY_ENDEMPPIC});
        plugin.getView().setVisible(Boolean.FALSE, new String[]{KEY_SIMILARIMG});
    }

    private static void showFlowStatusPic(AbstractFormPlugin plugin, DynamicObject appFile) {
        Map<Long, String> flowLockData = AppFileFlowLockHelper.getFlowLockData(Lists.newArrayList((Object[])new DynamicObject[]{appFile}));
        String flowLockStatus = flowLockData.get(appFile.getLong("id"));
        plugin.getView().setVisible(Boolean.FALSE, new String[]{KEY_GRAYLOCKPIC, KEY_BLUELOCKPIC});
        if (AppFileFlowLockStatusEnum.GRAY_LOCK.getStatus().equals(flowLockStatus)) {
            plugin.getView().setVisible(Boolean.TRUE, new String[]{KEY_GRAYLOCKPIC});
        } else if (AppFileFlowLockStatusEnum.BLUE_LOCK.getStatus().equals(flowLockStatus)) {
            plugin.getView().setVisible(Boolean.TRUE, new String[]{KEY_BLUELOCKPIC});
        }
    }
}

