/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.id.ID;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvMailCommonHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.business.domain.perm.PermissionHelper;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.base.MiddleGroundPersonHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileHelper {
    private static final Log LOG = LogFactory.getLog(AppFileHelper.class);
    private static final HRBaseServiceHelper APP_FILE_SERVICE_HELPER = new HRBaseServiceHelper("tsirm_appfilemdl");
    private static final long ONE_MIN = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    public static final String BTN_OK = "btnok";
    public static final String BAR_SAVE = "bar_save";

    private AppFileHelper() {
    }

    public static DynamicObject[] queryAppFiles(List<Long> appFileIdList, String fields) {
        QFilter qFilter = new QFilter("id", "in", appFileIdList);
        return APP_FILE_SERVICE_HELPER.query(fields, qFilter.toArray());
    }

    public static void update(DynamicObject[] appFiles) {
        if (null != appFiles && appFiles.length > 0) {
            APP_FILE_SERVICE_HELPER.update(appFiles);
        }
    }

    public static DynamicObject queryOne(long id, String fields) {
        return APP_FILE_SERVICE_HELPER.queryOne(fields, (Object)id);
    }

    public static DynamicObject queryOne(long id) {
        return APP_FILE_SERVICE_HELPER.queryOne((Object)id);
    }

    public static void bindAppFileResume(DynamicObject[] appFileObjects) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        DynamicObject[] updateDynamicObject = new DynamicObject[appFileObjects.length];
        for (DynamicObject appFileObject : appFileObjects) {
            DynamicObject dynamicObject = APP_FILE_SERVICE_HELPER.generateDynamicObject((Object)appFileObject.getLong("id"), "id,isbinddelyrec,modifytime,modifier");
            dynamicObject.set("isbinddelyrec", (Object)"1");
            dynamicObject.set("modifytime", (Object)nowTime);
            dynamicObject.set("modifier", (Object)TSCRequestContext.getUserId());
            updateDynamicObject[i] = dynamicObject;
        }
        AppFileHelper.update(updateDynamicObject);
    }

    public static void invokeTransferPosOp(ListSelectedRowCollection selectedRows, IFormView view) {
        if (selectedRows != null && !selectedRows.isEmpty()) {
            OperateOption transferOp = OperateOption.create();
            transferOp.setVariableValue("position", String.valueOf(selectedRows.get(0).getPrimaryKeyValue()));
            transferOp.setVariableValue("istpeliminate", view.getPageCache().get("istpeliminate"));
            OperationResult operationResult = view.invokeOperation("transferpos", transferOp);
            if (operationResult.isSuccess()) {
                view.showSuccessNotification(operationResult.getMessage());
            }
        }
    }

    public static void invokeEliminateOp(DynamicObject eliminateModel, IFormView view) {
        Long reasonId = eliminateModel.getLong("eliminationreason.id");
        ILocaleString desc = eliminateModel.getLocaleString("description");
        OperateOption eliminateOp = OperateOption.create();
        eliminateOp.setVariableValue("eliminationreason", String.valueOf(reasonId));
        eliminateOp.setVariableValue("description", SerializationUtils.toJsonString((Object)desc));
        OperationResult operationResult = view.invokeOperation("eliminate", eliminateOp);
        if (operationResult.isSuccess()) {
            view.showSuccessNotification(operationResult.getMessage());
        }
    }

    public static DynamicObject getLastFileStatusRecord(Long appFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilestatusrectpl");
        DynamicObject[] records = helper.query("createtime", new QFilter[]{new QFilter("appfile", "=", (Object)appFileId)});
        if (records.length > 0) {
            return records[0];
        }
        return null;
    }

    public static String calDuration(Date startDate, Date endDate) {
        if (endDate == null || startDate == null) {
            return "0";
        }
        long endTime = endDate.getTime();
        long startTime = startDate.getTime();
        long gap = endTime - endTime % 60000L - (startTime - startTime % 60000L);
        return AppFileHelper.calDuration(gap);
    }

    public static String calDuration(Long gap) {
        long day = gap / 86400000L;
        long hour = gap % 86400000L / 3600000L;
        long min = gap % 3600000L / 60000L;
        StringBuilder result = new StringBuilder();
        if (day > 0L) {
            result.append(day).append('d');
            if (hour == 0L && min == 0L) {
                return result.toString();
            }
        }
        result.append(hour).append('h').append(min).append("min");
        return result.toString();
    }

    public static DynamicObjectCollection getProcStagesByProcId(Long procId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        return helper.queryOriginalCollection("entryentity.rqmtstg.id,entryentity.rqmtstg.name,entryentity.seq", new QFilter[]{new QFilter("id", "=", (Object)procId)}, "entryentity.seq");
    }

    public static Date getEndDateByStatus(DynamicObject appFile) {
        Date endDate = null;
        if (AppFileHelper.isInvalid(appFile) || AppFileHelper.isEndEmployed(appFile)) {
            DynamicObject lastFileStatusRecord = AppFileHelper.getLastFileStatusRecord(appFile.getLong("id"));
            endDate = lastFileStatusRecord != null ? lastFileStatusRecord.getDate("createtime") : HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        } else if (AppFileHelper.isOut(appFile)) {
            endDate = appFile.getDate("eliminatetime");
        } else if (AppFileHelper.isEmployed(appFile)) {
            endDate = appFile.getDate("emptime");
        }
        return endDate;
    }

    public static void showFillAddCandidatePage(IFormView view) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tsirm_srrsm");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)showParameter);
    }

    public static DynamicObject findAppFileByRsmId(Long rsmId) {
        String queryProp = "id,name,isbinddelyrec,phone,email,jobstatus,birthday,highesteduschool,highesteducation,appres,deliveryrec,applytime,resacqmthd,recruchnlnm,highestspecialty";
        QFilter qFilter = new QFilter("appres", "=", (Object)rsmId);
        return APP_FILE_SERVICE_HELPER.queryOne(queryProp, qFilter.toArray());
    }

    public static Pair<Long, Long> getPositionAndStageByAppFileId(Long appFileId) {
        DynamicObject appFile = APP_FILE_SERVICE_HELPER.queryOne("position.id,recrustg.id", (Object)appFileId);
        return Pair.of((Object)appFile.getLong("position.id"), (Object)appFile.getLong("recrustg.id"));
    }

    public static List<Map<String, Object>> getPositionByAppFileIds(List<Long> appFileId) {
        DynamicObject[] query = APP_FILE_SERVICE_HELPER.query("id,position.id,position.name,position.adminorg, phone, email", new QFilter[]{new QFilter("id", "in", appFileId)});
        if (Objects.isNull(query) || query.length <= 0) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)query.length);
        for (DynamicObject appfile : query) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("companyname", IntvMailCommonHelper.getCompanyName(appfile.getLong("position.adminorg.id")));
            map.put("positionname", appfile.getString("position.name"));
            map.put("adminorg", appfile.getString("position.adminorg.name"));
            map.put("appfilename", appfile.getString("name"));
            map.put("candidatename", appfile.getString("name"));
            map.put("phone", appfile.getString("phone"));
            map.put("email", appfile.getString("email"));
            map.put("bizobj", appfile.getLong("id"));
            map.put("businessId", appfile.getString("id"));
            result.add(map);
        }
        return result;
    }

    public static void showPositionFormView(long positionId, IFormView view) {
        long userId = TSCRequestContext.getUserId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPageId(userId + positionId + view.getPageId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setFormId("tsirm_position_view");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)positionId);
        baseShowParameter.setCustomParam("isSimpleView", (Object)true);
        String pageId = PageUtils.getPageId((String)String.valueOf(positionId), (String)"tsirm", (String)"tsirm_position_view", (String)view.getFormShowParameter().getRootPageId());
        baseShowParameter.setPageId(pageId);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static void showPositionViewForInterView(long positionId, IFormView view, String forViewStr, Long taskId) {
        long userId = TSCRequestContext.getUserId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPageId(userId + positionId + view.getPageId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setFormId("tsirm_positionir_view");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)positionId);
        baseShowParameter.setCustomParam("isSimpleView", (Object)true);
        baseShowParameter.setCustomParam("taskId", (Object)taskId);
        baseShowParameter.setCustomParam("fromView", (Object)forViewStr);
        String pageId = PageUtils.getPageId((String)String.valueOf(positionId), (String)"tsirm", (String)"tsirm_positionir_view", (String)view.getFormShowParameter().getRootPageId());
        baseShowParameter.setPageId(pageId);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static void showErrorNotification(DynamicObject positionObject, IFormView view) {
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u60a8\u6682\u65e0\u8be5\u804c\u4f4d\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"AppFileHelper_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        if (view instanceof BaseView) {
            view.showTipNotification(sb.toString());
        } else if (view.getParentView() != null) {
            view.getParentView().showErrorNotification(sb.toString());
            view.sendFormAction(view.getParentView());
        }
    }

    public static int queryRepeatDeliveryCount(Long appFileId) {
        int count;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_srrsm");
        try (DataSet dataSet = helper.queryDataSet("AppFileDataHelper.queryRepeatDeliveryCount", "delivery.id", new QFilter("appfile", "=", (Object)appFileId).toArray());){
            count = dataSet.count("delivery.id", true);
        }
        return count;
    }

    public static DynamicObject[] queryAppFiles(String fields, QFilter[] qFilters) {
        return APP_FILE_SERVICE_HELPER.query(fields, qFilters);
    }

    public static DataSet queryAppFilesId(String fields, QFilter[] qFilters) {
        return APP_FILE_SERVICE_HELPER.queryDataSet("tsirm_apofile", fields, qFilters);
    }

    public static boolean isInProcess(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_IN.equals(appFile.getString("filestatus"));
    }

    public static boolean isWaitChange(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_TBEMP.equals(appFile.getString("filestatus"));
    }

    public static boolean isInProcess(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_IN.equals(fileStatus);
    }

    public static boolean isOut(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_OUT.equals(appFile.getString("filestatus"));
    }

    public static boolean isOut(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_OUT.equals(fileStatus);
    }

    public static boolean isInvalid(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_INVALID.equals(appFile.getString("filestatus"));
    }

    public static boolean isInvalid(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_INVALID.equals(fileStatus);
    }

    public static boolean isToBeEmployed(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_TBEMP.equals(appFile.getString("filestatus"));
    }

    public static boolean isToBeEmployed(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_TBEMP.equals(fileStatus);
    }

    public static boolean isEmployed(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_EMPED.equals(appFile.getString("filestatus"));
    }

    public static boolean isEmployed(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_EMPED.equals(fileStatus);
    }

    public static boolean isEndEmployed(DynamicObject appFile) {
        return AppFileConstants.APP_FILE_STATUS_ENDEMP.equals(appFile.getString("filestatus"));
    }

    public static boolean isEndEmployed(String fileStatus) {
        return AppFileConstants.APP_FILE_STATUS_ENDEMP.equals(fileStatus);
    }

    public static boolean isInProcessOrEmp(DynamicObject appFile) {
        DataEntityPropertyCollection properties = appFile.getDynamicObjectType().getProperties();
        StringBuilder stringBuilder = new StringBuilder();
        for (IDataEntityProperty property : properties) {
            stringBuilder.append(property.getName());
            stringBuilder.append(":::");
        }
        LOG.info("isInProcessOrEmp.size:{}", (Object)properties.size());
        LOG.info("isInProcessOrEmp:{}", (Object)stringBuilder.toString());
        String fileStatus = appFile.getString("filestatus");
        return AppFileConstants.APP_FILE_STATUS_IN.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_TBEMP.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_EMPED.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_ENDEMP.equals(fileStatus);
    }

    public static boolean isInEmpStatus(DynamicObject appFile) {
        String fileStatus = appFile.getString("filestatus");
        return AppFileConstants.APP_FILE_STATUS_EMPED.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_TBEMP.equals(fileStatus) || AppFileConstants.APP_FILE_STATUS_INVALID.equals(fileStatus);
    }

    public static String getFileStatusDesc(DynamicObject appFile) {
        AppFileStatusEnum statusEnum = AppFileStatusEnum.getEnum((String)appFile.getString("filestatus"));
        if (statusEnum != null) {
            return statusEnum.getText().loadKDString();
        }
        return "";
    }

    public static QFilter getInAppFileQFilter(Long stdRsmId, Long positionId) {
        return new QFilter("position", "=", (Object)positionId).and(new QFilter("stdrsm", "=", (Object)stdRsmId)).and(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_IN));
    }

    public static Map<String, Long> queryCandidateIds(List<String> appFileNumbers) {
        HRBaseServiceHelper hcfHelper = new HRBaseServiceHelper("hcf_candidate");
        DynamicObject[] candidates = hcfHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("number", "in", appFileNumbers)});
        return Arrays.stream(candidates).collect(Collectors.toMap(dyo -> dyo.getString("number"), dyo -> dyo.getLong("id"), (aa, bb) -> aa));
    }

    public static void setLaborTypeAndHireTime(List<Long> empedAppFileIds, List<String> empedAppFileNumbers, Map<Long, DynamicObject> idDyMaps) {
        if (!empedAppFileIds.isEmpty()) {
            Map<String, Long> candidateMap = AppFileHelper.queryCandidateIds(empedAppFileNumbers);
            Map empDataMap = MiddleGroundPersonHelper.getEmployeeData(new ArrayList<Long>(candidateMap.values()));
            LOG.info("setLaborTypeAndHireTime.params:{},{}", candidateMap, (Object)empDataMap);
            for (Long empedAppFileId : empedAppFileIds) {
                DynamicObject appFile = idDyMaps.get(empedAppFileId);
                String number = appFile.getString("number");
                JSONObject jsonObject = (JSONObject)empDataMap.get(candidateMap.get(number));
                if (jsonObject == null) continue;
                appFile.set("emptime", (Object)jsonObject.getDate("startdate"));
                appFile.set("laborrelstatus", jsonObject.get((Object)"laborreltype"));
            }
        }
    }

    public static void setEndEmpTime(List<Long> endEmpAppFileIds, List<String> endEmpAppFileNumbers, Map<Long, DynamicObject> idDyMaps) {
        if (!endEmpAppFileIds.isEmpty()) {
            Map<String, Long> candidateMap = AppFileHelper.queryCandidateIds(endEmpAppFileNumbers);
            Map empDataMap = MiddleGroundPersonHelper.getEmployeeData(new ArrayList<Long>(candidateMap.values()));
            LOG.info("setEndEmpTime.params:{},{}", candidateMap, (Object)empDataMap);
            for (Long endEmpAppFileId : endEmpAppFileIds) {
                DynamicObject appFile = idDyMaps.get(endEmpAppFileId);
                String number = appFile.getString("number");
                JSONObject jsonObject = (JSONObject)empDataMap.get(candidateMap.get(number));
                if (jsonObject == null) continue;
                appFile.set("endemptime", (Object)jsonObject.getDate("enddate"));
            }
        }
    }

    public static void checkAppFilePermAndSetVisible(IFormView view, Set<String> hideCtrlKey) {
        int opSize = AppFileOperateEnum.values().length;
        HashMap hasChecked = Maps.newHashMapWithExpectedSize((int)opSize);
        HashSet notHasPermSet = Sets.newHashSetWithExpectedSize((int)opSize);
        HashSet hasPermSet = Sets.newHashSetWithExpectedSize((int)opSize);
        HashSet notHandleBtnSet = Sets.newHashSetWithExpectedSize((int)opSize);
        AppFileHelper.handleTransAndTalent(notHandleBtnSet, hasChecked, hideCtrlKey, view);
        AppFileHelper.handleMarkAndExamination(notHandleBtnSet, hasChecked, hideCtrlKey, view);
        for (AppFileOperateEnum appFileOperateEnum : AppFileOperateEnum.values()) {
            String ctrlKey = appFileOperateEnum.getCtrlKey();
            if (notHandleBtnSet.contains(ctrlKey) || hideCtrlKey.contains(ctrlKey)) continue;
            boolean hasPerm = AppFileHelper.hasPerm(appFileOperateEnum, hasChecked, view);
            if (hasPerm) {
                hasPermSet.add(appFileOperateEnum.getCtrlKey());
                continue;
            }
            notHasPermSet.add(appFileOperateEnum.getCtrlKey());
        }
        if (!hasPermSet.isEmpty()) {
            view.setVisible(Boolean.TRUE, hasPermSet.toArray(new String[0]));
        }
        if (!notHasPermSet.isEmpty()) {
            view.setVisible(Boolean.FALSE, notHasPermSet.toArray(new String[0]));
        }
    }

    private static void handleMarkAndExamination(Set<String> notHandleBtnSet, Map<String, Boolean> hasChecked, Set<String> hideCtrlKey, IFormView view) {
        boolean hasMarkPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.REGMARK.getCtrlKey())) {
            hasMarkPerm = AppFileHelper.hasPerm(AppFileOperateEnum.REGMARK, hasChecked, view);
        }
        boolean hasExaminationPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.EXAMINATION.getCtrlKey())) {
            hasExaminationPerm = AppFileHelper.hasPerm(AppFileOperateEnum.EXAMINATION, hasChecked, view);
        }
        if (hasMarkPerm && hasExaminationPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey(), AppFileOperateEnum.EXAMINATION.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        } else if (hasMarkPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.EXAMINATION.getCtrlKey(), AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        } else if (hasExaminationPerm) {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey(), AppFileOperateEnum.EXAMINATION.getCtrlKey()});
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.REGMARK.getCtrlKey(), AppFileOperateEnum.EXAMINATION.getCtrlKey(), AppFileOperateEnum.EXAMINATION_1.getCtrlKey()});
        }
        notHandleBtnSet.add(AppFileOperateEnum.REGMARK.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.EXAMINATION.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.EXAMINATION_1.getCtrlKey());
    }

    private static void handleTransAndTalent(Set<String> notHandleBtnSet, Map<String, Boolean> hasChecked, Set<String> hideCtrlKey, IFormView view) {
        boolean hasTransferPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.TRANSFERPOS.getCtrlKey())) {
            hasTransferPerm = AppFileHelper.hasPerm(AppFileOperateEnum.TRANSFERPOS, hasChecked, view);
        }
        boolean hasSaveTalentPerm = false;
        if (!hideCtrlKey.contains(AppFileOperateEnum.SAVETALENT.getCtrlKey())) {
            hasSaveTalentPerm = AppFileHelper.hasPerm(AppFileOperateEnum.SAVETALENT, hasChecked, view);
        }
        if (hasTransferPerm && hasSaveTalentPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), AppFileOperateEnum.SAVETALENT.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        } else if (hasTransferPerm) {
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey()});
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.SAVETALENT.getCtrlKey(), AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        } else if (hasSaveTalentPerm) {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), AppFileOperateEnum.SAVETALENT.getCtrlKey()});
            view.setVisible(Boolean.TRUE, new String[]{AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{AppFileOperateEnum.TRANSFERPOS.getCtrlKey(), AppFileOperateEnum.SAVETALENT.getCtrlKey(), AppFileOperateEnum.SAVETALENT_1.getCtrlKey()});
        }
        notHandleBtnSet.add(AppFileOperateEnum.TRANSFERPOS.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.SAVETALENT.getCtrlKey());
        notHandleBtnSet.add(AppFileOperateEnum.SAVETALENT_1.getCtrlKey());
    }

    private static boolean hasPerm(AppFileOperateEnum appFileOperateEnum, Map<String, Boolean> hasChecked, IFormView view) {
        Map opInfo;
        String permissionId;
        String entityId = view.getEntityId();
        if (view instanceof IListView) {
            entityId = ((IListView)view).getBillFormId();
        }
        if (HRStringUtils.isNotEmpty((String)(permissionId = (String)(opInfo = EntityMetadataCache.getDataEntityOperate((String)entityId, (String)appFileOperateEnum.getOpRightKey())).get("permission")))) {
            Boolean hasPerm = hasChecked.get(permissionId);
            if (hasPerm == null) {
                hasPerm = PermissionHelper.hasOpPerm((String)entityId, (String)permissionId, (Object)view.getModel().getDataEntity().getPkValue());
                hasChecked.put(permissionId, hasPerm);
            }
            return hasPerm;
        }
        return true;
    }

    public static boolean hasTobeEmployedAppFile(Long mainStdRsmId, Long subStdRsmId) {
        QFilter subQFilter;
        String queryProp = String.join((CharSequence)",", "id", "position.id");
        DynamicObject[] subAppFiles = AppFileHelper.queryAppFiles(queryProp, (subQFilter = AppFileHelper.getAppFileStatusQFilter(subStdRsmId, AppFileConstants.APP_FILE_STATUS_TBEMP)).toArray());
        if (subAppFiles != null && subAppFiles.length > 0) {
            HashSet positionIdSet = Sets.newHashSetWithExpectedSize((int)subAppFiles.length);
            for (DynamicObject dy : subAppFiles) {
                DynamicObject positionDy = dy.getDynamicObject("position");
                if (positionDy == null) continue;
                positionIdSet.add(positionDy.getLong("id"));
            }
            QFilter stdRsmQFilter = new QFilter("stdrsm", "=", (Object)mainStdRsmId);
            QFilter positionQFilter = new QFilter("position", "in", (Object)positionIdSet);
            DynamicObject[] mainAppFiles = AppFileHelper.queryAppFiles(queryProp, stdRsmQFilter.and(positionQFilter).toArray());
            return mainAppFiles != null && mainAppFiles.length > 0;
        }
        return false;
    }

    private static QFilter getAppFileStatusQFilter(Long stdRsmId, String appFileStatus) {
        QFilter stdRsmQFilter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        QFilter statusQFilter = new QFilter("filestatus", "=", (Object)appFileStatus);
        return stdRsmQFilter.and(statusQFilter);
    }

    public static boolean hasPerm(AppFileOperateEnum appFileOperateEnum, IFormView view) {
        if (view == null) {
            return true;
        }
        IFormView parentView = AppFileHelper.getParentViewByRecursion(view);
        boolean hasPerm = AppFileHelper.hasPerm(appFileOperateEnum, Maps.newHashMapWithExpectedSize((int)1), parentView);
        if (!hasPerm) {
            String operatePermName = appFileOperateEnum.getOpName().loadKDString();
            if (AppFileOperateEnum.FILTER == appFileOperateEnum) {
                operatePermName = ResManager.loadKDString((String)"\u7b5b\u9009", (String)"AppFileHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            }
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdvertPermHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), Objects.isNull(parentView.getFormShowParameter().getCaption()) ? parentView.getFormShowParameter().getFormConfig().getCaption().getDefaultItem() : parentView.getFormShowParameter().getCaption(), operatePermName));
        }
        return hasPerm;
    }

    public static DynamicObject[] getAppFileStatTrackRecord(Long appFileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_appfilestatreclist");
        QFilter qFilter = new QFilter("appfile", "=", (Object)appFileId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public static DynamicObject[] getAppFileTrackRecord(Long appFileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_appfiletrace");
        QFilter qFilter = new QFilter("appfile", "=", (Object)appFileId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public static boolean isCanDeliveryAppFile(DynamicObject appFile) {
        DynamicObject dynamicObject = AppFileHelper.queryOne(appFile.getLong("id"));
        Boolean checkDupSwitch = AppFileStdRsmHelper.getCheckDupSwitch();
        if (checkDupSwitch.booleanValue()) {
            if (AppFileHelper.isOut(dynamicObject)) {
                Date eliminatetime = dynamicObject.getDate("eliminatetime");
                int expDay = AppFileStdRsmHelper.getExpDay();
                Date date = HRDateTimeUtils.addDay((Date)eliminatetime, (long)(-expDay));
                return new Date().after(date);
            }
            return false;
        }
        return true;
    }

    private static IFormView getParentViewByRecursion(IFormView view) {
        for (int idx = 0; !(idx >= 11 || view instanceof ListView && ("tsirm_appfile_viewm".equals(((ListView)view).getBillFormId()) || "tsirm_appfile_viewc".equals(((ListView)view).getBillFormId()) || ((ListView)view).getBillFormId().startsWith("bos")) || view instanceof FormView && ("tsirm_argintvdetail".equals(((FormView)view).getFormId()) || "tsirm_appfile_viewm".equals(((FormView)view).getFormId()) || ((FormView)view).getFormId().startsWith("bos"))); ++idx) {
            view = view.getParentView();
        }
        return view;
    }

    public static boolean getAppfileOfStagAndStatIsRef(Long stageId, List<Long> statIds) {
        QFilter qFilter = new QFilter("recrustg", "=", (Object)stageId).and("recrustat", "in", statIds);
        DynamicObject query = APP_FILE_SERVICE_HELPER.queryOne("id", qFilter.toArray());
        QFilter qFilter2 = new QFilter("outrecrustg", "=", (Object)stageId).and("outrecrustat", "in", statIds);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_appfiletrace");
        DynamicObject query2 = hrBaseServiceHelper.queryOne("id", qFilter2);
        return !Objects.isNull(query) || !Objects.isNull(query2);
    }

    public static DynamicObject[] getAppFileByIds(List<Long> ids) {
        return APP_FILE_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static void changeAppFilePersonType(Map<Long, String> appFilePersonType) {
        DynamicObject[] results;
        ArrayList<Long> ids = new ArrayList<Long>(appFilePersonType.keySet());
        for (DynamicObject result : results = APP_FILE_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)})) {
            result.set("personchangetype", (Object)appFilePersonType.get(result.getLong("id")));
        }
        APP_FILE_SERVICE_HELPER.update(results);
    }

    public static void insertPersonChangeMessage(Map<DynamicObject, Date> changeMap) {
        List<DynamicObject> results = AppFileHelper.buildPersonChangeObject(changeMap);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_emprel");
        helper.save(results.toArray(new DynamicObject[0]));
    }

    private static List<DynamicObject> buildPersonChangeObject(Map<DynamicObject, Date> changeMap) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)changeMap.size());
        for (Map.Entry<DynamicObject, Date> entry : changeMap.entrySet()) {
            DynamicObject empChangeObj = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_emprel");
            DynamicObject stdRsm = entry.getKey().getDynamicObject("stdrsm");
            Long empID = stdRsm.getLong("empid");
            empChangeObj.set("stdrsm", (Object)stdRsm);
            empChangeObj.set("appfile", (Object)entry.getKey());
            empChangeObj.set("empid", (Object)empID);
            empChangeObj.set("changetype", (Object)"C");
            empChangeObj.set("poststate", (Object)1020L);
            empChangeObj.set("changedate", (Object)entry.getValue());
            empChangeObj.set("laborrelstatus", (Object)1020L);
            empChangeObj.set("labrelstatuscls", (Object)1020L);
            results.add(empChangeObj);
        }
        return results;
    }

    public static DynamicObject[] getAppFileByStdRsmAndDelivery(List<Long> stdRsmIdList) {
        QFilter stdRsmFilter = new QFilter("stdrsm", "in", stdRsmIdList);
        QFilter statusFilter = new QFilter("filestatus", "!=", (Object)AppFileStatusEnum.IN_PROCESS.getValue());
        return APP_FILE_SERVICE_HELPER.query("position,applytime,filestatus,stdrsm", new QFilter[]{stdRsmFilter, statusFilter});
    }

    public static DynamicObject[] getAppFileStatusRecByFileId(List<Long> appFileIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilestatusrectpl");
        QFilter appFileFilter = new QFilter("appfile", "in", appFileIds);
        return helper.query("operatetime,appfile,newfilestatus,oldfilestatus", new QFilter[]{appFileFilter});
    }

    public static Map<Long, Boolean> isAllowCancel(List<Long> empIds) {
        HRBaseServiceHelper stdHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfiletpl");
        DynamicObject[] stdRsms = stdHelper.query("id,empid", new QFilter("empid", "in", empIds).and("iscurrentversion", "=", (Object)"1").toArray());
        if (stdRsms.length != 0) {
            HashMap<Long, Long> empMap = new HashMap<Long, Long>(empIds.size());
            for (DynamicObject stdRsm : stdRsms) {
                empMap.put(stdRsm.getLong("empid"), stdRsm.getLong("id"));
            }
            List stdRsmIds = Arrays.stream(stdRsms).map(rsm -> rsm.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("stdrsm", "in", stdRsmIds);
            qFilter.and("filestatus", "in", (Object)ImmutableList.of((Object)AppFileConstants.APP_FILE_STATUS_IN, (Object)AppFileConstants.APP_FILE_STATUS_TBEMP, (Object)AppFileConstants.APP_FILE_STATUS_EMPED, (Object)AppFileConstants.APP_FILE_STATUS_ENDEMP));
            DynamicObject[] results = appFileHelper.query("id,stdrsm", qFilter.toArray());
            List disStdRsmIds = Arrays.stream(results).map(result -> result.getDynamicObject("stdrsm").getLong("id")).distinct().collect(Collectors.toList());
            HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(empIds.size());
            if (disStdRsmIds.isEmpty()) {
                for (Long empId : empIds) {
                    resultMap.put(empId, true);
                }
            } else {
                for (Long empId : empIds) {
                    resultMap.put(empId, !disStdRsmIds.contains(empMap.get(empId)));
                }
            }
            return resultMap;
        }
        return new HashMap<Long, Boolean>(1);
    }

    public static List<Long> getAppFilePid(List<Long> appFileIds) {
        HRBaseServiceHelper stdHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfiletpl");
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject[] appFiles = appFileHelper.query("stdrsm", new QFilter[]{new QFilter("id", "in", appFileIds)});
        List disStdRsmIds = Arrays.stream(appFiles).filter(files -> files.getDynamicObject("stdrsm") != null).map(files -> files.getDynamicObject("stdrsm").getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] stdRsms = stdHelper.query("empid", new QFilter[]{new QFilter("id", "in", disStdRsmIds)});
        List empids = Arrays.stream(stdRsms).filter(Objects::nonNull).map(files -> files.getLong("empid")).collect(Collectors.toList());
        DynamicObject[] emps = empHelper.query("person", new QFilter[]{new QFilter("id", "in", empids)});
        List personids = Arrays.stream(emps).filter(files -> files.getDynamicObject("person") != null).map(files -> files.getDynamicObject("person").getLong("id")).collect(Collectors.toList());
        DynamicObject[] persons = personHelper.query("personindexid", new QFilter[]{new QFilter("id", "in", personids)});
        return Arrays.stream(persons).filter(Objects::nonNull).map(files -> files.getLong("personindexid")).collect(Collectors.toList());
    }

    public static List<Long> getAppFileIdByPid(List<Long> pids) {
        HRBaseServiceHelper stdHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfiletpl");
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject[] persons = personHelper.query("id", new QFilter[]{new QFilter("personindexid", "in", pids)});
        List personIds = Arrays.stream(persons).map(per -> per.getLong("id")).collect(Collectors.toList());
        DynamicObject[] emps = empHelper.query("id", new QFilter[]{new QFilter("person.id", "in", personIds)});
        List empids = Arrays.stream(emps).map(emp -> emp.getLong("id")).collect(Collectors.toList());
        DynamicObject[] stdrsms = stdHelper.query("id", new QFilter[]{new QFilter("empid", "in", empids)});
        List stdrsmIds = Arrays.stream(stdrsms).map(std -> std.getLong("id")).collect(Collectors.toList());
        DynamicObject[] appfiles = appFileHelper.query("id", new QFilter[]{new QFilter("stdrsm.id", "in", stdrsmIds)});
        return Arrays.stream(appfiles).map(app -> app.getLong("id")).collect(Collectors.toList());
    }

    public static void cleanInterviewerQuestion(DynamicObject appFile) {
        if (null == appFile) {
            return;
        }
        if (!appFile.containsProperty("interviewerquestion_tag")) {
            return;
        }
        appFile.set("interviewerquestion_tag", (Object)" ");
        APP_FILE_SERVICE_HELPER.update(new DynamicObject[]{appFile});
    }

    public static void updateInterviewerQuestion(DynamicObject appFile, String aiQuestion) {
        if (null == appFile || HRStringUtils.isBlank((CharSequence)aiQuestion)) {
            return;
        }
        if (!appFile.containsProperty("interviewerquestion_tag")) {
            return;
        }
        String interviewerQuestionTag = appFile.getString("interviewerquestion_tag");
        if (HRStringUtils.isBlank((CharSequence)interviewerQuestionTag)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(aiQuestion);
            appFile.set("interviewerquestion_tag", (Object)SerializationUtils.toJsonString(list));
            APP_FILE_SERVICE_HELPER.update(new DynamicObject[]{appFile});
            return;
        }
        List list = (List)SerializationUtils.fromJsonString((String)interviewerQuestionTag, ArrayList.class);
        list.add(aiQuestion);
        appFile.set("interviewerquestion_tag", (Object)SerializationUtils.toJsonString((Object)list));
        APP_FILE_SERVICE_HELPER.update(new DynamicObject[]{appFile});
    }

    public static void updateAiHighLightAndConcern(DynamicObject appFile, String resumeHighLight, List<String> resumeHighLightLabelList, String resumeConcern, List<String> resumeConcernLabelList) {
        appFile.set("talenthighlight_tag", (Object)resumeHighLight);
        appFile.set("talentconcern_tag", (Object)resumeConcern);
        AppFileHelper.updateAppFileLabel(resumeConcernLabelList, appFile, "tsirm_talentconcern", "talentconcernlabel");
        AppFileHelper.updateAppFileLabel(resumeHighLightLabelList, appFile, "tsirm_talentlight", "talenthighlightlabel");
        APP_FILE_SERVICE_HELPER.update(new DynamicObject[]{appFile});
    }

    private static void updateAppFileLabel(List<String> labelList, DynamicObject appFile, String entityName, String labelName) {
        ArrayList concernList = new ArrayList(labelList.size());
        labelList.forEach(concernLabel -> {
            DynamicObject labelDy = AppFileHelper.isExistLabel(concernLabel, entityName);
            if (null == labelDy) {
                concernList.add(AppFileHelper.addLabel(concernLabel, entityName));
                return;
            }
            concernList.add(labelDy);
        });
        DynamicObjectCollection talentConcernLabelCollection = appFile.getDynamicObjectCollection(labelName);
        concernList.forEach(label -> {
            DynamicObject row = talentConcernLabelCollection.addNew();
            row.set("fbasedataid", label);
        });
    }

    private static DynamicObject isExistLabel(String label, String labelEntityName) {
        HRBaseServiceHelper labelService = new HRBaseServiceHelper(labelEntityName);
        return labelService.queryOne(new QFilter[]{new QFilter("name", "=", (Object)label)});
    }

    private static DynamicObject addLabel(String label, String labelEntityName) {
        HRBaseServiceHelper labelService = new HRBaseServiceHelper(labelEntityName);
        DynamicObject dynamicObject = labelService.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)ID.genLongId());
        dynamicObject.set("name", (Object)label);
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        labelService.save(new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }
}

