/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsrbs.common.utils.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileOpHelper {
    private AppFileOpHelper() {
    }

    public static void handleConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent, AbstractFormPlugin plugin) {
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            if ("lock".equals(messageBoxClosedEvent.getCallBackId())) {
                plugin.getView().invokeOperation("lock");
            } else if ("unlock".equals(messageBoxClosedEvent.getCallBackId())) {
                plugin.getView().invokeOperation("unlock");
            } else if ("archive".equals(messageBoxClosedEvent.getCallBackId())) {
                plugin.getView().invokeOperation("archive");
            }
        }
    }

    public static void showFormArrangeInterview(List<Long> appFileIds, AbstractFormPlugin plugin) {
        AppFileOpHelper.showFormArrangeInterview(appFileIds, plugin, null);
    }

    public static void showFormArrangeInterview(List<Long> appFileIds, AbstractFormPlugin plugin, String errorTip) {
        if (!appFileIds.isEmpty()) {
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId("tsirm_argintv");
            formShowParameter.setCustomParam("appFileId", appFileIds);
            Pair<Long, Long> positionAndStage = AppFileHelper.getPositionAndStageByAppFileId(appFileIds.get(0));
            formShowParameter.setCustomParam("position", positionAndStage.getLeft());
            formShowParameter.setCustomParam("recrustg", positionAndStage.getRight());
            IFormView parentView = plugin.getView();
            if (HRStringUtils.equals((String)parentView.getFormShowParameter().getFormId(), (String)"tsirm_intvcalendar")) {
                parentView = parentView.getParentView().getParentView();
            }
            formShowParameter.setCustomParam("pageId", (Object)parentView.getPageId());
            formShowParameter.setCustomParam("chanrgrange", (Object)plugin.getPageCache().get("chanrgrange"));
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5b89\u6392\u9762\u8bd5", (String)"ArrangeIntvOperate_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tsirm_argintv"));
            formShowParameter.setShowTitle(true);
            formShowParameter.setCustomParam("errorTip", (Object)errorTip);
            long interviewId = ObjectUtils.getLongValOfObject((Object)plugin.getView().getFormShowParameter().getCustomParam("interviewId"));
            if (interviewId != 0L) {
                formShowParameter.setCustomParam("interviewId", (Object)interviewId);
            }
            plugin.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public static String getErrorMulTipHead(List<DynamicObject> appFiles) {
        if (appFiles.size() > 3) {
            String tip = AppFileResManagerHelper.getErrorMulTipHeadLocalDesc();
            String one = AppFileOpHelper.getNoName(appFiles.get(0));
            String two = AppFileOpHelper.getNoName(appFiles.get(1));
            String three = AppFileOpHelper.getNoName(appFiles.get(2));
            return String.format(tip, one, two, three, appFiles.size());
        }
        return String.format(Locale.ROOT, "%s", appFiles.stream().map(AppFileOpHelper::getNoName).collect(Collectors.joining("\u3001")));
    }

    public static String getErrorMulTipHead(List<Pair<String, String>> numberNamePairList, boolean isShowNumber) {
        if (numberNamePairList.size() > 3) {
            String three;
            String two;
            String one;
            String tip = AppFileResManagerHelper.getErrorMulTipHeadLocalDesc();
            if (isShowNumber) {
                one = AppFileOpHelper.getNoName((String)numberNamePairList.get(0).getLeft(), (String)numberNamePairList.get(0).getRight());
                two = AppFileOpHelper.getNoName((String)numberNamePairList.get(1).getLeft(), (String)numberNamePairList.get(1).getRight());
                three = AppFileOpHelper.getNoName((String)numberNamePairList.get(2).getLeft(), (String)numberNamePairList.get(2).getRight());
            } else {
                one = (String)numberNamePairList.get(0).getRight();
                two = (String)numberNamePairList.get(1).getRight();
                three = (String)numberNamePairList.get(2).getRight();
            }
            return String.format(tip, one, two, three, numberNamePairList.size());
        }
        if (isShowNumber) {
            return String.format(Locale.ROOT, "%s", numberNamePairList.stream().map(pair -> AppFileOpHelper.getNoName((String)pair.getLeft(), (String)pair.getRight())).collect(Collectors.joining("\u3001")));
        }
        return String.format(Locale.ROOT, "%s", numberNamePairList.stream().map(Pair::getRight).collect(Collectors.joining("\u3001")));
    }

    public static String getNoName(DynamicObject appFile) {
        return AppFileOpHelper.getNoName(appFile.getString("number"), appFile.getString("name"));
    }

    public static String getNoName(String number, String name) {
        return String.format(Locale.ROOT, "\u201c%s: %s\u201d", number, name);
    }

    public static void showOperationResult(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateName = operate.getOperateName().getLocaleValue();
        OperationResult operationResult = args.getOperationResult();
        operationResult.setShowMessage(false);
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        if (errorInfos.size() + operationResult.getSuccessPkIds().size() > 1 && !operationResult.getSuccessPkIds().isEmpty()) {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("tsirm_appfileopresult");
            parameters.setShowTitle(false);
            parameters.setCustomParam("operateName", (Object)operateName);
            Map<Object, Object> pkNumbers = Maps.newHashMap();
            if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
                if (!operationResult.getBillNos().isEmpty()) {
                    pkNumbers.putAll(operationResult.getBillNos());
                } else {
                    pkNumbers = operationResult.getSuccessPkIds().stream().collect(Collectors.toMap(pkId -> pkId, oo -> oo));
                }
            }
            parameters.setCustomParam("pkNumbers", (Object)pkNumbers);
            parameters.setCustomParam("successPkIds", (Object)operationResult.getSuccessPkIds());
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
            parameters.setCustomParam("operationresult", (Object)serialResult);
            int successCount = operationResult.getSuccessPkIds().size();
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u53ef\u7ee7\u7eed\u8fdb\u884c%2$s%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"AppFileOpHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]), operationResult.getBillCount(), "", successCount, operationResult.getBillCount() - successCount);
            parameters.setCustomParam("title", (Object)title);
            ArrayList list = Lists.newArrayList();
            int len = errorInfos.size();
            for (int index = 0; index < 5 && index < len; ++index) {
                list.add(((IOperateInfo)errorInfos.get(index)).getMessage());
            }
            parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
            parameters.setCustomParam("errorMsg", (Object)list);
            parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, operate.getOperateKey() + "operateresult"));
            plugin.getView().showForm(parameters);
        } else {
            plugin.getView().showOperationResult(operationResult);
        }
    }

    public static ValidateResult validateAppFiles(List<Long> appFileIdList, String opName, boolean ignoreNumber) {
        ValidateResult validateResult = new ValidateResult();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("opname", opName);
        operateOption.setVariableValue("ignorenumber", String.valueOf(ignoreNumber));
        OperationResult operationResult = new OperationServiceImpl().localInvokeOperation("validateappfile", "tsirm_appfilemdl", appFileIdList.toArray(), operateOption);
        validateResult.setBillNos(operationResult.getBillNos());
        for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo()) {
            validateResult.addErrorInfo((OperateErrorInfo)iOperateInfo);
        }
        validateResult.setSuccessPkIds(operationResult.getSuccessPkIds());
        validateResult.setBillCount(operationResult.getBillCount());
        return validateResult;
    }

    public static String getOpName(OperateOption operateOption, AbstractValidator validator) {
        String opName;
        if (operateOption != null && HRStringUtils.isNotEmpty((String)(opName = operateOption.getVariableValue("opname", null)))) {
            return opName;
        }
        return validator.getOperationName();
    }

    public static List<String> validateKeys(Collection<String> inputKeys) {
        ArrayList noKeys = Lists.newArrayList();
        Set keys = EntityMetadataCache.getDataEntityType((String)"tsirm_appfilemdl").getAllFields().keySet();
        for (String key : inputKeys) {
            if (keys.contains(key)) continue;
            noKeys.add(key);
        }
        return noKeys;
    }

    public static void showFormSendMsg(List<Long> appFileIds, AbstractFormPlugin plugin) {
        if (!appFileIds.isEmpty()) {
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId("tsirm_messagepush");
            formShowParameter.setCustomParam("appFileIdList", appFileIds);
            formShowParameter.setCustomParam("chanrgrange", (Object)plugin.getPageCache().get("chanrgrange"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tsirm_messagepush"));
            plugin.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public static void showFormRegMark(Long appFileId, AbstractFormPlugin plugin) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tsirm_examwritten");
        baseShowParameter.setCustomParam("appFileId", (Object)appFileId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        plugin.getView().showForm((FormShowParameter)baseShowParameter);
    }
}

