/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFilePermissionHelper {
    private static final Log LOG = LogFactory.getLog(AppFilePermissionHelper.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tsirm_appfile_viewc");
    private static final String PRINT_SETTING = "printsetting";
    private static final String[] LIST_OP_KEYS = new String[]{"transferposright", "changestageright", "eliminateright", "recover", "lockright", "filter", "sendmsg", "regmark", "arrangeaninterview", "hireapproval", "archiveright", "unlockright", "printfile", "printsetting"};
    private static final String[] LIST_CALLBACK_KEYS = new String[]{"transferposright", "changestageright", "eliminate", "recover", "lock", "archive", "unlock"};

    public static boolean isMyHandOp(String operateKey) {
        List<String> opKeyList = Arrays.asList(LIST_OP_KEYS);
        return opKeyList.contains(operateKey);
    }

    public static boolean isCallBackMyHandOp(String operateKey) {
        List<String> opKeyList = Arrays.asList(LIST_CALLBACK_KEYS);
        return opKeyList.contains(operateKey);
    }

    public static boolean inMyHandPermission(ListSelectedRowCollection selectedRows) {
        if (selectedRows == null || selectedRows.size() < 1) {
            return true;
        }
        LOG.info("inMyHandPermission selectedRows: {}", (Object)selectedRows);
        List<Long> idList = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        return AppFilePermissionHelper.queryAppFileInMyHand(idList);
    }

    public static boolean inMyHandPermission(List<Long> idList) {
        if (idList == null || idList.size() == 0) {
            return true;
        }
        return AppFilePermissionHelper.queryAppFileInMyHand(idList);
    }

    private static boolean queryAppFileInMyHand(List<Long> idList) {
        long userId = TSCRequestContext.getUserId();
        String myHandFilterSql = String.format(Locale.ROOT, "select fid from t_tsirm_posprin where fbasedataid = %d", userId);
        QFilter filter = QFilter.sqlExpress((String)"position.manageinfo", (String)"in", (String)myHandFilterSql);
        filter.and(new QFilter("id", "in", idList));
        DynamicObject[] query = HELPER.query("id", new QFilter[]{filter});
        LOG.info("queryAppFileInMyHand query: {}", (Object)query);
        return query != null && query.length == idList.size();
    }

    public static boolean inMyHandPermission(ListSelectedRow selectedRow) {
        if (selectedRow != null) {
            ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
            selectedRows.add((Object)selectedRow);
            return AppFilePermissionHelper.inMyHandPermission(selectedRows);
        }
        return true;
    }

    public static boolean handleCloseCallBckPermission(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack, ListSelectedRowCollection selectedRows) {
        if (selectedRows != null && selectedRows.size() > 0) {
            List<Long> idList = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            return AppFilePermissionHelper.handleCloseCallBckPermission(plugin, closeCallBack, idList);
        }
        return true;
    }

    public static boolean handleCloseCallBckPermission(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack, List<Long> idList) {
        Object returnData;
        if (HRStringUtils.equals((String)"1", (String)plugin.getPageCache().get("chanrgrange")) && AppFilePermissionHelper.isCallBackMyHandOp(closeCallBack.getActionId()) && (returnData = closeCallBack.getReturnData()) != null && idList != null && idList.size() > 0 && !AppFilePermissionHelper.inMyHandPermission(idList)) {
            LOG.info("handleCloseCallBckPermission returnData:{}, idList: {}", returnData, idList);
            String msg = String.format(ResManager.loadKDString((String)"\u4ea4\u4ed8\u4eba\u6743\u9650\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u6cd5\u6267\u884c%s\u3002", (String)"AppFilePermissionHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), plugin.getPageCache().get(AppFileListConstants.KEY_OPERATE_NAME));
            plugin.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public static boolean handleConfirmCallBckPermission(AbstractFormPlugin plugin, MessageBoxClosedEvent messageBoxClosedEvent, ListSelectedRowCollection selectedRows) {
        if (selectedRows != null && selectedRows.size() > 0) {
            List<Long> idList = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            return AppFilePermissionHelper.handleConfirmCallBckPermission(plugin, messageBoxClosedEvent, idList);
        }
        return true;
    }

    public static boolean handleConfirmCallBckPermission(AbstractFormPlugin plugin, MessageBoxClosedEvent messageBoxClosedEvent, List<Long> idList) {
        if (HRStringUtils.equals((String)"1", (String)plugin.getPageCache().get("chanrgrange")) && AppFilePermissionHelper.isCallBackMyHandOp(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult() && idList != null && idList.size() > 0 && !AppFilePermissionHelper.inMyHandPermission(idList)) {
            String msg = String.format(ResManager.loadKDString((String)"\u4ea4\u4ed8\u4eba\u6743\u9650\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u6cd5\u6267\u884c%s\u3002", (String)"AppFilePermissionHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), plugin.getPageCache().get(AppFileListConstants.KEY_OPERATE_NAME));
            plugin.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public static boolean isInMyHandPage(AbstractFormPlugin plugin) {
        return HRStringUtils.equals((String)"1", (String)plugin.getPageCache().get("chanrgrange"));
    }
}

