/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class AppFileStatusHelper {
    private static final HRBaseServiceHelper RECORD_HELPER = new HRBaseServiceHelper("tsirm_appfilestatusrectpl");
    private static final Map<String, String> checkStatusMap = Maps.newHashMapWithExpectedSize((int)4);
    private static final Map<AppFileStatusEnum, Consumer<List<Long>>> ACTION_MAP;
    private static final Map<AppFileStatusEnum, String> changeOpNumberMap;

    private AppFileStatusHelper() {
    }

    public static void invalidAppFiles(DynamicObject[] appFiles) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject appFile : appFiles) {
            appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_INVALID);
            appFile.set("eliminatetime", (Object)nowTime);
            appFile.set("modifytime", (Object)nowTime);
            appFile.set("modifier", (Object)TSCRequestContext.getUserId());
        }
        AppFileHelper.update(appFiles);
        AppFileStatusHelper.addStatusRecordByInvalidOp(Arrays.stream(appFiles).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
    }

    public static void addStatusRecordByInvalidOp(List<Long> appFileIds) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), "5", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_INVALID);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void eliminateAppFile(DynamicObject[] appFiles, String type, Long reasonId, Map<String, String> detailedReason) {
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject dataEntity : appFiles) {
            dataEntity.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            dataEntity.set("eliminatetime", (Object)nowTime);
            dataEntity.set("modifytime", (Object)nowTime);
            dataEntity.set("modifier", (Object)TSCRequestContext.getUserId());
        }
        AppFileHelper.bindAppFileResume(appFiles);
        AppFileHelper.update(appFiles);
        List<Long> appFileIds = Arrays.stream(appFiles).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileStatusHelper.addStatusRecord(appFileIds, type, reasonId, detailedReason);
        AppFileFlowLockHelper.eliminateAppFiles(appFiles);
        List<Long> appFileIdList = Arrays.stream(appFiles).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_ELIMINATE, appFileIdList, null);
    }

    private static void addStatusRecord(List<Long> appFileIds, String type, Long reasonId, Map<String, String> detailedReason) {
        switch (type) {
            case "6": 
            case "2": 
            case "3": {
                AppFileStatusHelper.addStatusRecordByTransferEliminateOp(appFileIds, type);
                break;
            }
            case "1": {
                AppFileStatusHelper.addStatusRecordByEliminateOp(appFileIds, reasonId, detailedReason);
                break;
            }
        }
    }

    public static void addStatusRecordByTransferEliminateOp(List<Long> appFileIds, String type) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), type, HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            if ("3".equals(type)) {
                recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            } else {
                recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            }
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void addStatusRecordByRecoverOp(List<Long> appFileIds) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), "4", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            recordDy.set("detailedreason", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u6062\u590d", (String)"AppFileStatusHelper_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]));
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void addStatusRecordByEliminateOp(List<Long> appFileIds, Long reasonId, Map<String, String> detailedReason) {
        DynamicObject[] records = new DynamicObject[appFileIds.size()];
        int index = 0;
        for (Long appFileId : appFileIds) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileId, TSCRequestContext.getUserId(), "1", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", (Object)reasonId);
            recordDy.set("detailedreason", detailedReason);
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_OUT);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static DynamicObject generateStatusRecord(Long appFileId, Long operatorId, String operateType, Date operateTime) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilestatusrectpl");
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        dynamicObject.set("appFile", (Object)appFileId);
        dynamicObject.set("operator", (Object)operatorId);
        dynamicObject.set("operatetype", (Object)operateType);
        dynamicObject.set("operatetime", (Object)operateTime);
        dynamicObject.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        dynamicObject.set("creator", (Object)TSCRequestContext.getUserId());
        return dynamicObject;
    }

    public static void revertInProcess(List<DynamicObject> appFiles) {
        DynamicObject[] records = new DynamicObject[appFiles.size()];
        int index = 0;
        for (DynamicObject appFile : appFiles) {
            appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "10", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("oldfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_TBEMP);
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    public static void setInductionStatus(List<Long> appFileIdList, Map<Long, DynamicObject> idDyMaps, List<Object> inductionStatusList) {
        ArrayList locksAppFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList unLockAppFiles = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList empedAppFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList empedAppFileNumbers = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList endEmpAppFileIds = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList endEmpAppFileNumbers = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        ArrayList statusRecordList = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        for (int i = 0; i < appFileIdList.size(); ++i) {
            DynamicObject appFile = idDyMaps.get(appFileIdList.get(i));
            if (inductionStatusList.get(i) == null) continue;
            String inductionStatusStr = inductionStatusList.get(i).toString();
            String oldFileStatus = appFile.getString("filestatus");
            if ("1".equals(inductionStatusStr) && AppFileHelper.isInProcess(appFile)) {
                AppFileStatusHelper.setTBEmpData(locksAppFileIds, statusRecordList, appFile, oldFileStatus);
                continue;
            }
            if ("2".equals(inductionStatusStr) && AppFileHelper.isToBeEmployed(appFile)) {
                AppFileStatusHelper.setEmpedData(unLockAppFiles, empedAppFileIds, empedAppFileNumbers, statusRecordList, appFile, oldFileStatus);
                continue;
            }
            if (!"3".equals(inductionStatusStr) || !AppFileHelper.isToBeEmployed(appFile)) continue;
            AppFileStatusHelper.setEndEmpData(unLockAppFiles, endEmpAppFileIds, endEmpAppFileNumbers, statusRecordList, appFile, oldFileStatus);
        }
        RECORD_HELPER.save(statusRecordList.toArray(new DynamicObject[0]));
        AppFileFlowLockHelper.lockAppFiles(locksAppFileIds, TSCRequestContext.getUserId());
        AppFileFlowLockHelper.unLockEmpedAppFiles(unLockAppFiles);
        AppFileHelper.setLaborTypeAndHireTime(empedAppFileIds, empedAppFileNumbers, idDyMaps);
        AppFileHelper.setEndEmpTime(endEmpAppFileIds, endEmpAppFileNumbers, idDyMaps);
    }

    public static void archive(DynamicObject[] dataEntitys) {
        AppFileStatusHelper.addStatusRecordByArchiveOp(dataEntitys);
        for (DynamicObject dataEntity : dataEntitys) {
            dataEntity.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_INVALID);
        }
        AppFileHelper.update(dataEntitys);
        AppFileFlowLockHelper.archiveAppFiles(dataEntitys);
    }

    public static void addStatusRecordByArchiveOp(DynamicObject[] appFileDys) {
        DynamicObject[] records = new DynamicObject[appFileDys.length];
        int index = 0;
        for (DynamicObject appFileDy : appFileDys) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileDy.getLong("id"), TSCRequestContext.getUserId(), "11", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            recordDy.set("oldfilestatus", (Object)appFileDy.getString("filestatus"));
            recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_INVALID);
            records[index] = recordDy;
            ++index;
        }
        RECORD_HELPER.save(records);
    }

    private static void setEndEmpData(List<DynamicObject> unLockAppFiles, List<Long> endEmpAppFileIds, List<String> endEmpAppFileNumbers, List<DynamicObject> statusRecordList, DynamicObject appFile, String oldFileStatus) {
        appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_ENDEMP);
        unLockAppFiles.add(appFile);
        DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "9", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        recordDy.set("oldfilestatus", (Object)oldFileStatus);
        recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_ENDEMP);
        statusRecordList.add(recordDy);
        endEmpAppFileIds.add(appFile.getLong("id"));
        endEmpAppFileNumbers.add(appFile.getString("number"));
    }

    private static void setEmpedData(List<DynamicObject> unLockAppFiles, List<Long> empedAppFileIds, List<String> empedAppFileNumbers, List<DynamicObject> statusRecordList, DynamicObject appFile, String oldFileStatus) {
        appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_EMPED);
        unLockAppFiles.add(appFile);
        empedAppFileIds.add(appFile.getLong("id"));
        empedAppFileNumbers.add(appFile.getString("number"));
        DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "8", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        recordDy.set("oldfilestatus", (Object)oldFileStatus);
        recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_EMPED);
        statusRecordList.add(recordDy);
    }

    private static void setTBEmpData(List<Long> locksAppFileIds, List<DynamicObject> statusRecordList, DynamicObject appFile, String oldFileStatus) {
        appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_TBEMP);
        locksAppFileIds.add(appFile.getLong("id"));
        DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFile.getLong("id"), TSCRequestContext.getUserId(), "7", HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        recordDy.set("oldfilestatus", (Object)oldFileStatus);
        recordDy.set("newfilestatus", (Object)AppFileConstants.APP_FILE_STATUS_TBEMP);
        statusRecordList.add(recordDy);
    }

    public static void changeAppFileStatusByEmp(List<Map<Long, AppFileStatusEnum>> changeList) {
        Map<AppFileStatusEnum, List<Long>> changeMap = AppFileStatusHelper.convert(changeList);
        for (Map.Entry<AppFileStatusEnum, List<Long>> entry : changeMap.entrySet()) {
            List<Long> appFileIds = entry.getValue();
            if (appFileIds == null || appFileIds.isEmpty()) continue;
            ACTION_MAP.getOrDefault(entry.getKey(), ids -> {}).accept(appFileIds);
        }
    }

    public static void changeAppFileStatusByID(List<Map<String, Object>> changeList) {
        ArrayList<Map<Long, AppFileStatusEnum>> commonList = new ArrayList<Map<Long, AppFileStatusEnum>>();
        ArrayList<Map<String, Object>> changedList = new ArrayList<Map<String, Object>>();
        changeList.forEach(map -> {
            Object fileStatusObj = map.get("filestatus");
            if (fileStatusObj != null) {
                AppFileStatusEnum fileStatus = (AppFileStatusEnum)fileStatusObj;
                Long id = Long.valueOf(map.get("id").toString());
                if (AppFileStatusEnum.INVALID != fileStatus) {
                    commonList.add(Collections.singletonMap(id, fileStatus));
                } else {
                    changedList.add((Map<String, Object>)map);
                }
            }
        });
        if (!commonList.isEmpty()) {
            AppFileStatusHelper.changeAppFileStatusByEmp(commonList);
        }
        if (!changedList.isEmpty()) {
            AppFileStatusHelper.executeStatusFlow(changedList);
        }
    }

    private static Map<AppFileStatusEnum, List<Long>> convert(List<Map<Long, AppFileStatusEnum>> list) {
        HashMap<AppFileStatusEnum, List<Long>> resultMap = new HashMap<AppFileStatusEnum, List<Long>>(16);
        for (Map<Long, AppFileStatusEnum> map : list) {
            for (Map.Entry<Long, AppFileStatusEnum> entry : map.entrySet()) {
                AppFileStatusEnum statusEnum = entry.getValue();
                Long fileId = entry.getKey();
                List fileList = resultMap.computeIfAbsent(statusEnum, key -> new ArrayList());
                fileList.add(fileId);
            }
        }
        return resultMap;
    }

    private static void executeStatusFlow(List<Map<String, Object>> changeList) {
        List<Long> appFileIds = changeList.stream().map(map -> Long.valueOf(map.get("id").toString())).collect(Collectors.toList());
        DynamicObject[] appFiles = AppFileHelper.getAppFileByIds(appFileIds);
        List<DynamicObject> successAppFiles = Arrays.stream(appFiles).collect(Collectors.toList());
        AppFileStatusHelper.addStatusRecordByChangeOp(successAppFiles, AppFileStatusEnum.INVALID);
        for (DynamicObject successAppFile : successAppFiles) {
            successAppFile.set("filestatus", (Object)AppFileStatusEnum.INVALID.getValue());
        }
        AppFileHelper.update(successAppFiles.toArray(new DynamicObject[0]));
        AppFileFlowLockHelper.archiveAppFiles(successAppFiles.toArray(new DynamicObject[0]));
        AppFileHelper.insertPersonChangeMessage(AppFileStatusHelper.convertParam(changeList, successAppFiles));
    }

    private static Map<DynamicObject, Date> convertParam(List<Map<String, Object>> changeList, List<DynamicObject> successAppFiles) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)successAppFiles.size());
        block0: for (Map<String, Object> map : changeList) {
            long id = Long.parseLong(map.get("id").toString());
            Object changedate = map.get("changedate");
            if (changedate == null) continue;
            Date changeDate = (Date)changedate;
            for (DynamicObject appFile : successAppFiles) {
                if (appFile.getLong("id") != id) continue;
                result.put(appFile, changeDate);
                continue block0;
            }
        }
        return result;
    }

    private static void executeStatusFlow(List<Long> appFileIds, AppFileStatusEnum statusEnum) {
        String checkStatus = checkStatusMap.get(statusEnum.getValue());
        DynamicObject[] appFiles = AppFileHelper.getAppFileByIds(appFileIds);
        List<DynamicObject> successAppFiles = Arrays.stream(appFiles).collect(Collectors.toList());
        AppFileStatusHelper.addStatusRecordByChangeOp(successAppFiles, statusEnum);
        for (DynamicObject successAppFile : successAppFiles) {
            successAppFile.set("filestatus", (Object)statusEnum.getValue());
        }
        AppFileHelper.update(successAppFiles.toArray(new DynamicObject[0]));
    }

    private static void addStatusRecordByChangeOp(List<DynamicObject> appFiles, AppFileStatusEnum statusEnum) {
        ArrayList records = Lists.newArrayListWithExpectedSize((int)appFiles.size());
        for (DynamicObject appFileDy : appFiles) {
            DynamicObject recordDy = AppFileStatusHelper.generateStatusRecord(appFileDy.getLong("id"), TSCRequestContext.getUserId(), changeOpNumberMap.get(statusEnum), HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            recordDy.set("reason", null);
            recordDy.set("oldfilestatus", (Object)appFileDy.getString("filestatus"));
            recordDy.set("newfilestatus", (Object)statusEnum.getValue());
            records.add(recordDy);
        }
        RECORD_HELPER.save(records.toArray(new DynamicObject[0]));
    }

    public static void expireAppFilesByStdRsmId(List<Long> rsmIdList) {
        QFilter qFilter = new QFilter("stdrsm", "in", rsmIdList);
        qFilter.and("filestatus", "in", (Object)ImmutableList.of((Object)AppFileConstants.APP_FILE_STATUS_IN, (Object)AppFileConstants.APP_FILE_STATUS_TBEMP, (Object)AppFileConstants.APP_FILE_STATUS_EMPED, (Object)AppFileConstants.APP_FILE_STATUS_ENDEMP));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfiletpl");
        DynamicObject[] appFiles = helper.loadDynamicObjectArray(qFilter.toArray());
        AppFileStatusHelper.addStatusRecordByChangeOp(Arrays.asList(appFiles), AppFileStatusEnum.EXPIRED);
        for (DynamicObject appFile : appFiles) {
            appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_EXPIRED);
        }
        helper.update(appFiles);
        AppFileFlowLockHelper.archiveAppFiles(appFiles);
    }

    static {
        checkStatusMap.put(AppFileStatusEnum.TBEMP.getValue(), AppFileStatusEnum.IN_PROCESS.getValue());
        checkStatusMap.put(AppFileStatusEnum.EMPED.getValue(), AppFileStatusEnum.TBEMP.getValue());
        checkStatusMap.put(AppFileStatusEnum.ENDEMP.getValue(), AppFileStatusEnum.EMPED.getValue());
        checkStatusMap.put(AppFileStatusEnum.INVALID.getValue(), AppFileStatusEnum.EMPED.getValue());
        ACTION_MAP = new EnumMap<AppFileStatusEnum, Consumer<List<Long>>>(AppFileStatusEnum.class);
        ACTION_MAP.put(AppFileStatusEnum.TBEMP, ids -> AppFileStatusHelper.executeStatusFlow(ids, AppFileStatusEnum.TBEMP));
        ACTION_MAP.put(AppFileStatusEnum.EMPED, ids -> AppFileStatusHelper.executeStatusFlow(ids, AppFileStatusEnum.EMPED));
        ACTION_MAP.put(AppFileStatusEnum.ENDEMP, ids -> AppFileStatusHelper.executeStatusFlow(ids, AppFileStatusEnum.ENDEMP));
        ACTION_MAP.put(AppFileStatusEnum.INVALID, ids -> AppFileStatusHelper.executeStatusFlow(ids, AppFileStatusEnum.INVALID));
        ACTION_MAP.put(AppFileStatusEnum.IN_PROCESS, ids -> AppFileStatusHelper.executeStatusFlow(ids, AppFileStatusEnum.IN_PROCESS));
        changeOpNumberMap = Maps.newHashMapWithExpectedSize((int)6);
        changeOpNumberMap.put(AppFileStatusEnum.TBEMP, "12");
        changeOpNumberMap.put(AppFileStatusEnum.IN_PROCESS, "17");
        changeOpNumberMap.put(AppFileStatusEnum.EXPIRED, "18");
    }
}

