/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.form;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.exam.service.ExamDomainService;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalDomainService;
import kd.tsc.tsirm.common.constants.appfile.AppFileTabEnum;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;

public class AppFileTabHelper {
    private static final Log LOG = LogFactory.getLog(AppFileTabHelper.class);
    private static final String SUB_VIEW_STATUS = "subViewStatus";

    public static void showAppResPage(String targetKey, String cacheKey, AbstractFormPlugin plugin, DynamicObject appRes, OperationStatus subViewStatus) {
        BaseShowParameter appResShowParameter = new BaseShowParameter();
        appResShowParameter.setPkId(appRes.getPkValue());
        appResShowParameter.setFormId("tsirm_srrsm_layout");
        appResShowParameter.setStatus(subViewStatus);
        appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        appResShowParameter.setSendToClient(true);
        appResShowParameter.getOpenStyle().setTargetKey(targetKey);
        appResShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tsirm_srrsm"));
        plugin.getView().showForm((FormShowParameter)appResShowParameter);
        plugin.getPageCache().put(cacheKey, appResShowParameter.getPageId());
    }

    public static void showExamWrittenTab(Long appFileId, String targetKey, IFormView view, OperationStatus subViewStatus) {
        if (ExamDomainService.existWrittenDataByAppFileId(appFileId)) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("tsirm_examwritten");
            AppFileTabHelper.openTabForm(appFileId, targetKey, view, subViewStatus, listShowParameter);
            String pageId = listShowParameter.getPageId();
            view.getPageCache().put("tsirm_examwritten-pageId", pageId);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{targetKey});
        }
    }

    public static void showExaminationTab(Long appFileId, String targetKey, IFormView view, OperationStatus subViewStatus) {
        if (ExamDomainService.existExaminationDataByAppFileId(appFileId)) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("tsirm_examination");
            AppFileTabHelper.openTabForm(appFileId, targetKey, view, subViewStatus, listShowParameter);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{targetKey});
        }
    }

    public static void openTabForm(Long appFileId, String targetKey, IFormView view, OperationStatus subViewStatus, ListShowParameter listShowParameter) {
        listShowParameter.setFormId("tsirm_otherappfilelist");
        listShowParameter.setCustomParam("appFileId", (Object)appFileId);
        listShowParameter.setStatus(subViewStatus);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setSendToClient(true);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        view.showForm((FormShowParameter)listShowParameter);
        view.setVisible(Boolean.TRUE, new String[]{targetKey});
    }

    public static void initAssessTab(String tabKey, String intvTargetKey, String filterTargetKey, Long appFileId, IFormView view, OperationStatus subViewStatus) {
        Boolean isShowAssessTab = AppFileTabHelper.hasIntvData(appFileId) || AppFileTabHelper.hasFilterData(appFileId);
        view.setVisible(isShowAssessTab, new String[]{tabKey});
        if (isShowAssessTab.booleanValue()) {
            AppFileTabHelper.initInterviewAssess(intvTargetKey, appFileId, view, subViewStatus);
            AppFileTabHelper.initFilterFeedback(filterTargetKey, appFileId, view, subViewStatus);
        }
    }

    public static void initInterviewAssess(String targetKey, long appFileId, IFormView view, OperationStatus subViewStatus) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_assessment");
        showParameter.setCustomParam("applicationid", (Object)String.valueOf(appFileId));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam(SUB_VIEW_STATUS, (Object)subViewStatus.getValue());
        showParameter.setCustomParam("pageId", (Object)view.getPageId());
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
    }

    public static void initFilterFeedback(String targetKey, long appFileId, IFormView view, OperationStatus subViewStatus) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_rsmflfeedbacklistir");
        showParameter.setCustomParam("appFileId", (Object)appFileId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(subViewStatus);
        showParameter.setCustomParam(SUB_VIEW_STATUS, (Object)subViewStatus.getValue());
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
    }

    public static void initHireTab(String targetKey, DynamicObject dataEntity, IFormView view, OperationStatus subViewStatus) {
        Long appFileId = dataEntity.getLong("id");
        Boolean existFlag = HireApprovalDomainService.existHireBill(appFileId);
        if (existFlag.booleanValue()) {
            view.setVisible(Boolean.TRUE, new String[]{targetKey});
            HashMap params = Maps.newHashMapWithExpectedSize((int)1);
            params.put("appFileId", appFileId);
            ListShowParameter jobRankForm = FormShowHelper.createListFormShowParameter((String)"tsirm_otherappfilelist", (String)targetKey, (String)"tsirm_hireapprovalsgcard", (ShowType)ShowType.InContainer, (Map)params);
            view.showForm((FormShowParameter)jobRankForm);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{targetKey});
        }
    }

    public static void initOtherTab(String targetKey, DynamicObject dataEntity, IFormView view) {
        Long stdRsmMid = dataEntity.getLong("stdrsm.mid");
        Long id = dataEntity.getLong("id");
        LOG.debug("initOtherTab.id:", (Object)id);
        int otherAppCount = AppFileDataHelper.queryOtherAppCount(stdRsmMid, id);
        if (otherAppCount == 0) {
            view.setVisible(Boolean.FALSE, new String[]{targetKey});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{targetKey});
        String otherCount = otherAppCount >= 100 ? "99+" : String.valueOf(otherAppCount);
        ((TabPage)view.getControl(targetKey)).setText(new LocaleString(String.format(Locale.ROOT, AppFileResManagerHelper.getOtherAppFileDesc(), otherCount)));
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.setFormId("tsirm_otherappfilelist");
        listShowParameter.setBillFormId("tsirm_appfile_otherlist");
        listShowParameter.setSendToClient(true);
        listShowParameter.setCustomParam("stdrsm.mid", (Object)stdRsmMid);
        listShowParameter.setCustomParam("id", (Object)id);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void initOpRecordTab(String targetKey, DynamicObject dataEntity, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("bizobj", (Object)dataEntity.getString("id"));
        parameter.setCustomParam("entitytype", (Object)"tsirm_appfilemdl");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setFormId("tsrbs_oprecord_list");
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.setSendToClient(true);
        view.showForm(parameter);
    }

    private static boolean hasIntvData(Long appFileId) {
        HRBaseServiceHelper intvHelper = new HRBaseServiceHelper("tsirm_argintv");
        return intvHelper.isExists(new QFilter("intvcandate.fbasedataid", "=", (Object)appFileId));
    }

    private static boolean hasFilterData(Long appFileId) {
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tsirm_resumefilter");
        return filterHelper.isExists(new QFilter("appfile", "=", (Object)appFileId));
    }

    public static void activeTab(IFormView view, AppFileTabEnum tabEnum) {
        Tab tabAp = (Tab)view.getControl("tabap");
        tabAp.activeTab(tabEnum.getTabKey());
    }
}

