/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.list;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.list.DicConvertHelper;
import kd.tsc.tsirm.business.domain.appfile.list.entity.AppFileListDetailViewVO;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.CandidateSortHelper;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AppFileListViewDetailHelper {
    private static final int YEAR_MONTH = 12;

    private AppFileListViewDetailHelper() {
    }

    public static AppFileListDetailViewVO getAppFileListDetailViewVOByAppRsmId(Long appRsmId) {
        if (appRsmId == null || appRsmId == 0L) {
            return null;
        }
        AppFileListDetailViewVO appFileListDetailViewVO = new AppFileListDetailViewVO(true);
        HRBaseServiceHelper dbServiceRsm = new HRBaseServiceHelper("tsirm_srrsm");
        String queryColumn = "photo ,gender ,age ,workingyears ,highesteduschool.name ,highestspecialty ,highesteducation.name ,workstartdate ,workendingdate ,workcreatetime ,positionname ,companyname,lengthofwork,photo";
        DynamicObject resumeDyn = dbServiceRsm.queryOne(queryColumn, (Object)appRsmId);
        if (resumeDyn == null) {
            return appFileListDetailViewVO;
        }
        appFileListDetailViewVO.setHeadAddress(resumeDyn.getString("photo"));
        appFileListDetailViewVO.setSex(DicConvertHelper.getResumeGender().get(resumeDyn.getString("gender")));
        if (resumeDyn.getInt("age") > 0) {
            String age = ResManager.loadKDString((String)"%s\u5c81", (String)"AppFileListViewDetailHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            appFileListDetailViewVO.setAge(String.format(Locale.ROOT, age, resumeDyn.getInt("age")));
        }
        if (resumeDyn.getInt("workingyears") > 0) {
            String workExp = ResManager.loadKDString((String)"%s\u5de5\u4f5c\u7ecf\u9a8c", (String)"AppFileListViewDetailHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            appFileListDetailViewVO.setWorkYears(String.format(Locale.ROOT, workExp, ResumeAnalysisHelper.getWorkYearShow(resumeDyn.getInt("workingyears"))));
        }
        appFileListDetailViewVO.setSchool(resumeDyn.getString("highesteduschool.name"));
        appFileListDetailViewVO.setMajor(resumeDyn.getString("highestspecialty"));
        appFileListDetailViewVO.setDegree(resumeDyn.getString("highesteducation.name"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_srrsmposorgrel");
        DynamicObject[] posOrgRels = helper.query(TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"position", "company", "startdate", "endingdate", "createtime"}), new QFilter[]{new QFilter("rsm", "=", resumeDyn.getPkValue())});
        AppFileListViewDetailHelper.setPosOrgRel(appFileListDetailViewVO, posOrgRels);
        return appFileListDetailViewVO;
    }

    public static void setPosOrgRel(AppFileListDetailViewVO appFileListDetailViewVO, DynamicObject[] posOrgRels) {
        String duration;
        Date endDate;
        Date startDate;
        DynamicObject company;
        DynamicObject position;
        if (appFileListDetailViewVO == null) {
            return;
        }
        DynamicObject latestPosOrgRelFirst = null;
        DynamicObject latestPosOrgRelSecond = null;
        if (ObjectUtils.isNotEmpty((Object)posOrgRels)) {
            List objects = CandidateSortHelper.sortExperience((DynamicObject[])posOrgRels, (String)"startdate", (String)"endingdate", (String)"createtime");
            if (objects.size() > 0) {
                latestPosOrgRelFirst = (DynamicObject)objects.get(0);
            }
            if (objects.size() > 1) {
                latestPosOrgRelSecond = (DynamicObject)objects.get(1);
            }
        }
        if (latestPosOrgRelFirst != null) {
            position = latestPosOrgRelFirst.getDynamicObject("position");
            company = latestPosOrgRelFirst.getDynamicObject("company");
            appFileListDetailViewVO.setPositionFirst(Optional.ofNullable(position).map(p -> p.getString("name")).orElse(""));
            appFileListDetailViewVO.setCompanyNameFirst(Optional.ofNullable(company).map(c -> c.getString("name")).orElse(""));
            startDate = latestPosOrgRelFirst.getDate("startdate");
            endDate = latestPosOrgRelFirst.getDate("endingdate");
            appFileListDetailViewVO.setWorkTimeFirst(AppFileListViewDetailHelper.formatBetweenTwoDate(startDate, endDate));
            if (ResumeAnalysisHelper.isEndingDateUpToNow(endDate)) {
                endDate = new Date();
            }
            endDate = endDate.getTime() >= System.currentTimeMillis() ? new Date() : endDate;
            duration = ResumeAnalysisHelper.getWorkYearShow(ResumeAnalysisHelper.calMonthByStartDate(startDate, endDate));
            duration = HRStringUtils.isEmpty((String)duration) ? "" : "(" + duration + ")";
            appFileListDetailViewVO.setWorkTimeCountFirst(duration);
        }
        if (latestPosOrgRelSecond != null) {
            position = latestPosOrgRelSecond.getDynamicObject("position");
            company = latestPosOrgRelSecond.getDynamicObject("company");
            appFileListDetailViewVO.setPositionSecond(Optional.ofNullable(position).map(p -> p.getString("name")).orElse(""));
            appFileListDetailViewVO.setCompanyNameSecond(Optional.ofNullable(company).map(c -> c.getString("name")).orElse(""));
            startDate = latestPosOrgRelSecond.getDate("startdate");
            endDate = latestPosOrgRelSecond.getDate("endingdate");
            appFileListDetailViewVO.setWorkTimeSecond(AppFileListViewDetailHelper.formatBetweenTwoDate(startDate, endDate));
            if (ResumeAnalysisHelper.isEndingDateUpToNow(endDate)) {
                endDate = new Date();
            }
            endDate = endDate.getTime() >= System.currentTimeMillis() ? new Date() : endDate;
            duration = ResumeAnalysisHelper.getWorkYearShow(ResumeAnalysisHelper.calMonthByStartDate(startDate, endDate));
            duration = StringUtils.isBlank((CharSequence)duration) ? "" : "(" + duration + ")";
            appFileListDetailViewVO.setWorkTimeCountSecond(duration);
        }
    }

    public static String formatBetweenTwoDate(Date startDate, Date endDate) {
        String startYear = "";
        String endYear = "";
        if (startDate != null) {
            startYear = HRInteDateTimeUtil.formatDate((String)"tsirm_rsmposorgrel", (String)"startdate", (Date)startDate);
        }
        if (endDate != null) {
            endYear = ResumeAnalysisHelper.isEndingDateUpToNow(endDate) ? ResManager.loadKDString((String)"\u81f3\u4eca", (String)"AppFileListViewDetailHelper_4", (String)"tsc-tsirm-business", (Object[])new Object[0]) : HRInteDateTimeUtil.formatDate((String)"tsirm_rsmposorgrel", (String)"endingdate", (Date)endDate);
        }
        return String.format("%s~%s", startYear, endYear);
    }
}

