/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.operation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;

public class AddAppFileOperate
implements AppFileOperate {
    private static final Set<String> ADD_OP_SETS = Sets.newHashSet((Object[])new String[]{"openfillresadd", "analysisresadd", "importtpladd", "viewimtresult", "inviteupdate"});

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        return ADD_OP_SETS.contains(operateKey);
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (args.getOperateKey()) {
                case "openfillresadd": {
                    AppFileHelper.showFillAddCandidatePage(plugin.getView());
                    break;
                }
                case "analysisresadd": {
                    plugin.getView().showForm(FormShowHelper.createFormShowParameter((String)"tsirm_addcandidate", null, (ShowType)ShowType.MainNewTabPage, null));
                    break;
                }
                case "importtpladd": {
                    this.importSysTpl(plugin);
                    break;
                }
                case "viewimtresult": {
                    break;
                }
                case "inviteupdate": {
                    this.inviteUpdateRsm(plugin);
                    break;
                }
            }
        }
    }

    private void inviteUpdateRsm(AbstractFormPlugin plugin) {
        DynamicObject appFileObject = plugin.getView().getModel().getDataEntity();
        this.handleAppFileInviteUpdate(appFileObject.getLong("appres.id"), plugin);
    }

    private void importSysTpl(AbstractFormPlugin plugin) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)5);
        params.put("ServiceAppId", "tsrbs");
        params.put("CheckRightAppId", null);
        params.put("BillFormId", "tsirm_appfile_view");
        params.put("ListName", ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5217\u8868", (String)"AddAppFileOperate_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        params.put("ImportPlugin", "kd.tsc.tsrbs.formplugin.web.resume.ImportResumePlugin");
        plugin.getView().showForm(FormShowHelper.createFormShowParameter((String)"tsrbs_importstart", null, (ShowType)ShowType.Modal, (Map)params));
    }

    private void handleAppFileInviteUpdate(long rsmId, AbstractFormPlugin plugin) {
        FormShowParameter showParameter = FormShowHelper.createFormShowParameter((String)"tsirm_srrsminviteupdate", null, (ShowType)ShowType.MainNewTabPage, null);
        showParameter.setCustomParam("objId", (Object)rsmId);
        plugin.getView().showForm(showParameter);
    }
}

