/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.operation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFilePermissionHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileFlowLockOperate
implements AppFileOperate {
    private static final String BAR_LOCK = "barlock";
    private static final String BAR_UNLOCK = "barunlock";

    @Override
    public boolean supportBeforeItemClick(BeforeItemClickEvent evt) {
        return BAR_LOCK.equals(evt.getItemKey()) || BAR_UNLOCK.equals(evt.getItemKey());
    }

    @Override
    public void handleBeforeItemClick(AbstractFormPlugin plugin, BeforeItemClickEvent evt) {
        DynamicObject appFile = plugin.getView().getModel().getDataEntity();
        DynamicObject nowAppFile = AppFileDataHelper.queryAppFileById("filestatus", appFile.getLong("id"));
        String fileStatus = nowAppFile.getString("filestatus");
        boolean locked = AppFileFlowLockHelper.isLocked(appFile);
        if (fileStatus.equals(AppFileConstants.APP_FILE_STATUS_OUT) || fileStatus.equals(AppFileConstants.APP_FILE_STATUS_INVALID)) {
            String opName = "";
            if (BAR_LOCK.equals(evt.getItemKey())) {
                opName = AppFileOperateEnum.LOCK.getOpName().loadKDString();
            }
            if (BAR_UNLOCK.equals(evt.getItemKey())) {
                opName = AppFileOperateEnum.UNLOCK.getOpName().loadKDString();
            }
            String tipFmt = AppFileResManagerHelper.getFileStatusErrorTip();
            plugin.getView().showTipNotification(String.format(tipFmt, appFile.getString("name"), AppFileHelper.getFileStatusDesc(nowAppFile), opName));
            evt.setCancel(true);
        } else if (BAR_LOCK.equals(evt.getItemKey()) && locked) {
            if (AppFilePermissionHelper.isInMyHandPage(plugin) && !AppFilePermissionHelper.inMyHandPermission(Collections.singletonList(Long.valueOf(appFile.getPkValue().toString())))) {
                plugin.getView().showErrorNotification(AppFileResManagerHelper.getInMyHandPermissionErrorTip(AppFileOperateEnum.LOCK.getOpName().loadKDString()));
                evt.setCancel(true);
            }
            plugin.getView().showTipNotification(AppFileResManagerHelper.getLockedWarn(AppFileOperateEnum.LOCK.getOpName().loadKDString()));
            evt.setCancel(true);
        } else if (BAR_UNLOCK.equals(evt.getItemKey()) && !locked) {
            plugin.getView().showTipNotification(AppFileResManagerHelper.getUnLockOneWarn());
            evt.setCancel(true);
        }
    }

    @Override
    public boolean supportItemClick(ItemClickEvent evt) {
        return BAR_LOCK.equals(evt.getItemKey()) || BAR_UNLOCK.equals(evt.getItemKey());
    }

    @Override
    public void handleItemClick(AbstractFormPlugin plugin, ItemClickEvent evt) {
    }

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "lock".equals(afterDoOperationEventArgs.getOperateKey()) || "unlock".equals(afterDoOperationEventArgs.getOperateKey()) || "lockright".equals(afterDoOperationEventArgs.getOperateKey()) || "unlockright".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        if ("lock".equals(args.getOperateKey()) || "unlock".equals(args.getOperateKey())) {
            this.refresh(plugin);
        } else {
            ArrayList numberNamePairList = null;
            if (plugin instanceof AbstractListPlugin) {
                ListSelectedRowCollection selectedRows = ((IListView)plugin.getView()).getSelectedRows();
                numberNamePairList = selectedRows.stream().map(row -> Pair.of((Object)row.getNumber(), (Object)row.getName())).collect(Collectors.toList());
            } else {
                DynamicObject dataEntity = plugin.getView().getModel().getDataEntity();
                numberNamePairList = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)dataEntity.getString("number"), (Object)dataEntity.getString("name"))});
            }
            if (!args.getOperationResult().getSuccessPkIds().isEmpty()) {
                if ("lockright".equals(args.getOperateKey())) {
                    AppFileFlowLockHelper.showLockConfirm(plugin, numberNamePairList);
                } else if ("unlockright".equals(args.getOperateKey())) {
                    AppFileFlowLockHelper.showUnLockConfirm(plugin, numberNamePairList);
                }
            }
        }
    }
}

