/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.operation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFilePermissionHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ArchiveOperate
implements AppFileOperate {
    private static final String BAR_ARCHIVE = "bararchive";

    @Override
    public boolean supportBeforeItemClick(BeforeItemClickEvent evt) {
        return BAR_ARCHIVE.equals(evt.getItemKey());
    }

    @Override
    public void handleBeforeItemClick(AbstractFormPlugin plugin, BeforeItemClickEvent evt) {
        long appFileId = plugin.getView().getModel().getDataEntity().getLong("id");
        if (AppFilePermissionHelper.isInMyHandPage(plugin) && !AppFilePermissionHelper.inMyHandPermission(Collections.singletonList(appFileId))) {
            plugin.getView().showErrorNotification(AppFileResManagerHelper.getInMyHandPermissionErrorTip(AppFileOperateEnum.ARCHIVE.getOpName().loadKDString()));
            evt.setCancel(true);
            return;
        }
        DynamicObject appFile = AppFileHelper.queryOne(appFileId);
        boolean isWaitChange = AppFileHelper.isWaitChange(appFile);
        if (!isWaitChange) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5904\u4e8e\u53d8\u52a8\u8fdb\u7a0b\uff0c\u65e0\u6cd5\u786e\u8ba4\u53d8\u52a8\u3002", (String)"ArchiveOperate_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    @Override
    public boolean supportItemClick(ItemClickEvent evt) {
        return BAR_ARCHIVE.equals(evt.getItemKey());
    }

    @Override
    public void handleItemClick(AbstractFormPlugin plugin, ItemClickEvent evt) {
    }

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "archiveright".equals(afterDoOperationEventArgs.getOperateKey()) || "archive".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if (successPkIds.isEmpty()) {
            AppFileOpHelper.showOperationResult(plugin, args);
            return;
        }
        if ("archive".equals(args.getOperateKey())) {
            this.refresh(plugin);
            if (ObjectUtils.isNotEmpty((Object)successPkIds)) {
                plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u52a8\u6210\u529f", (String)"ArchiveOperate_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            }
        } else {
            ArrayList numberNamePairList = null;
            if (plugin instanceof AbstractListPlugin) {
                ListSelectedRowCollection selectedRows = ((IListView)plugin.getView()).getSelectedRows();
                numberNamePairList = selectedRows.stream().map(row -> Pair.of((Object)row.getNumber(), (Object)row.getName())).collect(Collectors.toList());
            } else {
                DynamicObject dataEntity = plugin.getView().getModel().getDataEntity();
                numberNamePairList = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)dataEntity.getString("number"), (Object)dataEntity.getString("name"))});
                AppFileFlowLockHelper.showArchiveConfirm(plugin, numberNamePairList);
            }
            if (!args.getOperationResult().getSuccessPkIds().isEmpty()) {
                AppFileFlowLockHelper.showArchiveConfirm(plugin, numberNamePairList);
            }
        }
    }
}

