/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.operation;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;

public class HireOperate
implements AppFileOperate {
    private static final Map<String, String> VALIDATE_KEY_MAP = Maps.newHashMapWithExpectedSize((int)4);

    @Override
    public boolean supportBefore(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        return "hireapproval".equals(operate.getOperateKey());
    }

    @Override
    public void handleBefore(AbstractFormPlugin plugin, BeforeDoOperationEventArgs args) {
        ListView listView;
        ListSelectedRowCollection selectedRows;
        if (plugin.getView() instanceof ListView && (selectedRows = (listView = (ListView)plugin.getView()).getSelectedRows()).size() != 1) {
            args.setCancel(true);
            listView.showTipNotification(AppFileResManagerHelper.getOnlySelectOneDesc());
        }
    }

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        return VALIDATE_KEY_MAP.containsKey(operateKey);
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        List<Long> pkIds = AppFileListHelper.getAfterDoOpPkIds(args);
        ValidateResult hireValidateResult = HireApprovalService.filterAppFileByEvent(VALIDATE_KEY_MAP.get(args.getOperateKey()), pkIds);
        for (OperateErrorInfo operateErrorInfo : hireValidateResult.getAllErrorInfo()) {
            args.getOperationResult().addErrorInfo(operateErrorInfo);
        }
        if (!args.getOperationResult().isSuccess()) {
            AppFileOpHelper.showOperationResult(plugin, args);
        } else if (!pkIds.isEmpty()) {
            this.openHirePage(plugin, args.getOperateKey(), pkIds);
        }
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        String opKey = closeCallBack.getActionId();
        if (opKey.endsWith("operateresult")) {
            opKey = opKey.substring(0, opKey.length() - "operateresult".length());
        }
        return VALIDATE_KEY_MAP.containsKey(opKey);
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        String actionId = closeCallBack.getActionId();
        if (actionId.endsWith("operateresult")) {
            this.continueHireOp(plugin, closeCallBack, actionId);
        } else {
            this.showHireOpResult(plugin, closeCallBack);
        }
    }

    private void continueHireOp(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack, String actionId) {
        String opKey = actionId.substring(0, actionId.length() - "operateresult".length());
        List returnData = (List)closeCallBack.getReturnData();
        if (returnData != null) {
            List<Long> pkIds = returnData.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            this.openHirePage(plugin, opKey, pkIds);
        }
    }

    private void showHireOpResult(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        String returnData;
        if (closeCallBack.getReturnData() != null && VALIDATE_KEY_MAP.containsKey(closeCallBack.getActionId()) && HRStringUtils.isNotEmpty((String)(returnData = (String)closeCallBack.getReturnData()))) {
            OperationResult operationResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)returnData, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            plugin.getView().showOperationResult(operationResult);
            if (operationResult.isSuccess()) {
                this.refresh(plugin);
            }
        }
    }

    private void openHirePage(AbstractFormPlugin plugin, String operateKey, List<Long> pkIds) {
        if (plugin.getView() instanceof ListView) {
            switch (operateKey) {
                case "hireapproval": {
                    this.openHireApprovalBox(plugin, pkIds.get(0));
                    break;
                }
            }
        } else {
            DynamicObject appFileObject = plugin.getView().getModel().getDataEntity();
            long appFileId = appFileObject.getLong("id");
            if (operateKey.equals("hireapproval")) {
                this.openHireApprovalBox(plugin, appFileId);
            }
        }
    }

    private void openHireApprovalBox(AbstractFormPlugin plugin, Long appFileId) {
        Boolean hasPeram = PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_hireapprovalsg");
        if (!hasPeram.booleanValue()) {
            DynamicObject hireDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_hireapprovalsg");
            String name = hireDynamicObject.getDataEntityType().getDisplayName().getLocaleValue();
            String message = ResManager.loadKDString((String)"\u65e0\"%s\"\u7684\"\u67e5\u8be2\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TSIRM_COMMON_PERM_MSG_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            plugin.getView().showErrorNotification(String.format(message, name));
        } else {
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId("tsirm_hireapprovalsg");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hireapproval"));
            formShowParameter.setCustomParam("appFileId", (Object)appFileId);
            plugin.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    static {
        VALIDATE_KEY_MAP.put("hireapproval", "hireApproval");
    }
}

