/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileOperate;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;

public class RecommendFilterOperate
implements AppFileOperate {
    private static final int FILTER_MAX_SELECT_NUM = 200;

    @Override
    public boolean supportBefore(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        return "filter".equals(operate.getOperateKey());
    }

    @Override
    public void handleBefore(AbstractFormPlugin plugin, BeforeDoOperationEventArgs args) {
        if (plugin instanceof AbstractListPlugin) {
            args.setCancel(AppFileListHelper.handleOutMaxSelectNum((AbstractListPlugin)plugin, 200));
        }
    }

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "filter".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        if (!args.getOperationResult().isSuccess()) {
            AppFileOpHelper.showOperationResult(plugin, args);
            return;
        }
        List<Long> pkIds = AppFileListHelper.getAfterDoOpPkIds(args);
        this.showFormRecommendFilter(pkIds, plugin);
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        return "tsirm_filterrecommend".equals(closeCallBack.getActionId()) || "filteroperateresult".equals(closeCallBack.getActionId());
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        if ("tsirm_filterrecommend".equals(closeCallBack.getActionId())) {
            HashMap returnDataMap = (HashMap)closeCallBack.getReturnData();
            if (returnDataMap != null) {
                RecommendFilterOperate.showRecommendFilterResult(returnDataMap, plugin.getView());
            }
            this.refresh(plugin);
        } else {
            List returnData = (List)closeCallBack.getReturnData();
            if (returnData != null) {
                List<Long> pkIds = returnData.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
                this.showFormRecommendFilter(pkIds, plugin);
            }
        }
    }

    private void showFormRecommendFilter(List<Long> appFileIds, AbstractFormPlugin plugin) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("tsirm_filterrecommend");
        formShowParameter.setCustomParam("appfileids", (Object)SerializationUtils.toJsonString(appFileIds));
        formShowParameter.setCustomParam("chanrgrange", (Object)plugin.getPageCache().get("chanrgrange"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tsirm_filterrecommend"));
        plugin.getView().showForm((FormShowParameter)formShowParameter);
    }

    public static void showRecommendFilterResult(Map<String, String> returnDataMap, IFormView view) {
        block8: for (Map.Entry<String, String> entry : returnDataMap.entrySet()) {
            switch (entry.getKey()) {
                case "success": {
                    view.showSuccessNotification(entry.getValue(), TSCBaseConstants.SUCCESS_NOTIFICATION_DEFAULT_TIME);
                    continue block8;
                }
                case "fail": {
                    view.showErrorNotification(entry.getValue());
                    continue block8;
                }
            }
            view.showTipNotification(entry.getValue());
        }
    }
}

