/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.operation;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.operation.AppFileOperate;

public class SendMsgOperate
implements AppFileOperate {
    private static final int SENDMSG_MAX_SELECT_NUM = 200;

    @Override
    public boolean supportBefore(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        return "sendmsg".equals(operate.getOperateKey());
    }

    @Override
    public void handleBefore(AbstractFormPlugin plugin, BeforeDoOperationEventArgs args) {
        if (plugin instanceof AbstractListPlugin && AppFileListHelper.handleOutMaxSelectNum((AbstractListPlugin)plugin, 200)) {
            args.setCancel(true);
        }
    }

    @Override
    public boolean supportAfter(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return "sendmsg".equals(afterDoOperationEventArgs.getOperateKey());
    }

    @Override
    public void handleAfter(AbstractFormPlugin plugin, AfterDoOperationEventArgs args) {
        if (!args.getOperationResult().isSuccess()) {
            AppFileOpHelper.showOperationResult(plugin, args);
            return;
        }
        List<Long> pkIds = AppFileListHelper.getAfterDoOpPkIds(args);
        if (plugin instanceof AbstractListPlugin) {
            pkIds = AppFileListHelper.getSelectedPkList((AbstractListPlugin)plugin, pkIds);
        }
        AppFileOpHelper.showFormSendMsg(pkIds, plugin);
    }

    @Override
    public boolean supportCloseCallBack(ClosedCallBackEvent closeCallBack) {
        return "tsirm_messagepush".equals(closeCallBack.getActionId()) || "sendmsgoperateresult".equals(closeCallBack.getActionId());
    }

    @Override
    public void handleCloseCallBack(AbstractFormPlugin plugin, ClosedCallBackEvent closeCallBack) {
        List returnData = (List)closeCallBack.getReturnData();
        if (returnData != null) {
            List<Long> pkIds = returnData.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            AppFileOpHelper.showFormSendMsg(pkIds, plugin);
        }
        plugin.getView().invokeOperation("refresh");
    }
}

