/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileFilterHelper {
    private static final String KEY_FILTERFEEDBACKSTATUS = "filterfeedbackstatus";
    private static final String KEY_FILTERFEEDBACKCONCLUSION = "filterfeedbackconclusion";
    private static final String[] FILTER_KEYS = new String[]{"nofkfilterfknum", "suitfilterfknum", "nosuitfilterfknum", "pendfilterfknum", "tfposfilterfknum"};

    private AppFileFilterHelper() {
    }

    public static boolean isExistFilterTaskByAppFileId(Long appFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_resumefilter");
        return helper.isExists(new QFilter[]{new QFilter("appfile", "=", (Object)appFileId)});
    }

    public static void updateAppFileFilterFeedBackData(List<Long> appFileIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_resumefilter");
        try (DataSet dataSet = helper.queryDataSet("AppFileList.updateAppFileFilterFeedBackData", "appfile,filterfeedbackstatus,filterfeedbackconclusion", new QFilter("appfile", "in", appFileIdList).toArray());){
            DataSet finish = dataSet.groupBy(new String[]{"appfile", KEY_FILTERFEEDBACKSTATUS, KEY_FILTERFEEDBACKCONCLUSION}).count().finish();
            Iterator iterator = finish.iterator();
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)appFileIdList.size());
            while (iterator.hasNext()) {
                Row rs = (Row)iterator.next();
                Long appfileId = rs.getLong("appfile");
                Map param = dataMap.get(appfileId) == null ? new HashMap() : (Map)dataMap.get(appfileId);
                String status = rs.getString(KEY_FILTERFEEDBACKSTATUS);
                Integer count = rs.getInteger("count");
                if ("3".equals(status)) {
                    String suitKey = "0";
                    switch (rs.getInteger(KEY_FILTERFEEDBACKCONCLUSION)) {
                        case 1: {
                            suitKey = "suitfilterfknum";
                            break;
                        }
                        case 2: {
                            suitKey = "nosuitfilterfknum";
                            break;
                        }
                        case 3: {
                            suitKey = "tfposfilterfknum";
                            break;
                        }
                        case 4: {
                            suitKey = "pendfilterfknum";
                        }
                    }
                    param.putIfAbsent(suitKey, count);
                } else {
                    param.put("nofkfilterfknum", count);
                }
                dataMap.put(appfileId, param);
            }
            AppFileFilterHelper.updateFilterStatus(appFileIdList, dataMap);
        }
    }

    public static void updateFilterStatus(List<Long> appFileIdList, Map<Long, Map<String, Integer>> dataMap) {
        DynamicObject[] appFiles;
        for (DynamicObject appFile : appFiles = AppFileHelper.queryAppFiles(appFileIdList, TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"nofkfilterfknum", "suitfilterfknum", "nosuitfilterfknum", "pendfilterfknum", "tfposfilterfknum", "filterstatus"}))) {
            AppFileFilterHelper.setAppFileFilterField(dataMap, appFile);
        }
        AppFileHelper.update(appFiles);
    }

    private static void setAppFileFilterField(Map<Long, Map<String, Integer>> dataMap, DynamicObject appFile) {
        Map<String, Integer> arr = dataMap.get(appFile.getLong("id"));
        if (arr != null) {
            for (int i = 0; i < FILTER_KEYS.length; ++i) {
                appFile.set(FILTER_KEYS[i], (Object)arr.get(FILTER_KEYS[i]));
            }
            StringBuilder filterStatusSb = new StringBuilder(",");
            Integer[] values = arr.values().toArray(new Integer[0]);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] <= 0) continue;
                filterStatusSb.append(i + 1).append(",");
            }
            appFile.set("filterstatus", (Object)filterStatusSb.toString());
        }
    }

    public static DynamicObject queryOneResumeFilterTaskByPk(Object resumeFilterTasksPk) {
        return ResumeFilterHelper.queryOneResumeFilterTaskByPk(resumeFilterTasksPk);
    }
}

