/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.service.AppFilePositionHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFileHomePageHelper {
    private static final Log logger = LogFactory.getLog(AppFileHomePageHelper.class);
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tsirm_appfilemdl");
    private static final HRBaseServiceHelper INTV_HELPER = new HRBaseServiceHelper("tsirm_argintv");
    private static final HRBaseServiceHelper FILTER_HELPER = new HRBaseServiceHelper("tsirm_resumefilter");
    private static final String KEY_INTVCANDATE = "intvcandate.fbasedataid";
    private static final String INTV_SELECTPROPS = "intvcandate.fbasedataid,intvcandate.fbasedataid.intvprogress,intvcandate.fbasedataid.intvevalresult,arrangeantime";
    private static final String INTV_FILTER_PROPS = "intvcandate.fbasedataid.recruproc";
    private static final String KEY_INTV_PROGRESS = "intvcandate.fbasedataid.intvprogress";
    private static final String KEY_INTV_RESULT = "intvcandate.fbasedataid.intvevalresult";
    private static final String INTV_ORDER_PROPS = "intvcandate.fbasedataid,arrangeantime desc";
    private static final String POS_RECR = "recruproc";

    private AppFileHomePageHelper() {
    }

    public static DynamicObject[] getResumeFilterData(String startTime, String endTime) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_resumefilter");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("filterhandlepeople", "=", (Object)TSCRequestContext.getUserId()));
        if (HRStringUtils.isNotEmpty((String)startTime)) {
            qFilters.add(new QFilter("createtime", ">=", (Object)LocalDate.parse(startTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        if (HRStringUtils.isNotEmpty((String)endTime)) {
            qFilters.add(new QFilter("createtime", "<=", (Object)LocalDate.parse(endTime, DateFormatConstants.NORM_DATETIME_FORM)));
        }
        return serviceHelper.query("appfile", qFilters.toArray(new QFilter[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getFilterCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        Object procDataSet;
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppFileHomePageHelper.getTobeFilterWaitedQFilter(isOwner, recruitProcId, timeRangeType, orgIds);
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.p", "id,recrustg,recrustat,recruproc", qFilters);){
            procDataSet = AppFileHomePageHelper.getDataSetFirstStageAndStatusProc(recruitProcId);
            Throwable throwable = null;
            try {
                JoinDataSet joinDataSet = dataSet.join((DataSet)procDataSet, JoinType.INNER).on(POS_RECR, "id").on("recrustg", "entryentity.rqmtstg").on("recrustat", "entryentity.subentryentity.jobstatus");
                finish = joinDataSet.select(new String[]{"id"}, new String[0]).finish();
                int beginCount = finish.count("id", true);
                result.put("begin", beginCount);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (procDataSet != null) {
                    if (throwable != null) {
                        try {
                            procDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        procDataSet.close();
                    }
                }
            }
        }
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tsirm_resumefilter");
        qFilters = AppFileHomePageHelper.getFilterSentQFilter(isOwner, recruitProcId, timeRangeType, orgIds);
        DataSet dataSet = filterHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.f", "appfile", qFilters);
        procDataSet = null;
        try {
            int inCount = dataSet.count("appfile", true);
            result.put("in", inCount);
        }
        catch (Throwable throwable) {
            procDataSet = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (procDataSet != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)procDataSet).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        List<Map<String, Object>> filterFinishedList = AppFileHomePageHelper.getFilterFinishedList(qFilters);
        long endCount = filterFinishedList.stream().filter(stat -> "3".equals(stat.get("filterfeedbackstatus"))).count();
        result.put("end", (int)endCount);
        return result;
    }

    public static Map<String, Integer> getInterviewCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        DynamicObjectCollection appFiles = FILTER_HELPER.queryOriginalCollection("appfile", AppFileHomePageHelper.getQFilterToBeArranged(isOwner, recruitProcId, timeRangeType, orgIds));
        Set appFileIds = appFiles.stream().map(dy -> dy.getLong("appfile")).collect(Collectors.toSet());
        try (DataSet dataSet = INTV_HELPER.queryDataSet("AppFileDataHelper.getInterviewCandidateData.begin", KEY_INTVCANDATE, new QFilter[]{new QFilter(KEY_INTVCANDATE, "in", appFileIds)});){
            int interviewedCount = dataSet.count(KEY_INTVCANDATE, true);
            result.put("begin", appFileIds.size() - interviewedCount);
        }
        Set<Map<String, Object>> interviewerInfoSet = AppFileHomePageHelper.getIntvAppFilesInfos(isOwner, recruitProcId, timeRangeType, orgIds);
        long inCount = interviewerInfoSet.stream().filter(map -> "A".equals(map.get(KEY_INTV_PROGRESS))).count();
        result.put("in", (int)inCount);
        long endCount = interviewerInfoSet.stream().filter(map -> "C".equals(map.get(KEY_INTV_PROGRESS)) && "A".equals(map.get(KEY_INTV_RESULT))).count();
        result.put("end", (int)endCount);
        return result;
    }

    public static Set<Long> queryTobeArrangedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        DynamicObjectCollection appFiles = FILTER_HELPER.queryOriginalCollection("appfile", AppFileHomePageHelper.getQFilterToBeArranged(isOwner, recruitProcId, timeRangeType, orgIds));
        Set<Long> appFileIds = appFiles.stream().map(dy -> dy.getLong("appfile")).collect(Collectors.toSet());
        try (DataSet dataSet = INTV_HELPER.queryDataSet("AppFileDataHelper.getInterviewCandidateData.queryTobeArrangedAppFileIdList", KEY_INTVCANDATE, new QFilter[]{new QFilter(KEY_INTVCANDATE, "in", appFileIds)});){
            for (Row row : dataSet) {
                appFileIds.remove(row.getLong(KEY_INTVCANDATE));
            }
        }
        return appFileIds;
    }

    private static QFilter[] getQFilterToBeArranged(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        QFilter qFilter = AppFilePositionHelper.getPositionRightQFilter("recruitmentposition", isOwner, orgIds);
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter("appfile.recruproc", "=", (Object)recruitProcId));
        }
        qFilter.and(new QFilter("filterfeedbackconclusion", "=", (Object)"1"));
        if (StringUtils.isNotEmpty((String)timeRangeType)) {
            Map<String, String> timeRange = AppFileHomePageHelper.coversTimePeriod(timeRangeType);
            if (HRStringUtils.isNotEmpty((String)timeRange.get("startdate"))) {
                qFilter.and("createtime", ">", (Object)LocalDate.parse(timeRange.get("startdate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
            if (HRStringUtils.isNotEmpty((String)timeRange.get("enddate"))) {
                qFilter.and("createtime", "<", (Object)LocalDate.parse(timeRange.get("enddate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
        }
        return qFilter.toArray();
    }

    /*
     * Exception decompiling
     */
    private static Set<Map<String, Object>> getIntvAppFilesInfos(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryTobeFilterWaitedAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        HashSet appFileIdSet = Sets.newHashSet();
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppFileHomePageHelper.getTobeFilterWaitedQFilter(isOwner, recruitProcId, timeRangeType, orgIds);
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.p", "id,recrustg,recrustat,recruproc", qFilters);
             DataSet procDataSet = AppFileHomePageHelper.getDataSetFirstStageAndStatusProc(recruitProcId);){
            JoinDataSet joinDataSet = dataSet.join(procDataSet, JoinType.INNER).on(POS_RECR, "id").on("recrustg", "entryentity.rqmtstg").on("recrustat", "entryentity.subentryentity.jobstatus");
            finish = joinDataSet.select(new String[]{"id"}, new String[0]).finish();
            finish.forEach(row -> appFileIdSet.add(row.getLong("id")));
        }
        return appFileIdSet;
    }

    public static DataSet getDataSetFirstStageAndStatusProc(Long recruitProcId) {
        HRBaseServiceHelper procHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        QFilter qFilter = new QFilter("entryentity.seq", "=", (Object)1);
        QFilter qFilter1 = new QFilter("entryentity.subentryentity.seq", "=", (Object)1);
        if (recruitProcId != 0L) {
            QFilter qFilter2 = new QFilter("id", "=", (Object)recruitProcId);
            qFilter1.and(qFilter2);
        }
        return procHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.r", "id,entryentity.rqmtstg,entryentity.subentryentity.jobstatus", new QFilter[]{qFilter, qFilter1});
    }

    public static QFilter[] getTobeFilterWaitedQFilter(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        QFilter qFilter = AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgIds);
        qFilter.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter(POS_RECR, "=", (Object)recruitProcId));
        }
        if (!StringUtils.isEmpty((String)timeRangeType)) {
            Map<String, String> timeRange = AppFileHomePageHelper.coversTimePeriod(timeRangeType);
            if (HRStringUtils.isNotEmpty((String)timeRange.get("startdate"))) {
                qFilter.and("createtime", ">", (Object)LocalDate.parse(timeRange.get("startdate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
            if (HRStringUtils.isNotEmpty((String)timeRange.get("enddate"))) {
                qFilter.and("createtime", "<", (Object)LocalDate.parse(timeRange.get("enddate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
        }
        return qFilter.toArray();
    }

    public static Set<Long> queryFilterSentAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        HashSet appFileIdSet = Sets.newHashSet();
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tsirm_resumefilter");
        QFilter[] qFilters = AppFileHomePageHelper.getFilterSentQFilter(isOwner, recruitProcId, timeRangeType, orgIds);
        try (DataSet dataSet = filterHelper.queryDataSet("AppFileDataHelper.queryFilterSentAppFileIdSet.f", "appfile", qFilters);){
            dataSet.forEach(row -> appFileIdSet.add(row.getLong("appfile")));
        }
        return appFileIdSet;
    }

    public static QFilter[] getFilterSentQFilter(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        QFilter qFilter = AppFilePositionHelper.getPositionRightQFilter("recruitmentposition", isOwner, orgIds);
        qFilter.and(new QFilter("appfile", "!=", (Object)0L));
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter("appfile.recruproc", "=", (Object)recruitProcId));
        }
        if (StringUtils.isNotEmpty((String)timeRangeType)) {
            Map<String, String> timeRange = AppFileHomePageHelper.coversTimePeriod(timeRangeType);
            if (HRStringUtils.isNotEmpty((String)timeRange.get("startdate"))) {
                qFilter.and("createtime", ">", (Object)LocalDate.parse(timeRange.get("startdate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
            if (HRStringUtils.isNotEmpty((String)timeRange.get("enddate"))) {
                qFilter.and("createtime", "<", (Object)LocalDate.parse(timeRange.get("enddate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
        }
        return qFilter.toArray();
    }

    public static Set<Long> queryFilterFinishedAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        QFilter[] qFilters = AppFileHomePageHelper.getFilterSentQFilter(isOwner, recruitProcId, timeRangeType, orgIds);
        List<Map<String, Object>> filterFinishedList = AppFileHomePageHelper.getFilterFinishedList(qFilters);
        return filterFinishedList.stream().filter(stat -> "3".equals(stat.get("filterfeedbackstatus"))).map(map -> (Long)map.get("appfile")).collect(Collectors.toSet());
    }

    public static List<Map<String, Object>> getFilterFinishedList(QFilter[] qFilters) {
        LinkedList<Map<String, Object>> firstRowList = new LinkedList<Map<String, Object>>();
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("tsirm_resumefilter");
        String selectProps = "id,appfile,filterfeedbackstatus,createtime";
        try (DataSet dataSet = filterHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.fi", selectProps, qFilters, "appfile,createtime DESC,filterfeedbackstatus DESC");){
            for (Row row : dataSet) {
                Long appFileId = row.getLong("appfile");
                if (!firstRowList.isEmpty() && HRObjectUtils.equals((Object)firstRowList.getLast().get("appfile"), (Object)appFileId)) continue;
                HashMap objectMap = Maps.newHashMapWithExpectedSize((int)2);
                objectMap.put("appfile", appFileId);
                objectMap.put("filterfeedbackstatus", row.getString("filterfeedbackstatus"));
                firstRowList.add(objectMap);
            }
        }
        return firstRowList;
    }

    public static Set<Long> queryTobeInterviewedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        Set<Map<String, Object>> firstRowList = AppFileHomePageHelper.getIntvAppFilesInfos(isOwner, recruitProcId, timeRangeType, orgIds);
        return firstRowList.stream().filter(map -> "A".equals(map.get(KEY_INTV_PROGRESS))).map(map -> (Long)map.get(KEY_INTVCANDATE)).collect(Collectors.toSet());
    }

    public static Set<Long> queryToBeAdvancedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        Set<Map<String, Object>> firstRowList = AppFileHomePageHelper.getIntvAppFilesInfos(isOwner, recruitProcId, timeRangeType, orgIds);
        Set<Long> appFileIds = firstRowList.stream().filter(map -> "C".equals(map.get(KEY_INTV_PROGRESS)) && "A".equals(map.get(KEY_INTV_RESULT))).map(map -> (Long)map.get(KEY_INTVCANDATE)).collect(Collectors.toSet());
        return appFileIds;
    }

    public static Map<String, Integer> getHireCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        QFilter[] waitedHireQFilter = AppFileHomePageHelper.getWaitedHireQFilter(isOwner, recruitProcId, startDate, orgIds);
        result.put("begin", APP_FILE_HELPER.queryOriginalArray("id", waitedHireQFilter).length);
        QFilter[] hireAuditingQFilter = AppFileHomePageHelper.getHireAuditingQFilter(isOwner, recruitProcId, startDate, orgIds);
        result.put("in", APP_FILE_HELPER.queryOriginalArray("id", hireAuditingQFilter).length);
        QFilter[] hireAuditedQFilter = AppFileHomePageHelper.getHireAuditedQFilter(isOwner, recruitProcId, startDate, orgIds);
        result.put("end", APP_FILE_HELPER.queryOriginalArray("id", hireAuditedQFilter).length);
        return result;
    }

    public static Set<Long> getWaitedHireIds(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        QFilter[] waitedHireQFilter = AppFileHomePageHelper.getWaitedHireQFilter(isOwner, recruitProcId, DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType)), orgIds);
        DynamicObject[] objects = APP_FILE_HELPER.queryOriginalArray("id", waitedHireQFilter);
        return Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getHireAuditingIds(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        QFilter[] hireAuditingQFilter = AppFileHomePageHelper.getHireAuditingQFilter(isOwner, recruitProcId, DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType)), orgIds);
        DynamicObject[] objects = APP_FILE_HELPER.queryOriginalArray("id", hireAuditingQFilter);
        return Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getHireAuditedIds(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        QFilter[] hireAuditedQFilter = AppFileHomePageHelper.getHireAuditedQFilter(isOwner, recruitProcId, DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType)), orgIds);
        DynamicObject[] objects = APP_FILE_HELPER.queryOriginalArray("id", hireAuditedQFilter);
        return Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static QFilter[] getWaitedHireQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, List<Long> orgIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_recrustgnew");
        List collectId = Arrays.stream(helper.loadDynamicObjectArray(new QFilter[]{new QFilter("group.id", "=", (Object)1050L)})).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter fourthQf = new QFilter("recrustg.id", "in", collectId);
        fourthQf.and(new QFilter("employapprlsatatus", "in", Arrays.asList(" ", "A", "F", "G")));
        if (null != startDate) {
            fourthQf.and(new QFilter("enterlinktime", ">=", (Object)startDate));
        }
        if (recruitProcId == 0L) {
            return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgIds), fourthQf};
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgIds), new QFilter(POS_RECR, "=", (Object)recruitProcId), fourthQf};
    }

    public static QFilter[] getHireAuditingQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, List<Long> orgIds) {
        QFilter fourthQf = new QFilter("employapprlsatatus", "in", Arrays.asList("B", "D"));
        if (null != startDate) {
            fourthQf.and(new QFilter("enterlinktime", ">=", (Object)startDate));
        }
        if (recruitProcId == 0L) {
            return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgIds), fourthQf};
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgIds), new QFilter(POS_RECR, "=", (Object)recruitProcId), fourthQf};
    }

    public static QFilter[] getHireAuditedQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, List<Long> orgIds) {
        QFilter fourthQf = new QFilter("employapprlsatatus", "in", Arrays.asList("C", "E"));
        if (null != startDate) {
            fourthQf.and(new QFilter("enterlinktime", ">=", (Object)startDate));
        }
        if (recruitProcId == 0L) {
            return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgIds), fourthQf};
        }
        return new QFilter[]{AppFilePositionHelper.getPositionRightQFilter("position", isOwner, orgIds), new QFilter(POS_RECR, "=", (Object)recruitProcId), fourthQf};
    }

    public static Map<String, String> coversTimePeriod(String timeFilterType) {
        String endTime;
        String startTime;
        if (timeFilterType.equals("past_one_year")) {
            startTime = LocalDate.now().minusYears(1L).getYear() + "-" + "01-01 00:00:00";
            endTime = LocalDate.now().minusYears(1L).getYear() + "-" + "12-31 23:59:59";
        } else {
            LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeFilterType));
            startTime = DateUtils.getDayStartTime((LocalDate)startDate);
            endTime = DateUtils.getDayEndTime((LocalDate)LocalDate.now().plusDays(1L));
        }
        HashMap<String, String> timePeriod = new HashMap<String, String>(2);
        timePeriod.put("startdate", startTime);
        timePeriod.put("enddate", endTime);
        return timePeriod;
    }
}

