/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.message.api.IMsgEventListener;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.business.domain.msgtrack.service.MsgTrackHelper;
import org.apache.commons.lang3.ObjectUtils;

public class AppFileMsgEventListener
implements IMsgEventListener {
    private static final String CHANNEL_MSG_ID = "channelMsgId";

    public void subSuccessMsgInfo(Long msgId, Map<String, Object> data) {
        this.updateMsgTrack(msgId);
        this.updateAppFileInfo(msgId);
    }

    public void subFailMsgInfo(Long msgId, Map<String, Object> data) {
        this.updateResult(msgId, data);
    }

    private void updateMsgTrack(Long msgId) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("msgid", msgId);
        paramMap.put("sendstatus", "1");
        paramMap.put("faireason", " ");
        MsgTrackHelper.updateMsgTrackByResult((Map)paramMap);
    }

    private void updateAppFileInfo(Long msgId) {
        DynamicObject msgTrackDy = MsgTrackHelper.queryMsgTrackByMsg((Long)msgId);
        Long msgTrackId = msgTrackDy.getLong("id");
        DynamicObject[] msgTrackObjDys = MsgTrackHelper.queryMsgTrackObjLists((List)ImmutableList.of((Object)msgTrackId));
        if (ObjectUtils.isNotEmpty((Object)msgTrackObjDys)) {
            DynamicObject msgTrackObjDy = msgTrackObjDys[0];
            Long appFileId = msgTrackObjDy.getLong("bizobj");
            DynamicObject appFileDy = AppFileHelper.queryOne(appFileId, "recentnotictime, recentcfgmsgscene");
            appFileDy.set("recentnotictime", (Object)new Date());
            appFileDy.set("recentcfgmsgscene", (Object)msgTrackDy.getDynamicObject("pushscene"));
            AppFileHelper.update(new DynamicObject[]{appFileDy});
        }
    }

    private void updateResult(Long msgId, Map<String, Object> data) {
        Long channelMsgId = (Long)data.get(CHANNEL_MSG_ID);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
        paramMap.put("msgid", msgId);
        paramMap.put("sendstatus", "2");
        paramMap.put("faireason", ResManager.loadKDString((String)"\u5176\u4ed6\u539f\u56e0", (String)"MsgTrack_6", (String)"tsc-tsrbd-formplugin", (Object[])new Object[0]));
        paramMap.put("msglogid", channelMsgId);
        MsgTrackHelper.updateMsgTrackByResult((Map)paramMap);
    }
}

