/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordChangeModel;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileOpRecordService {
    private static final Log LOG = LogFactory.getLog(AppFileOpRecordService.class);
    private static final AppFileOpRecordService INSTANCE = new AppFileOpRecordService();
    private final Map<OpDefEnum, OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>>> consumerMap = Maps.newHashMap();
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> changeStageOpRecordParser = this::changeStageOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> eliminateOpRecordParser = this::eliminateOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> recoverOpRecordParser = this::recoverOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> tpOpRecordParser = this::tpOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> createOpRecordParser = this::createOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> hireRecommendOpRecordParser = this::hireRecommendOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> hireStartRkOpRecordParser = this::hireJobStartRkOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> hireRkOpRecordParser = this::hireJobRkOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> hireSalOpRecordParser = this::hireSalOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> hireApprovalOpRecordParser = this::hireApprovalOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> updateRsmOpRecordParser = this::updateRsmOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> hireInitSalOpRecordParser = this::hireInitSalOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> lockOpRecordParser = this::lockOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> unLockOpRecordParser = this::unLockOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> inviteUpdateRsmOpRecordParser = this::inviteUpdateRsmOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> saveTalentOpRecordParser = this::saveTalentOpRecord;
    private final OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> downPrintOpRecordParser = this::downPrintOpRecord;

    public static AppFileOpRecordService getInstance() {
        return INSTANCE;
    }

    public void sendOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        LOG.info("sendOpRecord.params\uff1a{},{},{},{}", new Object[]{roleName, opDefEnum, appFileIdList, params});
        OpRecordFunction<String, OpDefEnum, List<Long>, Map<String, Object>> opRecConsumer = this.consumerMap.get(opDefEnum);
        if (opRecConsumer != null) {
            List<OprecordMessageModel> msgList = opRecConsumer.getOpRecordList(roleName, opDefEnum, appFileIdList, params);
            this.sendOpRecordMQ(msgList);
        }
    }

    private AppFileOpRecordService() {
    }

    private List<OprecordMessageModel> getOprecordMessageModels(String roleName, OpDefEnum opDefEnum, DynamicObject[] appFiles, String descFmt) {
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile);
            String oprText = String.format(descFmt, message.getOperatorrole(), message.getOperatorname(), appFile.getString("position.name"), message.getBizobjrole(), message.getBizobjname());
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private List<OprecordMessageModel> getOprecordMessageModels(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, String eliminateOpRecordDesc) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        return this.getOprecordMessageModels(roleName, opDefEnum, appFiles, eliminateOpRecordDesc);
    }

    private OprecordMessageModel getOpRecordMessageModel(String roleName, OpDefEnum opDefEnum, DynamicObject appFile) {
        OprecordMessageModel message = new OprecordMessageModel();
        message.setBizentry("tsirm_appfilemdl");
        message.setOperatorrole(roleName);
        message.setOperator(Long.valueOf(TSCRequestContext.getUserId()));
        message.setOperatorname(RequestContext.get().getUserName());
        message.setBizobj(appFile.getLong("id"));
        message.setBizobjrole("\u5019\u9009\u4eba");
        message.setBizobjname(appFile.getString("name"));
        message.setOptime(HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        message.setOpnumber(opDefEnum.getCode());
        return message;
    }

    private void sendOpRecordMQ(List<OprecordMessageModel> msgList) {
        LOG.info("sendOpRecordMQ.msgList\uff1a{}", msgList);
        try {
            OprecordMQ.sendOpRecordChangeMessage(msgList);
        }
        catch (KDException ex) {
            LOG.error("OprecordMQ.sendOpRecordChangeMessage.error:", (Throwable)ex);
        }
    }

    private List<OprecordMessageModel> changeStageOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        DynamicObject[] appFiles;
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFileIdList.size());
        String stgName = "recrustg.name";
        String statName = "recrustat.name";
        String selectProps = TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"name", "position", stgName, statName});
        for (DynamicObject appFile : appFiles = AppFileHelper.queryAppFiles(appFileIdList, selectProps)) {
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile);
            String oprText = String.format(AppFileResManagerHelper.getChangeStatusOpRecordDesc(), message.getOperatorrole(), message.getOperatorname(), appFile.getString("position.name"), message.getBizobjrole(), message.getBizobjname(), appFile.getString(stgName), appFile.getString(statName));
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private List<OprecordMessageModel> eliminateOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, AppFileResManagerHelper.getEliminateOpRecordDesc());
    }

    private List<OprecordMessageModel> recoverOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, AppFileResManagerHelper.getRecoverOpRecordDesc());
    }

    private List<OprecordMessageModel> tpOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getTranPosOpRecordDesc();
        if (params != null) {
            return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt + params.get(OpDefEnum.TSIRM_SWITCH_POSITION.getCode()));
        }
        return Lists.newArrayList();
    }

    private List<OprecordMessageModel> createOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        String descFmt = AppFileResManagerHelper.getCreateOpRecordDesc();
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile);
            String oprText = String.format(descFmt, message.getBizobjrole(), message.getBizobjname(), appFile.getString("position.name"));
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private List<OprecordMessageModel> updateRsmOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getUpdateRsmOpRecordDesc();
        List<OprecordMessageModel> oprecordMessageModels = this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
        if (params != null) {
            for (OprecordMessageModel oprecordMessageModel : oprecordMessageModels) {
                List changeList;
                Object changeListObj = params.get(String.valueOf(oprecordMessageModel.getBizobj()));
                if (!(changeListObj instanceof List) || (changeList = (List)changeListObj).isEmpty()) continue;
                oprecordMessageModel.setOpnumber(OpDefEnum.TSIRM_UPDATE.getCode());
                List<OprecordChangeModel> changeModelList = this.getRsmKeyFieldChangeList(changeList);
                oprecordMessageModel.setChangeList(changeModelList);
            }
        }
        return oprecordMessageModels;
    }

    private List<OprecordChangeModel> getRsmKeyFieldChangeList(List<Map<String, String>> changeList) {
        ArrayList changeModelList = Lists.newArrayListWithCapacity((int)changeList.size());
        for (Map<String, String> changeInfo : changeList) {
            OprecordChangeModel changeModel = new OprecordChangeModel();
            changeModel.setFieldkey(changeInfo.get("fieldkey"));
            changeModel.setFieldname(changeInfo.get("fieldname"));
            changeModel.setNewvalue(changeInfo.get("newvalue"));
            changeModel.setOriginalvalue(changeInfo.get("oldvalue"));
            changeModelList.add(changeModel);
        }
        return changeModelList;
    }

    private List<OprecordMessageModel> hireRecommendOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getHireRecommendOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> hireJobStartRkOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getHireStartRkOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> hireJobRkOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getHireRkOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> hireSalOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getHireSalOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> hireApprovalOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getHireApprovalOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> hireInitSalOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getHireInitSalOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> lockOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getLockOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> unLockOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        String descFmt = AppFileResManagerHelper.getUnLockOpRecordDesc();
        return this.getOprecordMessageModels(roleName, opDefEnum, appFileIdList, descFmt);
    }

    private List<OprecordMessageModel> inviteUpdateRsmOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        String descFmt = AppFileResManagerHelper.getInviteUpdateRsmOpRecordDesc();
        return this.getOpRecordMsgList(roleName, opDefEnum, appFiles, descFmt);
    }

    private List<OprecordMessageModel> saveTalentOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        String descFmt = AppFileResManagerHelper.getSaveTalentOpRecordDesc();
        for (DynamicObject appFile : appFiles) {
            Object talentNameListObj = params.get("talentNameList");
            if (!(talentNameListObj instanceof List)) continue;
            List talentNameList = (List)talentNameListObj;
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile);
            String oprText = String.format(descFmt, message.getOperatorrole(), message.getOperatorname(), message.getBizobjrole(), message.getBizobjname(), String.join((CharSequence)",", talentNameList));
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private List<OprecordMessageModel> downPrintOpRecord(String roleName, OpDefEnum opDefEnum, List<Long> appFileIdList, Map<String, Object> params) {
        DynamicObject[] appFiles = this.getAppFiles(appFileIdList);
        String descFmt = AppFileResManagerHelper.getPrintDownOpRecordDesc();
        return this.getOpRecordMsgList(roleName, opDefEnum, appFiles, descFmt);
    }

    private List<OprecordMessageModel> getOpRecordMsgList(String roleName, OpDefEnum opDefEnum, DynamicObject[] appFiles, String descFmt) {
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)appFiles.length);
        for (DynamicObject appFile : appFiles) {
            OprecordMessageModel message = this.getOpRecordMessageModel(roleName, opDefEnum, appFile);
            String oprText = String.format(descFmt, message.getOperatorrole(), message.getOperatorname(), message.getBizobjrole(), message.getBizobjname());
            message.setOprtext(oprText);
            msgList.add(message);
        }
        return msgList;
    }

    private DynamicObject[] getAppFiles(List<Long> appFileIdList) {
        String selectProps = TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"name", "position"});
        return AppFileHelper.queryAppFiles(appFileIdList, selectProps);
    }

    static {
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_CHANG_LINK_STATUS, AppFileOpRecordService.INSTANCE.changeStageOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_ELIMINATE, AppFileOpRecordService.INSTANCE.eliminateOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_RECOVERY, AppFileOpRecordService.INSTANCE.recoverOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_SWITCH_POSITION, AppFileOpRecordService.INSTANCE.tpOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_CREATE, AppFileOpRecordService.INSTANCE.createOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_HIRE_REC_INITIATE, AppFileOpRecordService.INSTANCE.hireRecommendOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_JOB_RANK_INIT, AppFileOpRecordService.INSTANCE.hireStartRkOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_JOB_RANK_INITSING, AppFileOpRecordService.INSTANCE.hireRkOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_SALARY, AppFileOpRecordService.INSTANCE.hireSalOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_HIRE_APPROVAL, AppFileOpRecordService.INSTANCE.hireApprovalOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_UPDATE, AppFileOpRecordService.INSTANCE.updateRsmOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.HIRE_SALARY_TASK, AppFileOpRecordService.INSTANCE.hireInitSalOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_LOCK, AppFileOpRecordService.INSTANCE.lockOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_UNLOCK, AppFileOpRecordService.INSTANCE.unLockOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.INTVI_UPDATE_RSM, AppFileOpRecordService.INSTANCE.inviteUpdateRsmOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.SAVE_TALENT, AppFileOpRecordService.INSTANCE.saveTalentOpRecordParser);
        AppFileOpRecordService.INSTANCE.consumerMap.put(OpDefEnum.TSIRM_PRINT_APPFILE, AppFileOpRecordService.INSTANCE.downPrintOpRecordParser);
    }

    @FunctionalInterface
    private static interface OpRecordFunction<A, B, C, D> {
        public List<OprecordMessageModel> getOpRecordList(A var1, B var2, C var3, D var4);
    }
}

