/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.domain.common.service.RecruitmentStageBusiness;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFilePositionHelper {
    private AppFilePositionHelper() {
    }

    public static Map<Long, String> queryPosPrinByAppFileId(List<Long> posIds) {
        DynamicObject[] positions;
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)posIds.size());
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tsirm_positionmanage");
        String posprinField = "position,posprin";
        for (DynamicObject positionManage : positions = posHelper.query(posprinField, new QFilter("position", "in", posIds).toArray())) {
            DynamicObjectCollection posprin = positionManage.getDynamicObjectCollection("posprin");
            if (posprin == null) continue;
            Long id = positionManage.getLong("position.id");
            String posprinNames = posprin.stream().map(po -> po.getDynamicObject("fbasedataid")).filter(Objects::nonNull).sorted(Comparator.comparingLong(aa -> aa.getLong("id"))).map(jj -> jj.getString("name")).collect(Collectors.joining("\u3001"));
            resMap.put(id, posprinNames);
        }
        return resMap;
    }

    public static QFilter getPositionRightQFilter(List<Long> orgIds) {
        QFilter dataPermissionFilter;
        long userId = TSCRequestContext.getUserId();
        HasPermOrgResult posResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac");
        if (!posResult.hasAllOrgPerm() && !posResult.getHasPermOrgs().containsAll(orgIds)) {
            return new QFilter("1", "!=", (Object)1);
        }
        QFilter rightQFilter = new QFilter("createorg", "in", orgIds);
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)userId, (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null);
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            rightQFilter.and(new QFilter("adminorgs.fbasedataid", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
        }
        if ((dataPermissionFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(userId, AppMetadataCache.getAppInfo((String)"tsirm").getId(), "tsirm_position", "47150e89000000ac", orgIds)) != null) {
            rightQFilter.and(dataPermissionFilter);
        }
        return rightQFilter;
    }

    public static QFilter getPositionRightQFilter(String position, boolean isOwner, List<Long> orgIds) {
        QFilter positionRightQFilter = AppFilePositionHelper.getPositionRightQFilter(orgIds);
        if (isOwner) {
            QFilter qFilter = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)TSCRequestContext.getUserId());
            positionRightQFilter.and(qFilter);
        }
        DynamicObjectCollection positions = new HRBaseServiceHelper("tsirm_position").queryOriginalCollection("id", new QFilter[]{positionRightQFilter});
        return new QFilter(position, "in", positions.stream().map(pos -> pos.getLong("id")).collect(Collectors.toList()));
    }

    public static List<Long> getPositionIdsRightRecruing(String position, boolean isOwner, List<Long> orgIds) {
        QFilter positionRightQFilter = AppFilePositionHelper.getPositionRightQFilter(orgIds);
        positionRightQFilter.and(new QFilter("positionstatus", "=", (Object)"A"));
        if (isOwner) {
            QFilter qFilter = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)TSCRequestContext.getUserId());
            positionRightQFilter.and(qFilter);
        }
        DynamicObjectCollection positions = new HRBaseServiceHelper("tsirm_position").queryOriginalCollection("id", new QFilter[]{positionRightQFilter});
        return positions.stream().map(pos -> pos.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> queryPosProcStageIdList(long positionId) {
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tsirm_positionmanage");
        QFilter qFilter = new QFilter("position", "=", (Object)positionId);
        DynamicObject dynamicObject = posHelper.queryOne("recruproc,recruproc.entryentity.rqmtstg", qFilter);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if (!(Objects.isNull(dynamicObject) || Objects.isNull(dynamicObject.getDynamicObject("recruproc")) || Objects.isNull(dynamicObject.getDynamicObject("recruproc").getDynamicObjectCollection("entryentity")))) {
            collection = dynamicObject.getDynamicObject("recruproc").getDynamicObjectCollection("entryentity");
        }
        return collection.stream().map(dyn -> dyn.getDynamicObject("rqmtstg").getLong("id")).collect(Collectors.toList());
    }

    @Deprecated
    public static List<Long> queryPosProcStageStatusIdList(long positionId, long stgId) {
        return AppFilePositionHelper.queryPosProcStageStatusIdListNew(stgId);
    }

    public static List<Long> queryPosProcStageStatusIdListNew(long stgId) {
        QFilter qFilter = new QFilter("id", "=", (Object)stgId);
        DynamicObject[] results = RecruitmentStageBusiness.getInstance().query("id,statselnewentry.stat", qFilter.toArray());
        return Arrays.stream(results).map(result -> result.getDynamicObjectCollection("statselnewentry")).flatMap(statCollection -> statCollection.stream().map(stats -> stats.getLong("stat.id")).collect(Collectors.toList()).stream()).collect(Collectors.toCollection(() -> Lists.newArrayListWithCapacity((int)10)));
    }

    public static DynamicObject queryManageInfo(long positionId, String positionField) {
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tsirm_positionmanage");
        return posHelper.queryOne(positionField, new QFilter("position", "=", (Object)positionId).toArray());
    }

    public static DynamicObject[] queryPositions(QFilter positionQFilter) {
        HRBaseServiceHelper positionHelper = new HRBaseServiceHelper("tsirm_positiontpl");
        return positionHelper.query("id,number,name", positionQFilter.toArray(), "positionpriority desc,modifytime desc,createtime desc", 100);
    }
}

