/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;

public class AppFileRightHelper {
    private static final Log LOG = LogFactory.getLog(AppFileRightHelper.class);
    private static final PermissionService PERM_SERVICE = (PermissionService)ServiceFactory.getService(PermissionService.class);

    private AppFileRightHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static HasPermOrgResult getManagePermResult(String permItemId, Long userId) {
        return AppFileRightHelper.getPermOrgResult("tsirm", "tsirm_appfile_viewm", userId, permItemId);
    }

    public static HasPermOrgResult getMyChargePermResult(String permItemId, Long userId) {
        return AppFileRightHelper.getPermOrgResult("tsirm", "tsirm_appfile_viewc", userId, permItemId);
    }

    public static HasPermOrgResult getPermOrgResult(String appId, String pageId, Long userId, String permItemId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pageId);
        String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)"createorg");
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)pageId, (String)permItemId);
    }

    public static boolean hasRight(Long appFileId, String appId, Long userId, String permItem) {
        if (HRStringUtils.equals((String)"tsirm", (String)appId)) {
            boolean hasManageAppFileRight = !AppFileRightHelper.hasAppFileRight(Lists.newArrayList((Object[])new Long[]{appFileId}), userId, "tsirm_appfile_viewm", permItem, false).isEmpty();
            boolean hasChargeAppFileRight = !AppFileRightHelper.hasAppFileRight(Lists.newArrayList((Object[])new Long[]{appFileId}), userId, "tsirm_appfile_viewc", permItem, true).isEmpty();
            return hasManageAppFileRight || hasChargeAppFileRight;
        }
        return false;
    }

    public static Map<Long, Boolean> hasRight(List<Long> appFileIds, String appId, Long userId, String permItem) {
        Map<Long, Boolean> rightMap = appFileIds.stream().collect(Collectors.toMap(pkId -> pkId, boo -> Boolean.FALSE));
        if (HRStringUtils.equals((String)"tsirm", (String)appId)) {
            List<Long> manageRightIds = AppFileRightHelper.hasAppFileRight(appFileIds, userId, "tsirm_appfile_viewm", permItem, false);
            List<Long> chargeRightIds = AppFileRightHelper.hasAppFileRight(appFileIds, userId, "tsirm_appfile_viewc", permItem, true);
            for (Long manageRightId : manageRightIds) {
                rightMap.put(manageRightId, Boolean.TRUE);
            }
            for (Long chargeRightId : chargeRightIds) {
                rightMap.put(chargeRightId, Boolean.TRUE);
            }
        }
        return rightMap;
    }

    public static List<Long> hasAppFileRight(List<Long> appFileIdList, Long userId, String pageNumber, String permItemId, boolean isOwner) {
        AuthorizedOrgResult adminOrgAuthorize;
        LOG.info("hasTSSRMManageRight.params:{},{},{},{}", new Object[]{appFileIdList, userId, permItemId, isOwner});
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return new ArrayList<Long>(appFileIdList);
        }
        QFilter qFilter = new QFilter("id", "in", appFileIdList);
        if (isOwner) {
            qFilter.and("position.manageinfo.posprin.fbasedataid", "=", (Object)userId);
        }
        HasPermOrgResult permResult = AppFileRightHelper.getPermOrgResult("tsirm", pageNumber, userId, permItemId);
        if (pageNumber.equals("tsirm_appfile_viewm") && !permResult.hasAllOrgPerm()) {
            qFilter.and("createorg", "in", (Object)permResult.getHasPermOrgs());
        }
        if (!(adminOrgAuthorize = TSCBizDataPermService.getUserAdminOrgs((Long)userId, (String)"tsirm", (String)pageNumber, (String)"47150e89000000ac", (String)"adminorg", (Map)Maps.newHashMap())).isHasAllOrgPerm()) {
            qFilter.and("adminorg", "in", (Object)adminOrgAuthorize.getHasPermOrgs());
        }
        if (!permResult.hasAllOrgPerm()) {
            QFilter dataPermissionFilter = PERM_SERVICE.getDataRuleWithoutDim(userId.longValue(), AppMetadataCache.getAppInfo((String)"tsirm").getId(), pageNumber, permItemId, permResult.getHasPermOrgs());
            qFilter.and(dataPermissionFilter);
        }
        LOG.info("hasAppFileRight.qfilter:{}", (Object)qFilter);
        return Arrays.stream(AppFileHelper.queryAppFiles("id", qFilter.toArray())).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
    }

    public static QFilter getAppFileRightQFilter(String appFileFieldPre, Long userId, String permItemId) {
        QFilter qFilter;
        HasPermOrgResult managePermResult = AppFileRightHelper.getManagePermResult(permItemId, userId);
        if (!managePermResult.hasAllOrgPerm()) {
            qFilter = new QFilter(appFileFieldPre + "createorg", "in", (Object)managePermResult.getHasPermOrgs());
            AuthorizedOrgResult adminOrgAuthorize = TSCBizDataPermService.getUserAdminOrgs((Long)userId, (String)"tsirm", (String)"tsirm_appfile_viewm", (String)"47150e89000000ac", (String)"adminorg", (Map)Maps.newHashMap());
            if (!adminOrgAuthorize.isHasAllOrgPerm()) {
                qFilter.and(new QFilter(appFileFieldPre + "adminorg", "in", (Object)adminOrgAuthorize.getHasPermOrgs()));
            }
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"tsirm_appfilemdl");
            String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)"createorg");
            qFilter = new QFilter(appFileFieldPre + "createorg", "in", (Object)OrgUnitServiceHelper.getAllOrg((String)orgViewType));
        }
        return qFilter;
    }
}

