/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.ChangeStageStatusHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class AppFileRsmHelper {
    private static final Log LOG = LogFactory.getLog(AppFileRsmHelper.class);
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tsirm_appfile_view");

    private AppFileRsmHelper() {
    }

    public static void saveAppFileOperation(DynamicObject appFile, DynamicObject position, AppResumeBo resumeBo) {
        boolean isNew = !appFile.getDataEntityState().getFromDatabase();
        long start = System.currentTimeMillis();
        if (isNew) {
            LOG.info("saveAppFileOperation set data start");
            appFile.set("isbinddelyrec", (Object)"0");
            appFile.set("creator", (Object)TSCRequestContext.getUserId());
            appFile.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            appFile.set("status", (Object)"C");
            appFile.set("masterid", (Object)appFile.getLong("id"));
            long creatOrgId = position.getLong("createorg.id");
            String number = CodeRuleServiceHelper.getNumber((String)"tsirm_appfilemdl", (DynamicObject)appFile, (String)String.valueOf(creatOrgId));
            LOG.info("CodeRuleServiceHelper.getNumber cost {}", (Object)(System.currentTimeMillis() - start));
            appFile.set("number", (Object)number);
            appFile.set("createorg", (Object)creatOrgId);
            appFile.set("adminorg", (Object)position.getLong("adminorg.id"));
            appFile.set("positionsnap", position.get("vid"));
            appFile.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            appFile.set("validrecruchnlnm", (Object)resumeBo.getDelivery().getLong("recruchnlnm.id"));
            HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tsirm_positionmanage");
            long getPositionManageStart = System.currentTimeMillis();
            DynamicObject positionManage = posHelper.queryOne("recruproc", new QFilter("position", "=", (Object)position.getLong("id")));
            LOG.info("getPositionManage cost {}", (Object)(System.currentTimeMillis() - getPositionManageStart));
            Long procId = positionManage.getLong("recruproc.id");
            appFile.set("recruproc", (Object)procId);
            HRBaseServiceHelper processHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
            DynamicObject recProcess = processHelper.queryOne((Object)procId);
            DynamicObjectCollection entries = recProcess.getDynamicObjectCollection("entryentity");
            if (!entries.isEmpty()) {
                DynamicObject firstEntry = (DynamicObject)entries.get(0);
                long stgId = firstEntry.getLong("rqmtstg.id");
                DynamicObjectCollection subEntries = firstEntry.getDynamicObjectCollection("subentryentity");
                long statId = 0L;
                if (!subEntries.isEmpty()) {
                    DynamicObject firstSubEntry = (DynamicObject)subEntries.get(0);
                    statId = firstSubEntry.getLong("jobstatus.id");
                }
                ChangeStageStatusHelper.saveStageTraceNoUpdateAppFile(stgId, statId, 0L, new DynamicObject[]{appFile});
            }
        }
        long updateStart = System.currentTimeMillis();
        RsmCommonService.updateAppFileByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
        RsmCommonService.updateAppFileDeliveryByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
        LOG.info("updateAppFileDeliveryByAppResume cost {} ", (Object)(System.currentTimeMillis() - updateStart));
        if (isNew) {
            LOG.info("saveAppFileOperation set data cost {}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            APP_FILE_HELPER.saveOne(appFile);
            LOG.info("saveAppFileOperation save one cost {}", (Object)(System.currentTimeMillis() - start));
            ArrayList appFileIdList = Lists.newArrayList((Object[])new Long[]{appFile.getLong("id")});
            start = System.currentTimeMillis();
            AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_CREATE, appFileIdList, null);
            LOG.info("saveAppFileOperation save sendOpRecord cost {}", (Object)(System.currentTimeMillis() - start));
        } else {
            APP_FILE_HELPER.updateOne(appFile);
        }
    }
}

