/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbd.business.domain.config.service.ConfigSysCfgParamHelper;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class AppFileStdRsmHelper {
    private static final Log logger = LogFactory.getLog(AppFileStdRsmHelper.class);
    private static final int FILE_PERIOD_DAY = -1;
    private static final Boolean CK_SWITCH = Boolean.TRUE;
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tsirm_appfilemdl");

    private AppFileStdRsmHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static int queryOtherAppCount(Long mid, Long appFileId) {
        if (HRObjectUtils.isEmpty((Object)mid) || mid == 0L) {
            return 0;
        }
        QFilter qFilter = new QFilter("stdrsm.mid", "=", (Object)mid);
        qFilter.and(new QFilter("id", "!=", (Object)appFileId));
        int count = APP_FILE_HELPER.queryOriginalArray("id", qFilter.toArray()).length;
        return count;
    }

    public static Set<Long> getAppFileIdsByStdRsmMidsAndPositionId(Set<Long> stdRsmMids, Long positionId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter qFilter = new QFilter("stdrsm.mid", "in", stdRsmMids);
        qFilter.and(new QFilter("position", "=", (Object)positionId));
        QFilter fileQfilter = new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_IN);
        qFilter.and(fileQfilter);
        return helper.queryOriginalCollection("stdrsm.mid", qFilter.toArray()).stream().map(dyo -> dyo.getLong("stdrsm.mid")).collect(Collectors.toSet());
    }

    public static void mergeCandidate(Long mainId, Long subId) {
        try (TXHandle tx = TX.required();){
            try {
                String selectProps = TSCBaseUtils.getSelectPropertiesString((String[])new String[]{"position.id", "filestatus", "eliminatetime", "modifytime", "modifier", "stdrsm"});
                DynamicObject[] mainAppFiles = APP_FILE_HELPER.query(selectProps, new QFilter[]{new QFilter("stdrsm", "=", (Object)mainId)});
                DynamicObject[] subAppFiles = APP_FILE_HELPER.query(selectProps, new QFilter[]{new QFilter("stdrsm", "=", (Object)subId)});
                ArrayList invalidAppFiles = Lists.newArrayListWithCapacity((int)subAppFiles.length);
                AppFileStdRsmHelper.setInvalidAppFiles(mainAppFiles, subAppFiles, invalidAppFiles);
                for (DynamicObject subAppFile : subAppFiles) {
                    subAppFile.set("stdrsm", (Object)mainId);
                }
                AppFileHelper.update(subAppFiles);
                AppFileStatusHelper.invalidAppFiles(invalidAppFiles.toArray(new DynamicObject[0]));
                AppFileFlowLockHelper.mergeCandidate(mainId, subId);
            }
            catch (RuntimeException ex) {
                logger.error("mergeCandidate.appfile.error", (Throwable)ex);
                tx.markRollback();
                throw ex;
            }
        }
    }

    private static void setInvalidAppFiles(DynamicObject[] mainAppFiles, DynamicObject[] subAppFiles, List<DynamicObject> invalidAppFiles) {
        for (DynamicObject subAppFile : subAppFiles) {
            if (!AppFileHelper.isInProcessOrEmp(subAppFile)) continue;
            AppFileStdRsmHelper.addInvaidAppFile(mainAppFiles, invalidAppFiles, subAppFile);
        }
    }

    private static void addInvaidAppFile(DynamicObject[] mainAppFiles, List<DynamicObject> invalidAppFiles, DynamicObject subAppFile) {
        Long positionId = subAppFile.getLong("position.id");
        for (DynamicObject mainAppFile : mainAppFiles) {
            boolean equals = HRObjectUtils.equals((Object)positionId, (Object)mainAppFile.getLong("position.id"));
            if (!equals || !AppFileHelper.isInProcessOrEmp(mainAppFile)) continue;
            invalidAppFiles.add(subAppFile);
            break;
        }
    }

    public static void showStandardResumePage(AbstractFormPlugin plugin, Long stdRsmId) {
        StdRsmCommonService.getInstance().showStandardResumePage(plugin, stdRsmId);
    }

    public static void selectTalentPool(AbstractFormPlugin plugin, List<Long> listWithoutDuplicates) {
        StdRsmCommonService.getInstance().selectTalentPool(plugin, listWithoutDuplicates);
    }

    public static void validateTalentRight(AbstractFormPlugin plugin, List<Long> selectPkIds, String pageNumber) {
        StdRsmCommonService.getInstance().validateTalentRight(plugin, selectPkIds, pageNumber, "savetalent");
    }

    public static void saveTalent(AbstractFormPlugin plugin, ListSelectedRowCollection listSelectedRows) {
        StdRsmCommonService.getInstance().saveTalent(plugin, listSelectedRows);
    }

    public static DynamicObject getAppFileByStdRsmIdAndPositionId(Long stdRsmId, Long positionId, Date applyTime) {
        if (Boolean.TRUE.equals(AppFileStdRsmHelper.getCheckDupSwitch())) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilemdl");
            QFilter qFilter = new QFilter("stdrsm.mid", "=", (Object)stdRsmId);
            qFilter.and(new QFilter("position", "=", (Object)positionId));
            QFilter fileQfilter = new QFilter("filestatus", "in", (Object)Sets.newHashSet((Object[])new String[]{AppFileConstants.APP_FILE_STATUS_IN, AppFileConstants.APP_FILE_STATUS_TBEMP, AppFileConstants.APP_FILE_STATUS_EMPED})).or(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_OUT).and(new QFilter("eliminatetime", ">", (Object)HRDateTimeUtils.addDay((Date)applyTime, (long)AppFileStdRsmHelper.getExpDay()))));
            qFilter.and(fileQfilter);
            return helper.queryOne(TSCBaseUtils.getSelectProperties((String)"tsirm_appfilemdl"), qFilter.toArray(), "createtime");
        }
        return null;
    }

    public static Boolean getCheckDupSwitch() {
        Object checkDup = ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)"checkdup");
        if (checkDup instanceof Boolean) {
            return (Boolean)checkDup;
        }
        return CK_SWITCH;
    }

    public static int getExpDay() {
        Object fileExp = ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)"fileexp");
        if (fileExp instanceof Integer) {
            return -((Integer)fileExp).intValue();
        }
        return -1;
    }

    public static void updateStdRsmLastStgAndStat(long stgId, long statId, List<Long> stdRsmIdList) {
        HashMap stgAndStatMap = Maps.newHashMapWithExpectedSize((int)2);
        stgAndStatMap.put("recrustg", String.valueOf(stgId));
        stgAndStatMap.put("recrustat", String.valueOf(statId));
        StandardResumeDataHelper.updateStdRsmTalent(stdRsmIdList, (Map<String, Object>)stgAndStatMap);
    }

    public static void updateStdRsmInfo(Long stdRsmId, Map<String, String> stdRsmInfoMap) {
        String appFileIdStr;
        int positionNum;
        String positionStr = stdRsmInfoMap.get("position");
        String recruchnlnmStr = stdRsmInfoMap.get("recruchnlnm");
        HashMap appPosNumAndRecMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap stgAndStatMap = Maps.newHashMapWithExpectedSize((int)2);
        try (DataSet dataSet = APP_FILE_HELPER.queryDataSet("updateAppPosNumAndRecChlStdRsmInfo.positionnum", "position", new QFilter[]{new QFilter("stdrsm", "=", (Object)stdRsmId)});){
            positionNum = dataSet.count("position", true);
        }
        stgAndStatMap.put("positionnum", String.valueOf(positionNum));
        stgAndStatMap.put("recruchnlnm", recruchnlnmStr);
        if (HRStringUtils.isNotEmpty((String)positionStr)) {
            stgAndStatMap.put("position", positionStr);
        }
        if (HRStringUtils.isNotEmpty((String)(appFileIdStr = stdRsmInfoMap.get("appfile")))) {
            if (HRStringUtils.isBlank((CharSequence)stdRsmInfoMap.get("recrustg")) || HRStringUtils.isBlank((CharSequence)stdRsmInfoMap.get("recrustat"))) {
                long appFileId = Long.parseLong(appFileIdStr);
                DynamicObject appFile = AppFileHelper.queryOne(appFileId);
                stgAndStatMap.put("recrustg", appFile.getString("recrustg.id"));
                stgAndStatMap.put("recrustat", appFile.getString("recrustat.id"));
            } else {
                stgAndStatMap.put("recrustg", stdRsmInfoMap.get("recrustg"));
                stgAndStatMap.put("recrustat", stdRsmInfoMap.get("recrustat"));
            }
        }
        appPosNumAndRecMap.put(stdRsmId, stgAndStatMap);
        for (Map.Entry entry : appPosNumAndRecMap.entrySet()) {
            StandardResumeDataHelper.updateStdRsmTalent((Long)entry.getKey(), (Map<String, Object>)((Map)entry.getValue()));
        }
    }

    public static Map<Long, Map<String, String>> updateStdRsmInfo(Long stdRsmId, Map<String, String> stdRsmInfoMap, Map<Long, Integer> result) {
        String appFileIdStr;
        String positionStr = stdRsmInfoMap.get("position");
        String recruchnlnmStr = stdRsmInfoMap.get("recruchnlnm");
        HashMap appPosNumAndRecMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap stgAndStatMap = Maps.newHashMapWithExpectedSize((int)2);
        int positionNum = result.get(stdRsmId);
        stgAndStatMap.put("positionnum", String.valueOf(positionNum));
        stgAndStatMap.put("recruchnlnm", recruchnlnmStr);
        if (HRStringUtils.isNotEmpty((String)positionStr)) {
            stgAndStatMap.put("position", positionStr);
        }
        if (HRStringUtils.isNotEmpty((String)(appFileIdStr = stdRsmInfoMap.get("appfile")))) {
            if (HRStringUtils.isBlank((CharSequence)stdRsmInfoMap.get("recrustg")) || HRStringUtils.isBlank((CharSequence)stdRsmInfoMap.get("recrustat"))) {
                long appFileId = Long.parseLong(appFileIdStr);
                DynamicObject appFile = AppFileHelper.queryOne(appFileId);
                stgAndStatMap.put("recrustg", appFile.getString("recrustg.id"));
                stgAndStatMap.put("recrustat", appFile.getString("recrustat.id"));
            } else {
                stgAndStatMap.put("recrustg", stdRsmInfoMap.get("recrustg"));
                stgAndStatMap.put("recrustat", stdRsmInfoMap.get("recrustat"));
            }
        }
        appPosNumAndRecMap.put(stdRsmId, stgAndStatMap);
        return appPosNumAndRecMap;
    }

    public static Map<Long, Boolean> getBlackListMap(List<Long> appFileIdList) {
        return Arrays.stream(AppFileHelper.queryAppFiles(appFileIdList, "stdrsm")).collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> "-4".equals(dyo.getString("stdrsm.datastatus"))));
    }

    public static QFilter isNotInBlackList(String appFileFieldPre) {
        return new QFilter(appFileFieldPre + "stdrsm" + "." + "datastatus", "<>", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
    }

    public static DynamicObject[] getAppFilesByStdMidAndPositionId(List<Long> midList, List<Long> positionIdList, Date applyTime) {
        if (Boolean.TRUE.equals(AppFileStdRsmHelper.getCheckDupSwitch())) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilemdl");
            QFilter qFilter = new QFilter("stdrsm.mid", "in", midList);
            qFilter.and(new QFilter("position", "in", positionIdList));
            QFilter fileQfilter = new QFilter("filestatus", "in", (Object)Sets.newHashSet((Object[])new String[]{AppFileConstants.APP_FILE_STATUS_IN, AppFileConstants.APP_FILE_STATUS_TBEMP, AppFileConstants.APP_FILE_STATUS_EMPED})).or(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_OUT).and(new QFilter("eliminatetime", ">", (Object)HRDateTimeUtils.addDay((Date)applyTime, (long)AppFileStdRsmHelper.getExpDay()))));
            qFilter.and(fileQfilter);
            return helper.query(TSCBaseUtils.getSelectProperties((String)"tsirm_appfilemdl"), qFilter.toArray(), "createtime");
        }
        return null;
    }
}

