/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class AppProHomePageHelper {
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tsirm_appfilemdl");
    private static final HRBaseServiceHelper FILTER_HELPER = new HRBaseServiceHelper("tsirm_resumefilter");
    private static final String POS_RECR = "recruproc";
    private static final String FILTER_APPFILE_RECRUSTGTYP = "recrustg.group.id";

    private AppProHomePageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getFilterCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        Throwable throwable;
        DataSet dataSet;
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppProHomePageHelper.getTobeFilterWaitedQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        try (Object finish = null;){
            dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.p", "id,recrustg,recrustat,recruproc", qFilters);
            throwable = null;
            try {
                result.put("begin", dataSet.count("id", true));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        qFilters = AppProHomePageHelper.getTobeFilterBackedQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        try {
            dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.g", "id,recrustg,recrustat,recruproc", qFilters);
            throwable = null;
            try {
                result.put("end", dataSet.count("id", true));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        finally {
            if (finish != null) {
                finish.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getInterviewCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        Throwable throwable;
        DataSet dataSet;
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppProHomePageHelper.getTobeFilterToArrangeQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        try (Object finish = null;){
            dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getInterviewCandidateData.a", "id,recrustg,recrustat,recruproc", qFilters);
            throwable = null;
            try {
                result.put("begin", dataSet.count("id", true));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        qFilters = AppProHomePageHelper.getTobeFilterToEvalQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        try {
            dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getInterviewCandidateData.e", "id,recrustg,recrustat,recruproc", qFilters);
            throwable = null;
            try {
                result.put("in", dataSet.count("id", true));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        finally {
            if (finish != null) {
                finish.close();
            }
        }
        qFilters = AppProHomePageHelper.getTobeFilterToPushQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        try {
            dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getInterviewCandidateData.p", "id,recrustg,recrustat,recruproc", qFilters);
            throwable = null;
            try {
                result.put("end", dataSet.count("id", true));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        finally {
            if (finish != null) {
                finish.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryTobeArrangedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppProHomePageHelper.getTobeFilterToArrangeQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        HashSet appFileIdSet = Sets.newHashSet();
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getInterviewCandidateData.a", "id,recrustg,recrustat,recruproc", qFilters);){
            finish = dataSet.select("id");
            finish.forEach(row -> appFileIdSet.add(row.getLong("id")));
        }
        return appFileIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryTobeFilterWaitedAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        HashSet appFileIdSet = Sets.newHashSet();
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppProHomePageHelper.getTobeFilterWaitedQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getFilterCandidateData.p", "id,recrustg,recrustat,recruproc", qFilters);){
            finish = dataSet.select("id");
            finish.forEach(row -> appFileIdSet.add(row.getLong("id")));
        }
        return appFileIdSet;
    }

    public static QFilter[] getTobeFilterWaitedQFilter(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter qFilter = new QFilter("position", "in", positionIds);
        qFilter.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        qFilter.and(new QFilter("filterstatus", "=", (Object)""));
        qFilter.and(new QFilter(FILTER_APPFILE_RECRUSTGTYP, "=", (Object)1010L));
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter(POS_RECR, "=", (Object)recruitProcId));
        }
        if (!StringUtils.isEmpty((String)timeRangeType)) {
            Map<String, String> timeRange = AppProHomePageHelper.coversTimePeriod(timeRangeType);
            if (HRStringUtils.isNotEmpty((String)timeRange.get("startdate"))) {
                qFilter.and("createtime", ">", (Object)LocalDate.parse(timeRange.get("startdate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
            if (HRStringUtils.isNotEmpty((String)timeRange.get("enddate"))) {
                qFilter.and("createtime", "<", (Object)LocalDate.parse(timeRange.get("enddate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
        }
        return qFilter.toArray();
    }

    public static QFilter[] getTobeFilterBackedQFilter(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter qFilter = new QFilter("position", "in", positionIds);
        qFilter.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        qFilter.and(new QFilter("filterstatus", "like", (Object)"%1%"));
        qFilter.and(new QFilter(FILTER_APPFILE_RECRUSTGTYP, "=", (Object)1010L));
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter(POS_RECR, "=", (Object)recruitProcId));
        }
        return qFilter.toArray();
    }

    public static QFilter[] getTobeFilterToArrangeQFilter(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter qFilter = new QFilter("position", "in", positionIds);
        qFilter.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        qFilter.and(new QFilter(FILTER_APPFILE_RECRUSTGTYP, "=", (Object)1020L));
        qFilter.and(new QFilter("intvprogress", "not in", (Object)new String[]{"A", "C"}));
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter(POS_RECR, "=", (Object)recruitProcId));
        }
        return qFilter.toArray();
    }

    public static QFilter[] getTobeFilterToEvalQFilter(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter qFilter = new QFilter("position", "in", positionIds);
        qFilter.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        qFilter.and(new QFilter(FILTER_APPFILE_RECRUSTGTYP, "=", (Object)1020L));
        qFilter.and(new QFilter("intvprogress", "in", (Object)"A"));
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter(POS_RECR, "=", (Object)recruitProcId));
        }
        return qFilter.toArray();
    }

    public static QFilter[] getTobeFilterToPushQFilter(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter qFilter = new QFilter("position", "in", positionIds);
        qFilter.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        qFilter.and(new QFilter(FILTER_APPFILE_RECRUSTGTYP, "=", (Object)1020L));
        qFilter.and(new QFilter("intvprogress", "in", (Object)"C"));
        if (recruitProcId != 0L) {
            qFilter.and(new QFilter(POS_RECR, "=", (Object)recruitProcId));
        }
        return qFilter.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryFilterFinishedAppFileIdSet(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        DataSet finish = null;
        QFilter[] qFilters = AppProHomePageHelper.getTobeFilterBackedQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        HashSet appFileIdSet = Sets.newHashSet();
        try (DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.queryFilterFinishedAppFileIdSet.a", "id,recrustg,recrustat,recruproc", qFilters);){
            finish = dataSet.select("id");
            finish.forEach(row -> appFileIdSet.add(row.getLong("id")));
        }
        finally {
            if (finish != null) {
                finish.close();
            }
        }
        return appFileIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryTobeInterviewedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppProHomePageHelper.getTobeFilterToEvalQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        HashSet appFileIdSet = Sets.newHashSet();
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getInterviewCandidateData.a", "id,recrustg,recrustat,recruproc", qFilters);){
            finish = dataSet.select("id");
            finish.forEach(row -> appFileIdSet.add(row.getLong("id")));
        }
        return appFileIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryToBeAdvancedAppFileIdList(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        HRBaseServiceHelper appFileHelper = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = AppProHomePageHelper.getTobeFilterToPushQFilter(isOwner, recruitProcId, timeRangeType, positionIds);
        HashSet appFileIdSet = Sets.newHashSet();
        try (DataSet finish = null;
             DataSet dataSet = appFileHelper.queryDataSet("AppFileDataHelper.getInterviewCandidateData.a", "id,recrustg,recrustat,recruproc", qFilters);){
            finish = dataSet.select("id");
            finish.forEach(row -> appFileIdSet.add(row.getLong("id")));
        }
        return appFileIdSet;
    }

    public static Map<String, Integer> getChangeCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        QFilter[] waitChangeQFilter = AppProHomePageHelper.getWaitChangeQFilter(isOwner, recruitProcId, startDate, positionIds);
        result.put("begin", APP_FILE_HELPER.queryOriginalArray("id", waitChangeQFilter).length);
        QFilter[] changingQFilter = AppProHomePageHelper.getChangingQFilter(isOwner, recruitProcId, startDate, positionIds);
        result.put("in", APP_FILE_HELPER.queryOriginalArray("id", changingQFilter).length);
        return result;
    }

    public static Map<String, Integer> getHireCandidateData(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType));
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        QFilter[] waitedHireQFilter = AppProHomePageHelper.getWaitedHireQFilter(isOwner, recruitProcId, startDate, positionIds);
        result.put("begin", APP_FILE_HELPER.queryOriginalArray("id", waitedHireQFilter).length);
        QFilter[] hireAuditingQFilter = AppProHomePageHelper.getHireAuditingQFilter(isOwner, recruitProcId, startDate, positionIds);
        result.put("in", APP_FILE_HELPER.queryOriginalArray("id", hireAuditingQFilter).length);
        return result;
    }

    public static Set<Long> getWaitedHireIds(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter[] waitedHireQFilter = AppProHomePageHelper.getWaitedHireQFilter(isOwner, recruitProcId, DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType)), positionIds);
        DynamicObject[] objects = APP_FILE_HELPER.queryOriginalArray("id", waitedHireQFilter);
        return Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getHireAuditingIds(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter[] hireAuditingQFilter = AppProHomePageHelper.getHireAuditingQFilter(isOwner, recruitProcId, DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType)), positionIds);
        DynamicObject[] objects = APP_FILE_HELPER.queryOriginalArray("id", hireAuditingQFilter);
        return Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getWaitChangeIds(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter[] waitChangeQFilter = AppProHomePageHelper.getWaitChangeQFilter(isOwner, recruitProcId, DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType)), positionIds);
        DynamicObject[] objects = APP_FILE_HELPER.queryOriginalArray("id", waitChangeQFilter);
        return Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getChangingIds(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> positionIds) {
        QFilter[] changingQFilter = AppProHomePageHelper.getChangingQFilter(isOwner, recruitProcId, DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType)), positionIds);
        DynamicObject[] objects = APP_FILE_HELPER.queryOriginalArray("id", changingQFilter);
        return Arrays.stream(objects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static QFilter[] getWaitedHireQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, List<Long> positionIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_recrustgnew");
        List collectId = Arrays.stream(helper.loadDynamicObjectArray(new QFilter[]{new QFilter("group.id", "=", (Object)1050L)})).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter fourthQf = new QFilter("recrustg.id", "in", collectId);
        fourthQf.and(new QFilter("employapprlsatatus", "in", Arrays.asList(" ", "A", "F", "G")));
        fourthQf.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        if (null != startDate) {
            fourthQf.and(new QFilter("enterlinktime", ">=", (Object)startDate));
        }
        if (recruitProcId == 0L) {
            return new QFilter[]{new QFilter("position", "in", positionIds), fourthQf};
        }
        return new QFilter[]{new QFilter("position", "in", positionIds), new QFilter(POS_RECR, "=", (Object)recruitProcId), fourthQf};
    }

    public static QFilter[] getHireAuditingQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, List<Long> positionIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_recrustgnew");
        List collectId = Arrays.stream(helper.loadDynamicObjectArray(new QFilter[]{new QFilter("group.id", "=", (Object)1050L)})).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter fourthQf = new QFilter("recrustg.id", "in", collectId);
        fourthQf.and(new QFilter("employapprlsatatus", "in", Arrays.asList("B", "D")));
        fourthQf.and(new QFilter("filestatus", "=", (Object)AppFileStatusEnum.IN_PROCESS.getValue()));
        if (null != startDate) {
            fourthQf.and(new QFilter("enterlinktime", ">=", (Object)startDate));
        }
        if (recruitProcId == 0L) {
            return new QFilter[]{new QFilter("position", "in", positionIds), fourthQf};
        }
        return new QFilter[]{new QFilter("position", "in", positionIds), new QFilter(POS_RECR, "=", (Object)recruitProcId), fourthQf};
    }

    public static QFilter[] getWaitChangeQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, List<Long> positionIds) {
        QFilter qFilter = new QFilter("filestatus", "=", (Object)AppFileStatusEnum.TBEMP.getValue());
        if (null != startDate) {
            qFilter.and(new QFilter("enterlinktime", ">=", (Object)startDate));
        }
        if (recruitProcId == 0L) {
            return new QFilter[]{new QFilter("position", "in", positionIds), qFilter};
        }
        return new QFilter[]{new QFilter("position", "in", positionIds), new QFilter(POS_RECR, "=", (Object)recruitProcId), qFilter};
    }

    public static QFilter[] getChangingQFilter(boolean isOwner, Long recruitProcId, LocalDate startDate, List<Long> positionIds) {
        QFilter qFilter = new QFilter("filestatus", "=", (Object)AppFileStatusEnum.EMPED.getValue());
        if (null != startDate) {
            qFilter.and(new QFilter("enterlinktime", ">=", (Object)startDate));
        }
        if (recruitProcId == 0L) {
            return new QFilter[]{new QFilter("position", "in", positionIds), qFilter};
        }
        return new QFilter[]{new QFilter("position", "in", positionIds), new QFilter(POS_RECR, "=", (Object)recruitProcId), qFilter};
    }

    public static Map<String, String> coversTimePeriod(String timeFilterType) {
        String endTime;
        String startTime;
        if ("past_one_year".equals(timeFilterType)) {
            startTime = LocalDate.now().minusYears(1L).getYear() + "-" + "01-01 00:00:00";
            endTime = LocalDate.now().minusYears(1L).getYear() + "-" + "12-31 23:59:59";
        } else {
            LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeFilterType));
            startTime = DateUtils.getDayStartTime((LocalDate)startDate);
            endTime = DateUtils.getDayEndTime((LocalDate)LocalDate.now().plusDays(1L));
        }
        HashMap<String, String> timePeriod = new HashMap<String, String>(2);
        timePeriod.put("startdate", startTime);
        timePeriod.put("enddate", endTime);
        return timePeriod;
    }
}

