/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.appfile.service.header;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.service.header.AbstractHeaderService;
import kd.tsc.tsirm.business.domain.pc.helper.RsmPubScopeHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.ResumeIntegrityService;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.factory.IntegrityFactory;
import kd.tsc.tsirm.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import org.apache.commons.lang3.StringUtils;

public class AppFileHeaderService
extends AbstractHeaderService {
    private static final Map<String, String> LOCK_MAP = Maps.newHashMapWithExpectedSize((int)2);
    private static final Map<String, String> APP_FILE_STATUS_BC = Maps.newHashMapWithExpectedSize((int)2);
    private static final Map<String, String> HIDE_ITEM_MAP = Maps.newHashMapWithExpectedSize((int)2);
    private static final String PAGE_LOCKINFOVIEW = "tsirm_appfileflowlockinfo";
    private static final long serialVersionUID = -9069089998736724202L;

    public List<String> getHideItemList(IFormView view) {
        Object pkId;
        String hideItems;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        list.add("flexpanelap73");
        list.add("flexpanelap10");
        boolean hide = false;
        String string = hideItems = HIDE_ITEM_MAP.get(view.getParentView().getFormShowParameter().getFormId()) == null ? HIDE_ITEM_MAP.get(view.getParentView().getPageCache().get("parent_key")) : HIDE_ITEM_MAP.get(view.getParentView().getFormShowParameter().getFormId());
        if (null != hideItems) {
            String[] splits = hideItems.split(",");
            list.addAll(Arrays.asList(splits));
        }
        if (null != (pkId = view.getFormShowParameter().getCustomParam("id"))) {
            String appFileStatus;
            HRBaseServiceHelper appFileHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_appfilemdl");
            DynamicObject appFile = appFileHelper.queryOne(pkId);
            DynamicObject deliveryRec = appFile.getDynamicObject("deliveryrec");
            int repeatDeliveryCount = 0;
            if (deliveryRec != null) {
                Long id = appFile.getLong("id");
                repeatDeliveryCount = AppFileHelper.queryRepeatDeliveryCount(id);
            }
            if (repeatDeliveryCount < 2) {
                list.add("flexpanelap12");
            }
            if ("B,C,E,F".contains(appFileStatus = appFile.getString("filestatus"))) {
                hide = true;
            }
        }
        this.setPhotoHide(view, hide);
        return list;
    }

    public List<String> getClickListeners() {
        return Lists.newArrayList((Object[])new String[]{"flexpanelap7", "labelap", "vectorap", "vectorap7", "blacklisticon", "vectorap11", "labelap11", "applyposition", "flexpanelap13", "vectorap6", "flexpanelap71", "labelap1", "vectorap1", "labelap111", "vectorap112", "applypositionflex"});
    }

    public List<String> getItemClickListeners() {
        return null;
    }

    public void initData(IFormView view) {
        IDataModel model = view.getModel();
        FormShowParameter parameter = view.getFormShowParameter();
        Object pkId = parameter.getCustomParam("id");
        if (null != pkId) {
            HRBaseServiceHelper appFileHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_appfilemdl");
            DynamicObject appFile = appFileHelper.queryOne(pkId);
            String appFileStatus = appFile.getString("filestatus");
            model.setValue("filestatus", (Object)Objects.requireNonNull(AppFileStatusEnum.getEnum((String)appFileStatus)).getText().loadKDString());
            String backAndForeColor = APP_FILE_STATUS_BC.get(appFileStatus);
            String[] split = backAndForeColor.split(",");
            HashMap ctrl = Maps.newHashMapWithExpectedSize((int)2);
            ctrl.put("bc", split[0]);
            view.updateControlMetadata("flexpanelap14", (Map)ctrl);
            HashMap foreColorMap = Maps.newHashMapWithExpectedSize((int)2);
            foreColorMap.put("fc", split[1]);
            view.updateControlMetadata("filestatus", (Map)foreColorMap);
            model.setValue("fullname", (Object)appFile.getString("name"));
            model.setValue("number", (Object)appFile.getString("number"));
            DynamicObject resume = appFile.getDynamicObject("appres");
            ResumeIntegrityService service = IntegrityFactory.getResumeIntegrityService("tsirm_rsm");
            this.setPhoto(view, resume.getString("photo"));
            DynamicObject gender = resume.getDynamicObject("gender");
            model.setValue("gender", (Object)gender);
            int workYearsNum = resume.getInt("workingyears");
            String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workYearsNum);
            model.setValue("workexp", (Object)workYearShow);
            model.setValue("highestedu", (Object)appFile.getString("highesteducation.name"));
            String recentPosition = resume.getString("recentposition");
            model.setValue("recentposition", (Object)recentPosition);
            model.setValue("company", (Object)resume.getString("recentcompany"));
            Optional.ofNullable(RsmPubScopeHelper.selectEmpCvPosOrgRel(resume.getLong("id"))).ifPresent(posOrgRel -> model.setValue("org", (Object)posOrgRel.getString("adminorg.name")));
            model.setValue("phone", (Object)appFile.getString("phone"));
            model.setValue("email", (Object)appFile.getString("email"));
            DynamicObject position = appFile.getDynamicObject("position");
            if (Objects.nonNull(position)) {
                view.getPageCache().put("applyposition", position.getString("id"));
                model.setValue("applyposition", (Object)position.getString("name"));
            }
            this.setDeliveryInfo(model, resume.getLong("id"));
            this.setStdRsmInfo(view, appFile.getLong("stdrsm.id"));
            this.setAppFileLinkStatus(appFile, model);
            this.setLock(appFile, view);
        }
    }

    public void click(IFormView view, String key) {
        FormShowParameter parameter = view.getFormShowParameter();
        Object pkId = parameter.getCustomParam("id");
        DynamicObject appFile = AppFileHelper.queryOne(Long.parseLong(pkId.toString()));
        long stdRsmId = appFile.getLong("stdrsm.id");
        if (key.equals("vectorap7")) {
            this.showRepeatDeliveryPage(view, appFile);
        } else if (key.equals("vectorap6")) {
            this.showStdRsmPage(view, stdRsmId);
        } else if (StringUtils.equals((CharSequence)"labelap", (CharSequence)key) || StringUtils.equals((CharSequence)"vectorap", (CharSequence)key)) {
            this.openSuspectedPage(view, stdRsmId);
        } else if (StringUtils.equals((CharSequence)"vectorap1", (CharSequence)key) || StringUtils.equals((CharSequence)"labelap1", (CharSequence)key)) {
            this.openBlacklistInfoPage(view, stdRsmId);
        } else if (StringUtils.equals((CharSequence)"vectorap11", (CharSequence)key) || StringUtils.equals((CharSequence)"labelap11", (CharSequence)key) || "labelap111".equals(key) || "vectorap112".equals(key)) {
            DynamicObject flowLockInfo = AppFileFlowLockHelper.getFlowLockInfo(stdRsmId);
            if (flowLockInfo != null) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(PAGE_LOCKINFOVIEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("data", (Object)DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{flowLockInfo}, (DynamicObjectType)flowLockInfo.getDynamicObjectType()));
                view.showForm(showParameter);
            } else {
                view.showTipNotification(TSCBaseKDString.dataChangedTip());
            }
        } else if (StringUtils.equals((CharSequence)"applypositionflex", (CharSequence)key)) {
            DynamicObject position = appFile.getDynamicObject("position");
            if (null != position) {
                String appId = view.getFormShowParameter().getAppId();
                if ("tsirm_head_tsivptemplate".equals(view.getEntityId())) {
                    String fromViewStr = (String)view.getFormShowParameter().getCustomParam("fromView");
                    Long taskId = (Long)view.getFormShowParameter().getCustomParam("taskId");
                    AppFileHelper.showPositionViewForInterView(position.getLong("id"), view, fromViewStr, taskId);
                } else {
                    String parentFormId = view.getFormShowParameter().getParentFormId();
                    if (PositionDataHelper.hasPositionPerm(position.getLong("id")) || parentFormId.equals("tsirm_appfile_viewc")) {
                        AppFileHelper.showPositionFormView(position.getLong("id"), view);
                    } else {
                        AppFileHelper.showErrorNotification(position, view);
                    }
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"AppFileHeaderService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)"flexpanelap13", (CharSequence)key)) {
            this.showProccessPage(view);
        }
    }

    private void showProccessPage(IFormView formView) {
        FormShowParameter parentParameter = formView.getParentView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        if ("tsirm_intvevaltaskir".equals(parentParameter.getFormId())) {
            showParameter.setCustomParam("appFileId", parentParameter.getCustomParam("appFileId"));
        } else {
            IDataModel model = formView.getParentView().getModel();
            showParameter.setCustomParam("appFileId", model.getValue("id"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("tsirm_appfileproc");
        formView.showForm(showParameter);
    }

    public void savePhoto(Object objId, String url) {
        HRBaseServiceHelper appFileHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_appfile");
        DynamicObject appFile = appFileHelper.queryOne(objId);
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_srrsm");
        long rsmId = appFile.getLong("appres.id");
        DynamicObject appRes = serviceHelper.loadSingle((Object)rsmId);
        if (!HRStringUtils.isEmpty((String)url) && appRes != null) {
            appRes.set("photo", (Object)url);
            serviceHelper.updateOne(appRes);
            AppResumeBo appResumeBo = new AppResumeBo(appRes);
            ResumeBoHelper.loadAllListData(appResumeBo);
            AddResumeService.diffUpdateStandResume(appRes.getLong("stdrsm"), appResumeBo);
        }
    }

    private void setLock(DynamicObject appFile, IFormView view) {
        Map<Long, String> flowLockData;
        String flowLockStatus;
        String color;
        String formId;
        IFormView parentView = view.getParentView();
        if (null != parentView && StringUtils.equals((CharSequence)(formId = parentView.getFormShowParameter().getFormId()), (CharSequence)"tsirm_qacheck")) {
            view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap711", "flexpanelap7111"});
        }
        if (HRStringUtils.isEmpty((String)(color = LOCK_MAP.get(flowLockStatus = (flowLockData = AppFileFlowLockHelper.getFlowLockData((List<DynamicObject>)ImmutableList.of((Object)appFile))).get(appFile.getLong("id")))))) {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap711", "flexpanelap7111"});
        } else if (flowLockStatus.equals("1")) {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap711"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap7111"});
        }
    }

    private void setAppFileLinkStatus(DynamicObject appFile, IDataModel model) {
        DynamicObject recruStg = appFile.getDynamicObject("recrustg");
        DynamicObject recruStat = appFile.getDynamicObject("recrustat");
        if (recruStg != null) {
            String recruStatName = recruStat == null ? ResManager.loadKDString((String)"\u65e0", (String)"AppFileHeadPlugin_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]) : recruStat.getString("name");
            model.setValue("textfield3", (Object)String.format("%s-%s", recruStg.getString("name"), recruStatName));
        }
    }

    private void showRepeatDeliveryPage(IFormView view, DynamicObject dataEntity) {
        FormShowParameter showParameter = new FormShowParameter();
        int repeatDeliveryCount = AppFileHelper.queryRepeatDeliveryCount(dataEntity.getLong("id"));
        showParameter.setPageId(view.getPageId() + "repeatdelnum" + repeatDeliveryCount);
        showParameter.setFormId("tsirm_rdeliverylist");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("id", (Object)dataEntity.getLong("id"));
        showParameter.setCustomParam("number", (Object)dataEntity.getString("number"));
        showParameter.setCustomParam("fullname", (Object)dataEntity.getString("name"));
        DynamicObject position = dataEntity.getDynamicObject("position");
        if (position != null) {
            showParameter.setCustomParam("recruposi", (Object)position.getLong("id"));
        }
        showParameter.setCustomParam("repeatdelnum", (Object)repeatDeliveryCount);
        view.showForm(showParameter);
    }

    private void showStdRsmPage(IFormView view, long stdRsmId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tsirm_candidate_detail");
        parameter.setCustomParam("id", (Object)stdRsmId);
        parameter.setCustomParam("type", (Object)"1");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(parameter);
    }

    static {
        LOCK_MAP.put("1", "#276FF5");
        LOCK_MAP.put("2", "#666666");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.IN_PROCESS.getValue(), "#276FF5,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.TBEMP.getValue(), "#276FF5,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.OUT.getValue(), "#666666,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.INVALID.getValue(), "#1BA854,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.EMPED.getValue(), "#276FF5,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.ENDEMP.getValue(), "#666666,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.EXPIRED.getValue(), "#666666,#FFFFFF");
        HIDE_ITEM_MAP.put("tsirm_hirerecworkflow", "flexpanelap7,flexpanelap7111,flexpanelap711,flexpanelap11,flexpanelap12");
        HIDE_ITEM_MAP.put("tsirm_jobrankworkflow", "flexpanelap7,flexpanelap7111,flexpanelap711,flexpanelap11,flexpanelap12");
        HIDE_ITEM_MAP.put("tsirm_hiresalaryflow", "flexpanelap7,flexpanelap7111,flexpanelap711,flexpanelap11,flexpanelap12");
        HIDE_ITEM_MAP.put("tsirm_resumefilterir", "flexpanelap7,flexpanelap7111,flexpanelap711,flexpanelap11,flexpanelap12");
        HIDE_ITEM_MAP.put("tsirm_intvevaltaskir", "flexpanelap7,flexpanelap7111,flexpanelap711,flexpanelap11,flexpanelap12");
        HIDE_ITEM_MAP.put("tsrbs_commrec", "flexpanelap71,flexpanelap72,labelap3,applyposition,flexpanelap7,flexpanelap711,flexpanelap711,flexpanelap11,flexpanelap12,flexpanelap7111");
        HIDE_ITEM_MAP.put("offerlist", "flexpanelap7,flexpanelap12");
        HIDE_ITEM_MAP.put("tso_offerbase_info", "flexpanelap7,flexpanelap12");
    }
}

